/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.worldgen.GTLayerPattern;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGenLayers;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import com.gregtechceu.gtceu.api.data.worldgen.generator.IndicatorGenerators;
import com.gregtechceu.gtceu.api.data.worldgen.generator.VeinGenerators;
import com.gregtechceu.gtceu.api.data.worldgen.generator.indicators.SurfaceIndicatorGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.DikeVeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.VeinedVeinGenerator;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class GTOres {
    private static int largestVeinSize = 0;
    private static int largestIndicatorOffset = 0;
    private static final Map<ResourceLocation, GTOreDefinition> toReRegister = new HashMap<ResourceLocation, GTOreDefinition>();
    public static RuleTest[] END_RULES;
    public static final GTOreDefinition BAUXITE_VEIN_END;
    public static final GTOreDefinition MAGNETITE_VEIN_END;
    public static final GTOreDefinition NAQUADAH_VEIN;
    public static final GTOreDefinition PITCHBLENDE_VEIN;
    public static final GTOreDefinition SCHEELITE_VEIN;
    public static final GTOreDefinition SHELDONITE_VEIN;
    public static RuleTest[] NETHER_RULES;
    public static final GTOreDefinition BANDED_IRON_VEIN;
    public static final GTOreDefinition BERYLLIUM_VEIN;
    public static final GTOreDefinition CERTUS_QUARTZ_VEIN;
    public static final GTOreDefinition MANGANESE_VEIN;
    public static final GTOreDefinition MOLYBDENUM_VEIN;
    public static final GTOreDefinition MONAZITE_VEIN;
    public static final GTOreDefinition NETHER_QUARTZ_VEIN;
    public static final GTOreDefinition REDSTONE_VEIN;
    public static final GTOreDefinition SALTPETER_VEIN;
    public static final GTOreDefinition SULFUR_VEIN;
    public static final GTOreDefinition TETRAHEDRITE_VEIN;
    public static final GTOreDefinition TOPAZ_VEIN;
    public static RuleTest[] OVERWORLD_RULES;
    public static final GTOreDefinition APATITE_VEIN;
    public static final GTOreDefinition CASSITERITE_VEIN;
    public static final GTOreDefinition COAL_VEIN;
    public static final GTOreDefinition COPPER_TIN_VEIN;
    public static final GTOreDefinition GALENA_VEIN;
    public static final GTOreDefinition GARNET_TIN_VEIN;
    public static final GTOreDefinition GARNET_VEIN;
    public static final GTOreDefinition IRON_VEIN;
    public static final GTOreDefinition LUBRICANT_VEIN;
    public static final GTOreDefinition MAGNETITE_VEIN_OW;
    public static final GTOreDefinition MINERAL_SAND_VEIN;
    public static final GTOreDefinition NICKEL_VEIN;
    public static final GTOreDefinition SALTS_VEIN;
    public static final GTOreDefinition OILSANDS_VEIN;
    public static RuleTest[] DEEPSLATE_RULES;
    public static final GTOreDefinition COPPER_VEIN;
    public static final GTOreDefinition DIAMOND_VEIN;
    public static final GTOreDefinition LAPIS_VEIN;
    public static final GTOreDefinition MANGANESE_VEIN_OW;
    public static final GTOreDefinition MICA_VEIN;
    public static final GTOreDefinition OLIVINE_VEIN;
    public static final GTOreDefinition REDSTONE_VEIN_OW;
    public static final GTOreDefinition SAPPHIRE_VEIN;

    private static GTOreDefinition create(String name, int clusterSize, float density, int weight, WorldGenLayers layer, Set<ResourceKey<Level>> dimensionFilter, HeightRangePlacement range) {
        ResourceLocation id = GTCEu.id(name);
        GTOreDefinition def = new GTOreDefinition(id, clusterSize, density, weight, layer, dimensionFilter, range, 0.0f, null, null, null, null);
        toReRegister.put(id, def);
        return def;
    }

    private static Supplier<? extends Block> ore(TagPrefix oreTag, Material material) {
        BlockEntry block = (BlockEntry)GTBlocks.MATERIAL_BLOCKS.get((Object)oreTag, (Object)material);
        if (block == null) {
            ResourceLocation oreKey = oreTag == TagPrefix.ore ? new ResourceLocation("%s_ore".formatted(material.getName())) : (oreTag == TagPrefix.oreNetherrack ? new ResourceLocation("nether_%s_ore".formatted(material.getName())) : new ResourceLocation("%s_%s_ore".formatted(oreTag.name, material.getName())));
            return BuiltInRegistries.f_256975_.m_7804_(oreKey) ? () -> (Block)BuiltInRegistries.f_256975_.m_7745_(oreKey) : () -> Blocks.f_50016_;
        }
        return block;
    }

    public static Set<ResourceKey<Level>> overworld() {
        return Set.of(Level.f_46428_);
    }

    public static Set<ResourceKey<Level>> nether() {
        return Set.of(Level.f_46429_);
    }

    public static Set<ResourceKey<Level>> end() {
        return Set.of(Level.f_46430_);
    }

    public static void init() {
        toReRegister.forEach(GTRegistries.ORE_VEINS::registerOrOverride);
    }

    public static void updateLargestVeinSize() {
        largestVeinSize = GTRegistries.ORE_VEINS.values().stream().map(GTOreDefinition::getClusterSize).max(Integer::compareTo).orElse(0);
        largestIndicatorOffset = GTRegistries.ORE_VEINS.values().stream().flatMap(definition -> definition.getIndicatorGenerators().stream().map(indicatorGenerator -> indicatorGenerator.getSearchRadiusModifier((int)Math.ceil((double)definition.getClusterSize() / 2.0)))).max(Integer::compareTo).orElse(0);
    }

    public static int getLargestVeinSize() {
        return largestVeinSize;
    }

    public static int getLargestIndicatorOffset() {
        return largestIndicatorOffset;
    }

    static {
        VeinGenerators.registerAddonGenerators();
        IndicatorGenerators.registerAddonGenerators();
        END_RULES = new RuleTest[]{WorldGeneratorUtils.END_ORE_REPLACEABLES};
        BAUXITE_VEIN_END = GTOres.create("bauxite_vein_end", 30, 0.3f, 40, WorldGenLayers.ENDSTONE, GTOres.end(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)10), (VerticalAnchor)VerticalAnchor.m_158922_((int)80))).biomes((TagKey<Biome>)BiomeTags.f_215818_).layeredVeinGenerator().withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(END_RULES).layer(l -> l.weight(2).state(() -> ((Block)Blocks.f_50259_).m_49966_()).size(1, 6)).layer(l -> l.weight(2).mat(GTMaterials.Bauxite).size(1, 4)).layer(l -> l.weight(1).mat(GTMaterials.Ilmenite).size(1, 2)).layer(l -> l.weight(1).mat(GTMaterials.Aluminium).size(1, 1)).build())).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Bauxite).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE));
        MAGNETITE_VEIN_END = GTOres.create("magnetite_vein_end", 35, 0.15f, 30, WorldGenLayers.ENDSTONE, GTOres.end(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)20), (VerticalAnchor)VerticalAnchor.m_158922_((int)80))).biomes((TagKey<Biome>)BiomeTags.f_215818_).layeredVeinGenerator().withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(END_RULES).layer(l -> l.weight(3).mat(GTMaterials.Magnetite).size(1, 4)).layer(l -> l.weight(2).mat(GTMaterials.VanadiumMagnetite).size(1, 2)).layer(l -> l.weight(2).mat(GTMaterials.Chromite).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Gold).size(1, 1)).build())).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Magnetite).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE));
        NAQUADAH_VEIN = GTOres.create("naquadah_vein", 40, 1.0f, 30, WorldGenLayers.ENDSTONE, GTOres.end(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)10), (VerticalAnchor)VerticalAnchor.m_158922_((int)90))).biomes((TagKey<Biome>)BiomeTags.f_215818_).veinedVeinGenerator().oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Naquadah, 3)).rareBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Plutonium239, 1)).rareBlockChance(0.25f).veininessThreshold(0.1f).maxRichnessThreshold(0.3f).minRichness(0.3f).maxRichness(0.5f).edgeRoundoffBegin(10).minYLevel(10).maxYLevel(90).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Naquadah).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE));
        PITCHBLENDE_VEIN = GTOres.create("pitchblende_vein_end", 30, 1.0f, 30, WorldGenLayers.ENDSTONE, GTOres.end(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)30), (VerticalAnchor)VerticalAnchor.m_158922_((int)60))).biomes((TagKey<Biome>)BiomeTags.f_215818_).veinedVeinGenerator().oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Pitchblende, 3)).rareBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Uraninite, 2)).rareBlockChance(0.33f).veininessThreshold(0.1f).maxRichnessThreshold(0.4f).minRichness(0.2f).maxRichness(0.5f).edgeRoundoffBegin(12).minYLevel(30).maxYLevel(60).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Pitchblende).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE));
        SCHEELITE_VEIN = GTOres.create("scheelite_vein", 30, 0.2f, 20, WorldGenLayers.ENDSTONE, GTOres.end(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)20), (VerticalAnchor)VerticalAnchor.m_158922_((int)60))).biomes((TagKey<Biome>)BiomeTags.f_215818_).dikeVeinGenerator().withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Scheelite, 3, 20, 60)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Tungstate, 2, 35, 55)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Lithium, 1, 20, 40)).minYLevel(20).maxYLevel(60).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Scheelite).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE));
        SHELDONITE_VEIN = GTOres.create("sheldonite_vein", 25, 0.2f, 10, WorldGenLayers.ENDSTONE, GTOres.end(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)5), (VerticalAnchor)VerticalAnchor.m_158922_((int)50))).biomes((TagKey<Biome>)BiomeTags.f_215818_).layeredVeinGenerator().withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(END_RULES).layer(l -> l.weight(3).mat(GTMaterials.Bornite).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Cooperite).size(1, 1)).layer(l -> l.weight(2).mat(GTMaterials.Platinum).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Palladium).size(1, 1)).build())).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Platinum).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE));
        NETHER_RULES = new RuleTest[]{new TagMatchTest(BlockTags.f_215835_)};
        BANDED_IRON_VEIN = GTOres.create("banded_iron_vein", 40, 1.0f, 30, WorldGenLayers.NETHERRACK, GTOres.nether(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)20), (VerticalAnchor)VerticalAnchor.m_158922_((int)40))).biomes((TagKey<Biome>)BiomeTags.f_207612_).veinedVeinGenerator().oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Goethite, 3)).oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.YellowLimonite, 2)).oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Hematite, 2)).rareBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Gold, 1)).rareBlockChance(0.075f).veininessThreshold(0.1f).maxRichnessThreshold(0.4f).minRichness(0.2f).maxRichness(0.5f).edgeRoundoffBegin(12).minYLevel(20).maxYLevel(40).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Goethite).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE));
        BERYLLIUM_VEIN = GTOres.create("beryllium_vein", 30, 0.25f, 30, WorldGenLayers.NETHERRACK, GTOres.nether(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)5), (VerticalAnchor)VerticalAnchor.m_158922_((int)30))).biomes((TagKey<Biome>)BiomeTags.f_207612_).dikeVeinGenerator().withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Beryllium, 3, 5, 30)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Emerald, 2, 5, 19)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Emerald, 2, 16, 30)).minYLevel(5).maxYLevel(30).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Beryllium).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE));
        CERTUS_QUARTZ_VEIN = GTOres.create("certus_quartz", 25, 0.25f, 40, WorldGenLayers.NETHERRACK, GTOres.nether(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)80), (VerticalAnchor)VerticalAnchor.m_158922_((int)120))).biomes((TagKey<Biome>)BiomeTags.f_207612_).layeredVeinGenerator().withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(NETHER_RULES).layer(l -> l.weight(3).mat(GTMaterials.Quartzite).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.CertusQuartz).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Barite).size(1, 1)).build())).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.CertusQuartz).placement(SurfaceIndicatorGenerator.IndicatorPlacement.BELOW));
        MANGANESE_VEIN = GTOres.create("manganese_vein", 30, 0.25f, 20, WorldGenLayers.NETHERRACK, GTOres.nether(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)20), (VerticalAnchor)VerticalAnchor.m_158922_((int)30))).biomes((TagKey<Biome>)BiomeTags.f_207612_).dikeVeinGenerator().withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Grossular, 3, 20, 30)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Pyrolusite, 2, 20, 26)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Tantalite, 1, 24, 30)).minYLevel(20).maxYLevel(30).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Grossular).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE));
        MOLYBDENUM_VEIN = GTOres.create("molybdenum_vein", 25, 0.25f, 5, WorldGenLayers.NETHERRACK, GTOres.nether(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)20), (VerticalAnchor)VerticalAnchor.m_158922_((int)50))).biomes((TagKey<Biome>)BiomeTags.f_207612_).layeredVeinGenerator().withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(NETHER_RULES).layer(l -> l.weight(3).mat(GTMaterials.Wulfenite).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Molybdenite).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Molybdenum).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Powellite).size(1, 1)).build())).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Molybdenum).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE));
        MONAZITE_VEIN = GTOres.create("monazite_vein", 25, 0.25f, 30, WorldGenLayers.NETHERRACK, GTOres.nether(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)20), (VerticalAnchor)VerticalAnchor.m_158922_((int)40))).biomes((TagKey<Biome>)BiomeTags.f_207612_).layeredVeinGenerator().withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(NETHER_RULES).layer(l -> l.weight(3).mat(GTMaterials.Bastnasite).size(2, 4)).layer(l -> l.weight(1).mat(GTMaterials.Molybdenum).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Neodymium).size(1, 1)).build())).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Bastnasite).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE));
        NETHER_QUARTZ_VEIN = GTOres.create("nether_quartz_vein", 30, 0.2f, 80, WorldGenLayers.NETHERRACK, GTOres.nether(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)40), (VerticalAnchor)VerticalAnchor.m_158922_((int)80))).biomes((TagKey<Biome>)BiomeTags.f_207612_).layeredVeinGenerator().withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(NETHER_RULES).layer(l -> l.weight(2).state(() -> ((Block)Blocks.f_50134_).m_49966_()).size(2, 4)).layer(l -> l.weight(3).mat(GTMaterials.NetherQuartz).size(2, 4)).layer(l -> l.weight(1).mat(GTMaterials.Quartzite).size(1, 1)).build())).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.NetherQuartz).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE));
        REDSTONE_VEIN = GTOres.create("redstone_vein", 30, 0.2f, 60, WorldGenLayers.NETHERRACK, GTOres.nether(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)5), (VerticalAnchor)VerticalAnchor.m_158922_((int)40))).biomes((TagKey<Biome>)BiomeTags.f_207612_).layeredVeinGenerator().withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(NETHER_RULES).layer(l -> l.weight(3).mat(GTMaterials.Redstone).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Ruby).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Cinnabar).size(1, 1)).build())).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Redstone).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE));
        SALTPETER_VEIN = GTOres.create("saltpeter_vein", 30, 0.25f, 40, WorldGenLayers.NETHERRACK, GTOres.nether(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)5), (VerticalAnchor)VerticalAnchor.m_158922_((int)45))).biomes((TagKey<Biome>)BiomeTags.f_207612_).layeredVeinGenerator().withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(NETHER_RULES).layer(l -> l.weight(2).state(() -> ((Block)Blocks.f_50134_).m_49966_())).layer(l -> l.weight(3).mat(GTMaterials.Saltpeter).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Diatomite).size(1, 1)).layer(l -> l.weight(2).mat(GTMaterials.Electrotine).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Alunite).size(1, 1)).build())).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Saltpeter).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE));
        SULFUR_VEIN = GTOres.create("sulfur_vein", 30, 0.2f, 100, WorldGenLayers.NETHERRACK, GTOres.nether(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)10), (VerticalAnchor)VerticalAnchor.m_158922_((int)30))).biomes((TagKey<Biome>)BiomeTags.f_207612_).layeredVeinGenerator().withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(NETHER_RULES).layer(l -> l.weight(3).mat(GTMaterials.Sulfur).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Pyrite).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Sphalerite).size(1, 1)).build())).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Sulfur).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE));
        TETRAHEDRITE_VEIN = GTOres.create("tetrahedrite_vein", 40, 1.0f, 70, WorldGenLayers.NETHERRACK, GTOres.nether(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)80), (VerticalAnchor)VerticalAnchor.m_158922_((int)120))).biomes((TagKey<Biome>)BiomeTags.f_207612_).veinedVeinGenerator().oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Tetrahedrite, 4)).oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Copper, 2)).rareBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Stibnite, 1)).rareBlockChance(0.15f).veininessThreshold(0.1f).maxRichnessThreshold(0.4f).minRichness(0.2f).maxRichness(0.5f).edgeRoundoffBegin(12).minYLevel(80).maxYLevel(120).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Tetrahedrite).placement(SurfaceIndicatorGenerator.IndicatorPlacement.BELOW));
        TOPAZ_VEIN = GTOres.create("topaz_vein", 25, 0.25f, 70, WorldGenLayers.NETHERRACK, GTOres.nether(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)80), (VerticalAnchor)VerticalAnchor.m_158922_((int)120))).biomes((TagKey<Biome>)BiomeTags.f_207612_).layeredVeinGenerator().withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(NETHER_RULES).layer(l -> l.weight(3).mat(GTMaterials.BlueTopaz).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Topaz).size(1, 1)).layer(l -> l.weight(2).mat(GTMaterials.Chalcocite).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Bornite).size(1, 1)).build())).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Topaz).placement(SurfaceIndicatorGenerator.IndicatorPlacement.BELOW));
        OVERWORLD_RULES = new RuleTest[]{new TagMatchTest(BlockTags.f_144266_)};
        APATITE_VEIN = GTOres.create("apatite_vein", 30, 0.25f, 40, WorldGenLayers.STONE, GTOres.overworld(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)10), (VerticalAnchor)VerticalAnchor.m_158922_((int)80))).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator().withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(3).mat(GTMaterials.Apatite).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.TricalciumPhosphate).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Pyrochlore).size(1, 1)).build())).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Apatite).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE));
        CASSITERITE_VEIN = GTOres.create("cassiterite_vein", 40, 1.0f, 80, WorldGenLayers.STONE, GTOres.overworld(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)10), (VerticalAnchor)VerticalAnchor.m_158922_((int)80))).biomes((TagKey<Biome>)BiomeTags.f_215817_).veinedVeinGenerator().oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Tin, 4)).rareBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Cassiterite, 2)).rareBlockChance(0.33f).veininessThreshold(0.1f).maxRichnessThreshold(0.4f).minRichness(0.2f).maxRichness(0.5f).edgeRoundoffBegin(12).minYLevel(10).maxYLevel(60).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Cassiterite));
        COAL_VEIN = GTOres.create("coal_vein", 35, 0.25f, 80, WorldGenLayers.STONE, GTOres.overworld(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)10), (VerticalAnchor)VerticalAnchor.m_158922_((int)140))).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator().withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(3).mat(GTMaterials.Coal).size(2, 4)).layer(l -> l.weight(3).mat(GTMaterials.Coal).size(2, 4)).build())).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Coal));
        COPPER_TIN_VEIN = GTOres.create("copper_tin_vein", 40, 1.0f, 50, WorldGenLayers.STONE, GTOres.overworld(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-10), (VerticalAnchor)VerticalAnchor.m_158922_((int)160))).biomes((TagKey<Biome>)BiomeTags.f_215817_).veinedVeinGenerator().oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Chalcopyrite, 5)).oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Zeolite, 2)).oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Cassiterite, 2)).rareBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Realgar, 1)).rareBlockChance(0.05f).veininessThreshold(0.1f).maxRichnessThreshold(0.4f).minRichness(0.2f).maxRichness(0.5f).edgeRoundoffBegin(12).minYLevel(-10).maxYLevel(160).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Chalcopyrite));
        GALENA_VEIN = GTOres.create("galena_vein", 30, 0.25f, 40, WorldGenLayers.STONE, GTOres.overworld(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-15), (VerticalAnchor)VerticalAnchor.m_158922_((int)45))).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator().withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(3).mat(GTMaterials.Galena).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Silver).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Lead).size(1, 1)).build())).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Galena));
        GARNET_TIN_VEIN = GTOres.create("garnet_tin_vein", 30, 0.2f, 80, WorldGenLayers.STONE, GTOres.overworld(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)30), (VerticalAnchor)VerticalAnchor.m_158922_((int)60))).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator().withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(2).state(() -> ((Block)Blocks.f_49992_).m_49966_())).layer(l -> l.weight(3).mat(GTMaterials.CassiteriteSand).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.GarnetSand).size(1, 1)).layer(l -> l.weight(2).mat(GTMaterials.Asbestos).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Diatomite).size(1, 1)).build())).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.GarnetSand));
        GARNET_VEIN = GTOres.create("garnet_vein", 30, 0.25f, 40, WorldGenLayers.STONE, GTOres.overworld(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-10), (VerticalAnchor)VerticalAnchor.m_158922_((int)50))).biomes((TagKey<Biome>)BiomeTags.f_215817_).dikeVeinGenerator().withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.GarnetRed, 3, -10, 50)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.GarnetYellow, 2, -10, 50)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Amethyst, 2, -10, 22)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Opal, 1, 18, 50)).minYLevel(-10).minYLevel(50).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.GarnetRed).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE));
        IRON_VEIN = GTOres.create("iron_vein", 40, 1.0f, 120, WorldGenLayers.STONE, GTOres.overworld(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-10), (VerticalAnchor)VerticalAnchor.m_158922_((int)60))).biomes((TagKey<Biome>)BiomeTags.f_215817_).veinedVeinGenerator().oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Goethite, 5)).oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.YellowLimonite, 2)).oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Hematite, 2)).oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Malachite, 1)).veininessThreshold(0.1f).maxRichnessThreshold(0.4f).minRichness(0.2f).maxRichness(0.5f).edgeRoundoffBegin(12).minYLevel(-10).maxYLevel(60).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Goethite));
        LUBRICANT_VEIN = GTOres.create("lubricant_vein", 25, 0.25f, 40, WorldGenLayers.STONE, GTOres.overworld(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)50))).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator().withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(3).mat(GTMaterials.Soapstone).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Talc).size(1, 1)).layer(l -> l.weight(2).mat(GTMaterials.GlauconiteSand).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Pentlandite).size(1, 1)).build())).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Talc));
        MAGNETITE_VEIN_OW = GTOres.create("magnetite_vein_ow", 35, 0.15f, 80, WorldGenLayers.STONE, GTOres.overworld(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)10), (VerticalAnchor)VerticalAnchor.m_158922_((int)60))).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator().withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(3).mat(GTMaterials.Magnetite).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.VanadiumMagnetite).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Gold).size(1, 1)).build())).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Magnetite));
        MINERAL_SAND_VEIN = GTOres.create("mineral_sand_vein", 30, 0.2f, 80, WorldGenLayers.STONE, GTOres.overworld(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)15), (VerticalAnchor)VerticalAnchor.m_158922_((int)60))).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator().withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(2).state(() -> ((Block)Blocks.f_49992_).m_49966_())).layer(l -> l.weight(3).mat(GTMaterials.BasalticMineralSand).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.GraniticMineralSand).size(1, 1)).layer(l -> l.weight(2).mat(GTMaterials.FullersEarth).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Gypsum).size(1, 1)).build())).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.BasalticMineralSand));
        NICKEL_VEIN = GTOres.create("nickel_vein", 30, 0.25f, 40, WorldGenLayers.STONE, GTOres.overworld(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-10), (VerticalAnchor)VerticalAnchor.m_158922_((int)60))).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator().withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(3).mat(GTMaterials.Garnierite).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Nickel).size(1, 1)).layer(l -> l.weight(2).mat(GTMaterials.Cobaltite).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Pentlandite).size(1, 1)).build())).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Nickel));
        SALTS_VEIN = GTOres.create("salts_vein", 30, 0.2f, 50, WorldGenLayers.STONE, GTOres.overworld(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)30), (VerticalAnchor)VerticalAnchor.m_158922_((int)70))).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator().withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(3).mat(GTMaterials.RockSalt).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Salt).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Lepidolite).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Spodumene).size(1, 1)).build())).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Salt));
        OILSANDS_VEIN = GTOres.create("oilsands_vein", 25, 0.3f, 40, WorldGenLayers.STONE, GTOres.overworld(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)30), (VerticalAnchor)VerticalAnchor.m_158922_((int)80))).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator().withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(3).mat(GTMaterials.Oilsands).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Oilsands).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Oilsands).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Oilsands).size(1, 1)).build())).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Oilsands));
        DEEPSLATE_RULES = new RuleTest[]{new TagMatchTest(BlockTags.f_144267_)};
        COPPER_VEIN = GTOres.create("copper_vein", 40, 1.0f, 80, WorldGenLayers.DEEPSLATE, GTOres.overworld(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-40), (VerticalAnchor)VerticalAnchor.m_158922_((int)10))).biomes((TagKey<Biome>)BiomeTags.f_215817_).veinedVeinGenerator().oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Chalcopyrite, 5)).oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Iron, 2)).oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Pyrite, 2)).oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Copper, 2)).veininessThreshold(0.1f).maxRichnessThreshold(0.4f).minRichness(0.2f).maxRichness(0.5f).edgeRoundoffBegin(12).minYLevel(-40).maxYLevel(-10).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Copper));
        DIAMOND_VEIN = GTOres.create("diamond_vein", 30, 0.25f, 40, WorldGenLayers.DEEPSLATE, GTOres.overworld(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-65), (VerticalAnchor)VerticalAnchor.m_158922_((int)-30))).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator().withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(3).mat(GTMaterials.Graphite).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Diamond).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Coal).size(1, 1)).build())).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Diamond).density(0.1f).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE).radius(2));
        LAPIS_VEIN = GTOres.create("lapis_vein", 40, 0.25f, 40, WorldGenLayers.DEEPSLATE, GTOres.overworld(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-60), (VerticalAnchor)VerticalAnchor.m_158922_((int)10))).biomes((TagKey<Biome>)BiomeTags.f_215817_).dikeVeinGenerator().withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Lazurite, 3, -60, 10)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Sodalite, 2, -50, 0)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Lapis, 2, -50, 0)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Calcite, 1, -40, 10)).minYLevel(-60).maxYLevel(10).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Lapis).density(0.15f).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE).radius(3));
        MANGANESE_VEIN_OW = GTOres.create("manganese_vein_ow", 50, 0.25f, 20, WorldGenLayers.DEEPSLATE, GTOres.overworld(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-30), (VerticalAnchor)VerticalAnchor.m_158922_((int)0))).biomes((TagKey<Biome>)BiomeTags.f_215817_).dikeVeinGenerator().withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Grossular, 3, 20, 30)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Spessartine, 2, 20, 30)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Pyrolusite, 2, 20, 26)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Tantalite, 1, 24, 30)).minYLevel(-50).maxYLevel(-5).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Grossular).radius(3));
        MICA_VEIN = GTOres.create("mica_vein", 30, 0.25f, 20, WorldGenLayers.DEEPSLATE, GTOres.overworld(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-40), (VerticalAnchor)VerticalAnchor.m_158922_((int)-10))).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator().withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(3).mat(GTMaterials.Kyanite).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Mica).size(1, 1)).layer(l -> l.weight(2).mat(GTMaterials.Bauxite).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Pollucite).size(1, 1)).build())).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Mica).radius(3));
        OLIVINE_VEIN = GTOres.create("olivine_vein", 30, 0.25f, 20, WorldGenLayers.DEEPSLATE, GTOres.overworld(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-20), (VerticalAnchor)VerticalAnchor.m_158922_((int)10))).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator().withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(3).mat(GTMaterials.Bentonite).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Magnetite).size(1, 1)).layer(l -> l.weight(2).mat(GTMaterials.Olivine).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.GlauconiteSand).size(1, 1)).build())).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Olivine).density(0.15f).radius(3));
        REDSTONE_VEIN_OW = GTOres.create("redstone_vein_ow", 30, 0.2f, 60, WorldGenLayers.DEEPSLATE, GTOres.overworld(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-65), (VerticalAnchor)VerticalAnchor.m_158922_((int)-10))).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator().withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(3).mat(GTMaterials.Redstone).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Ruby).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Cinnabar).size(1, 1)).build())).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Redstone));
        SAPPHIRE_VEIN = GTOres.create("sapphire_vein", 25, 0.25f, 60, WorldGenLayers.DEEPSLATE, GTOres.overworld(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-40), (VerticalAnchor)VerticalAnchor.m_158922_((int)0))).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator().withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(3).mat(GTMaterials.Almandine).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Pyrope).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Sapphire).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.GreenSapphire).size(1, 1)).build())).parent().surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Sapphire).density(0.15f).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE).radius(3));
    }
}

