/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IItemUIFactory;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.lowdragmc.lowdraglib.gui.factory.HeldItemUIFactory;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class IntCircuitBehaviour
implements IItemUIFactory,
IAddInformation {
    public static final int CIRCUIT_MAX = 32;

    public static ItemStack stack(int configuration) {
        ItemStack stack = GTItems.INTEGRATED_CIRCUIT.asStack();
        IntCircuitBehaviour.setCircuitConfiguration(stack, configuration);
        return stack;
    }

    public static void setCircuitConfiguration(HeldItemUIFactory.HeldItemHolder holder, int configuration) {
        IntCircuitBehaviour.setCircuitConfiguration(holder.getHeld(), configuration);
        holder.markAsDirty();
    }

    public static void setCircuitConfiguration(ItemStack itemStack, int configuration) {
        if (configuration < 0 || configuration > 32) {
            throw new IllegalArgumentException("Given configuration number is out of range!");
        }
        CompoundTag tagCompound = itemStack.m_41783_();
        if (tagCompound == null) {
            tagCompound = new CompoundTag();
            itemStack.m_41751_(tagCompound);
        }
        tagCompound.m_128405_("Configuration", configuration);
    }

    public static int getCircuitConfiguration(ItemStack itemStack) {
        if (!IntCircuitBehaviour.isIntegratedCircuit(itemStack)) {
            return 0;
        }
        CompoundTag tagCompound = itemStack.m_41783_();
        if (tagCompound != null) {
            return tagCompound.m_128451_("Configuration");
        }
        return 0;
    }

    public static boolean isIntegratedCircuit(ItemStack itemStack) {
        boolean isCircuit = GTItems.INTEGRATED_CIRCUIT.isIn(itemStack);
        if (isCircuit && !itemStack.m_41782_()) {
            CompoundTag compound = new CompoundTag();
            compound.m_128405_("Configuration", 0);
            itemStack.m_41751_(compound);
        }
        return isCircuit;
    }

    @Deprecated
    public static void adjustConfiguration(HeldItemUIFactory.HeldItemHolder holder, int amount) {
        IntCircuitBehaviour.adjustConfiguration(holder.getHeld(), amount);
        holder.markAsDirty();
    }

    @Deprecated
    public static void adjustConfiguration(ItemStack stack, int amount) {
        if (!IntCircuitBehaviour.isIntegratedCircuit(stack)) {
            return;
        }
        int configuration = IntCircuitBehaviour.getCircuitConfiguration(stack);
        configuration += amount;
        configuration = Mth.m_14045_((int)configuration, (int)0, (int)32);
        IntCircuitBehaviour.setCircuitConfiguration(stack, configuration);
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        int configuration = IntCircuitBehaviour.getCircuitConfiguration(stack);
        tooltipComponents.add((Component)Component.m_237110_((String)"metaitem.int_circuit.configuration", (Object[])new Object[]{configuration}));
    }

    @Override
    public ModularUI createUI(HeldItemUIFactory.HeldItemHolder holder, Player entityPlayer) {
        int x;
        LabelWidget label = new LabelWidget(9, 8, "Programmed Circuit Configuration");
        label.setDropShadow(false);
        label.setTextColor(0x404040);
        ModularUI modular = new ModularUI(184, 132, (IUIHolder)holder, entityPlayer).widget((Widget)label);
        SlotWidget slotwidget = new SlotWidget((IItemTransfer)new ItemStackTransfer(IntCircuitBehaviour.stack(IntCircuitBehaviour.getCircuitConfiguration(holder.getHeld()))), 0, 82, 20, false, false);
        slotwidget.setBackground(new IGuiTexture[]{GuiTextures.SLOT});
        modular.widget((Widget)slotwidget);
        int idx = 0;
        for (x = 0; x <= 2; ++x) {
            for (int y = 0; y <= 8; ++y) {
                int finalIdx = idx++;
                modular.widget((Widget)new ButtonWidget(10 + 18 * y, 48 + 18 * x, 18, 18, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.SLOT, new ItemStackTexture(new ItemStack[]{IntCircuitBehaviour.stack(finalIdx)}).scale(0.8888889f)}), data -> {
                    IntCircuitBehaviour.setCircuitConfiguration(holder, finalIdx);
                    slotwidget.setHandlerSlot((IItemTransfer)new ItemStackTransfer(IntCircuitBehaviour.stack(finalIdx)), 0);
                }));
            }
        }
        for (x = 0; x <= 5; ++x) {
            int finalIdx = x + 27;
            modular.widget((Widget)new ButtonWidget(10 + 18 * x, 102, 18, 18, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.SLOT, new ItemStackTexture(new ItemStack[]{IntCircuitBehaviour.stack(finalIdx)}).scale(0.8888889f)}), data -> {
                IntCircuitBehaviour.setCircuitConfiguration(holder, finalIdx);
                slotwidget.setHandlerSlot((IItemTransfer)new ItemStackTransfer(IntCircuitBehaviour.stack(finalIdx)), 0);
            }));
        }
        modular.mainGroup.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND});
        return modular;
    }
}

