/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.ITieredMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.machine.trait.BedrockOreMinerLogic;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BedrockOreMinerMachine
extends WorkableElectricMultiblockMachine
implements ITieredMachine {
    private final int tier;

    public BedrockOreMinerMachine(IMachineBlockEntity holder, int tier) {
        super(holder, new Object[0]);
        this.tier = tier;
    }

    @Override
    protected RecipeLogic createRecipeLogic(Object ... args) {
        return new BedrockOreMinerLogic(this);
    }

    public int getEnergyTier() {
        return Math.min(this.tier + 1, Math.max(this.tier, this.getOverclockTier()));
    }

    @Override
    public void addDisplayText(List<Component> textList) {
        super.addDisplayText(textList);
        if (this.isFormed()) {
            int energyContainer = this.getEnergyTier();
            long maxVoltage = GTValues.V[energyContainer];
            String voltageName = GTValues.VNF[energyContainer];
            textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.max_energy_per_tick", (Object[])new Object[]{maxVoltage, voltageName}));
        }
    }

    public static int getDepletionChance(int tier) {
        if (tier == 2) {
            return 1;
        }
        if (tier == 3) {
            return 2;
        }
        if (tier == 4) {
            return 8;
        }
        return 1;
    }

    public static int getRigMultiplier(int tier) {
        if (tier == 2) {
            return 1;
        }
        if (tier == 3) {
            return 16;
        }
        if (tier == 4) {
            return 64;
        }
        return 1;
    }

    public static Block getCasingState(int tier) {
        if (tier == 2) {
            return (Block)GTBlocks.CASING_STEEL_SOLID.get();
        }
        if (tier == 3) {
            return (Block)GTBlocks.CASING_TITANIUM_STABLE.get();
        }
        if (tier == 4) {
            return (Block)GTBlocks.CASING_TUNGSTENSTEEL_ROBUST.get();
        }
        return (Block)GTBlocks.CASING_STEEL_SOLID.get();
    }

    public static Block getFrameState(int tier) {
        if (tier == 2) {
            return (Block)((BlockEntry)GTBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, (Object)GTMaterials.Steel)).get();
        }
        if (tier == 3) {
            return (Block)((BlockEntry)GTBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, (Object)GTMaterials.Titanium)).get();
        }
        if (tier == 4) {
            return (Block)((BlockEntry)GTBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, (Object)GTMaterials.TungstenSteel)).get();
        }
        return (Block)((BlockEntry)GTBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, (Object)GTMaterials.Steel)).get();
    }

    public static ResourceLocation getBaseTexture(int tier) {
        if (tier == 2) {
            return GTCEu.id("block/casings/solid/machine_casing_solid_steel");
        }
        if (tier == 3) {
            return GTCEu.id("block/casings/solid/machine_casing_stable_titanium");
        }
        if (tier == 4) {
            return GTCEu.id("block/casings/solid/machine_casing_robust_tungstensteel");
        }
        return GTCEu.id("block/casings/solid/machine_casing_solid_steel");
    }

    @Override
    public int getTier() {
        return this.tier;
    }
}

