/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineModifyDrops;
import com.gregtechceu.gtceu.api.machine.multiblock.TieredWorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.OverclockingLogic;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTRecipeModifiers;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ProcessingArrayMachine
extends TieredWorkableElectricMultiblockMachine
implements IMachineModifyDrops {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ProcessingArrayMachine.class, TieredWorkableElectricMultiblockMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    @DescSynced
    public final NotifiableItemStackHandler machineStorage;
    @Nullable
    private GTRecipeType[] recipeTypeCache;

    public ProcessingArrayMachine(IMachineBlockEntity holder, int tier, Object ... args) {
        super(holder, tier, args);
        this.machineStorage = this.createMachineStorage(args);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected NotifiableItemStackHandler createMachineStorage(Object ... args) {
        NotifiableItemStackHandler storage = new NotifiableItemStackHandler(this, 1, IO.NONE, IO.NONE, slots -> new ItemStackTransfer(1){

            public int getSlotLimit(int slot) {
                return ProcessingArrayMachine.getMachineLimit(ProcessingArrayMachine.this.getDefinition().getTier());
            }
        });
        storage.setFilter(this::isMachineStack);
        return storage;
    }

    protected boolean isMachineStack(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof MetaMachineItem) {
            MetaMachineItem metaMachineItem = (MetaMachineItem)item;
            GTRecipeType[] recipeTypes = metaMachineItem.getDefinition().getRecipeTypes();
            if (recipeTypes == null) {
                return false;
            }
            for (GTRecipeType type : recipeTypes) {
                if (type == GTRecipeTypes.DUMMY_RECIPES) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public MachineDefinition getMachineDefinition() {
        Item item = this.machineStorage.storage.getStackInSlot(0).m_41720_();
        if (item instanceof MetaMachineItem) {
            MetaMachineItem metaMachineItem = (MetaMachineItem)item;
            return metaMachineItem.getDefinition();
        }
        return null;
    }

    @Override
    @Nonnull
    public GTRecipeType[] getRecipeTypes() {
        if (this.recipeTypeCache == null) {
            MachineDefinition definition = this.getMachineDefinition();
            GTRecipeType[] gTRecipeTypeArray = this.recipeTypeCache = definition == null ? null : definition.getRecipeTypes();
        }
        if (this.recipeTypeCache == null) {
            this.recipeTypeCache = new GTRecipeType[]{GTRecipeTypes.DUMMY_RECIPES};
        }
        return this.recipeTypeCache;
    }

    @Override
    @NotNull
    public GTRecipeType getRecipeType() {
        return this.getRecipeTypes()[this.getActiveRecipeType()];
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            this.machineStorage.addChangedListener(this::onMachineChanged);
        }
    }

    protected void onMachineChanged() {
        this.recipeTypeCache = null;
        if (this.isFormed) {
            if (this.getRecipeLogic().getLastRecipe() != null) {
                this.getRecipeLogic().markLastRecipeDirty();
            }
            this.getRecipeLogic().updateTickSubscription();
        }
    }

    @Override
    public void onDrops(List<ItemStack> drops, Player entity) {
        ProcessingArrayMachine.clearInventory(drops, (IItemTransfer)this.machineStorage.storage);
    }

    @Override
    public int getTier() {
        MachineDefinition definition = this.getMachineDefinition();
        return definition == null ? 0 : definition.getTier();
    }

    @Override
    public int getMaxOverclockTier() {
        return Math.min(this.getDefinition().getTier(), GTUtil.getTierByVoltage(this.getMaxVoltage()));
    }

    @Override
    public long getMaxVoltage() {
        return this.getMaxHatchVoltage();
    }

    @Nullable
    public static GTRecipe recipeModifier(MetaMachine machine, @Nonnull GTRecipe recipe) {
        if (machine instanceof ProcessingArrayMachine) {
            ProcessingArrayMachine processingArray = (ProcessingArrayMachine)machine;
            if (processingArray.machineStorage.storage.getStackInSlot(0).m_41613_() > 0) {
                if (RecipeHelper.getRecipeEUtTier(recipe) > processingArray.getTier()) {
                    return null;
                }
                int limit = processingArray.machineStorage.storage.getStackInSlot(0).m_41613_();
                recipe = (GTRecipe)GTRecipeModifiers.accurateParallel(machine, recipe, Math.min(limit, ProcessingArrayMachine.getMachineLimit(machine.getDefinition().getTier())), false).m_14418_();
                recipe = RecipeHelper.applyOverclock(OverclockingLogic.PERFECT_OVERCLOCK, recipe, processingArray.getOverclockVoltage());
                return recipe;
            }
        }
        return null;
    }

    @Override
    public Map<RecipeCapability<?>, Integer> getOutputLimits() {
        if (this.getMachineDefinition() != null) {
            return this.getMachineDefinition().getRecipeOutputLimits();
        }
        return GTRegistries.RECIPE_CAPABILITIES.values().stream().map(key -> Map.entry(key, 0)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public void addDisplayText(List<Component> textList) {
        super.addDisplayText(textList);
        if (this.isActive()) {
            textList.add((Component)Component.m_237115_((String)"gtceu.machine.machine_hatch.locked").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
        }
    }

    @Override
    public Widget createUIWidget() {
        Widget widget = super.createUIWidget();
        if (widget instanceof WidgetGroup) {
            WidgetGroup group = (WidgetGroup)widget;
            Size size = group.getSize();
            group.addWidget(new SlotWidget((IItemTransfer)this.machineStorage.storage, 0, size.width - 30, size.height - 30, true, true).setBackground(new IGuiTexture[]{GuiTextures.SLOT}));
        }
        return widget;
    }

    public static Block getCasingState(int tier) {
        if (tier <= 5) {
            return (Block)GTBlocks.CASING_TUNGSTENSTEEL_ROBUST.get();
        }
        return (Block)GTBlocks.CASING_HSSE_STURDY.get();
    }

    public static int getMachineLimit(Integer tier) {
        return tier <= 5 ? 16 : 64;
    }
}

