/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredIOPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DiodePartMachine
extends TieredIOPartMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(DiodePartMachine.class, TieredIOPartMachine.MANAGED_FIELD_HOLDER);
    public static int MAX_AMPS = 16;
    @Persisted
    protected NotifiableEnergyContainer energyContainer;
    @Persisted(key="amp_mode")
    private int amps = 1;

    public DiodePartMachine(IMachineBlockEntity holder, int tier) {
        super(holder, tier, IO.BOTH);
        long tierVoltage = GTValues.V[this.getTier()];
        this.energyContainer = new NotifiableEnergyContainer(this, tierVoltage * 16L, tierVoltage, this.amps, tierVoltage, this.amps);
        this.reinitializeEnergyContainer();
    }

    private void setAmpMode() {
        int n = this.amps = this.amps == this.getMaxAmperage() ? 1 : this.amps << 1;
        if (!this.getLevel().f_46443_) {
            this.reinitializeEnergyContainer();
            this.notifyBlockUpdate();
            this.markDirty();
        }
    }

    protected int getMaxAmperage() {
        return MAX_AMPS;
    }

    protected void reinitializeEnergyContainer() {
        long tierVoltage = GTValues.V[this.getTier()];
        this.energyContainer.resetBasicInfo(tierVoltage * 16L, tierVoltage, this.amps, tierVoltage, this.amps);
        this.energyContainer.setSideInputCondition(s -> s != this.getFrontFacing());
        this.energyContainer.setSideOutputCondition(s -> s == this.getFrontFacing());
    }

    @Override
    public boolean isFacingValid(Direction facing) {
        return true;
    }

    @Override
    protected InteractionResult onSoftMalletClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (this.getLevel().f_46443_) {
            this.scheduleRenderUpdate();
            return InteractionResult.CONSUME;
        }
        this.setAmpMode();
        playerIn.m_213846_((Component)Component.m_237110_((String)"gtceu.machine.diode.message", (Object[])new Object[]{this.amps}));
        return InteractionResult.CONSUME;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }
}

