/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.common.machine.multiblock.part.FluidHatchPartMachine;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.entity.player.Player;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SteamHatchPartMachine
extends FluidHatchPartMachine {
    public static final long INITIAL_TANK_CAPACITY = 64L * FluidHelper.getBucket();
    public static final boolean IS_STEEL = ConfigHolder.INSTANCE.machines.steelSteamMultiblocks;

    public SteamHatchPartMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, 0, IO.IN, args);
    }

    @Override
    protected NotifiableFluidTank createTank(Object ... args) {
        return super.createTank(args).setFilter(fluidStack -> FluidIngredient.of(CustomTags.STEAM, 1L).test((FluidStack)fluidStack));
    }

    @Override
    protected long getTankCapacity() {
        return INITIAL_TANK_CAPACITY;
    }

    @Override
    public ModularUI createUI(Player entityPlayer) {
        return new ModularUI(176, 166, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND_STEAM.get(IS_STEEL)}).widget((Widget)new ImageWidget(7, 16, 81, 55, (IGuiTexture)GuiTextures.DISPLAY_STEAM.get(IS_STEEL))).widget((Widget)new LabelWidget(11, 20, "gtceu.gui.fluid_amount")).widget((Widget)new LabelWidget(11, 30, () -> "" + this.tank.getFluidInTank(0).getAmount()).setTextColor(-1).setDropShadow(true)).widget((Widget)new LabelWidget(6, 6, this.getBlockState().m_60734_().m_7705_())).widget((Widget)new TankWidget((IFluidStorage)this.tank.storages[0], 90, 35, true, true).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT)).widget((Widget)UITemplate.bindPlayerInventory(entityPlayer.m_150109_(), (IGuiTexture)GuiTextures.SLOT_STEAM.get(IS_STEEL), 7, 84, true));
    }
}

