/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.storage;

import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.pipenet.longdistance.ILDEndpoint;
import com.gregtechceu.gtceu.api.pipenet.longdistance.LongDistanceNetwork;
import com.gregtechceu.gtceu.api.pipenet.longdistance.LongDistancePipeType;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;

public abstract class LongDistanceEndpointMachine
extends MetaMachine
implements ILDEndpoint {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(LongDistanceEndpointMachine.class, MetaMachine.MANAGED_FIELD_HOLDER);
    private final LongDistancePipeType pipeType;
    @Persisted
    private ILDEndpoint.Type type = ILDEndpoint.Type.NONE;
    private ILDEndpoint link;
    private boolean placed = false;

    public LongDistanceEndpointMachine(IMachineBlockEntity holder, LongDistancePipeType pipeType) {
        super(holder);
        this.pipeType = pipeType;
    }

    public void updateNetwork() {
        List<LongDistanceNetwork> networks;
        LongDistanceNetwork network = LongDistanceNetwork.get((LevelAccessor)this.getLevel(), this.getPos());
        if (network != null) {
            network.onRemoveEndpoint(this);
        }
        if ((networks = this.findNetworks()).isEmpty()) {
            network = this.pipeType.createNetwork(this.getLevel());
            network.onPlaceEndpoint(this);
            this.setType(ILDEndpoint.Type.NONE);
        } else if (networks.size() == 1) {
            networks.get(0).onPlaceEndpoint(this);
        } else {
            this.setType(ILDEndpoint.Type.NONE);
        }
    }

    @Override
    public void setFrontFacing(Direction frontFacing) {
        this.placed = true;
        super.setFrontFacing(frontFacing);
        if (this.getLevel() != null && !this.getLevel().f_46443_) {
            this.updateNetwork();
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.getLevel().f_46443_) {
            return;
        }
        if (this.link != null) {
            this.link.invalidateLink();
            this.invalidateLink();
        }
        this.setType(ILDEndpoint.Type.NONE);
        LongDistanceNetwork network = LongDistanceNetwork.get((LevelAccessor)this.getLevel(), this.getPos());
        if (network != null) {
            network.onRemoveEndpoint(this);
        }
    }

    @Override
    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        if (!this.placed || this.getLevel() == null || this.getLevel().f_46443_) {
            return;
        }
        List<LongDistanceNetwork> networks = this.findNetworks();
        LongDistanceNetwork network = LongDistanceNetwork.get((LevelAccessor)this.getLevel(), this.getPos());
        if (network == null) {
            if (networks.isEmpty()) {
                network = this.pipeType.createNetwork(this.getLevel());
                network.onPlaceEndpoint(this);
            } else if (networks.size() == 1) {
                networks.get(0).onPlaceEndpoint(this);
            }
        } else if (networks.size() > 1) {
            this.onUnload();
        }
        if (networks.size() != 1) {
            this.setType(ILDEndpoint.Type.NONE);
        }
    }

    private List<LongDistanceNetwork> findNetworks() {
        ArrayList<LongDistanceNetwork> networks = new ArrayList<LongDistanceNetwork>();
        LongDistanceNetwork network = LongDistanceNetwork.get((LevelAccessor)this.getLevel(), this.getPos().m_121945_(this.getFrontFacing()));
        if (network != null && this.pipeType == network.getPipeType()) {
            networks.add(network);
            this.setType(ILDEndpoint.Type.OUTPUT);
        }
        if ((network = LongDistanceNetwork.get((LevelAccessor)this.getLevel(), this.getPos().m_121945_(this.getOutputFacing()))) != null && this.pipeType == network.getPipeType()) {
            networks.add(network);
            this.setType(ILDEndpoint.Type.INPUT);
        }
        return networks;
    }

    @Override
    public ILDEndpoint getLink() {
        LongDistanceNetwork network;
        if (this.link == null && (network = LongDistanceNetwork.get((LevelAccessor)this.getLevel(), this.getPos())) != null && network.isValid()) {
            this.link = network.getOtherEndpoint(this);
        }
        return this.link;
    }

    @Override
    public void invalidateLink() {
        this.link = null;
    }

    @Override
    public Direction getOutputFacing() {
        return this.getFrontFacing().m_122424_();
    }

    @Override
    public LongDistancePipeType getPipeType() {
        return this.pipeType;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public ILDEndpoint.Type getType() {
        return this.type;
    }

    @Override
    public void setType(ILDEndpoint.Type type) {
        this.type = type;
    }
}

