/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.cable;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.WireProperties;
import com.gregtechceu.gtceu.common.pipelike.cable.CableData;
import com.gregtechceu.gtceu.common.pipelike.cable.CableRoutePath;
import com.gregtechceu.gtceu.common.pipelike.cable.EnergyNetWalker;
import com.lowdragmc.lowdraglib.pipelike.LevelPipeNet;
import com.lowdragmc.lowdraglib.pipelike.Node;
import com.lowdragmc.lowdraglib.pipelike.PipeNet;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;

public class EnergyNet
extends PipeNet<CableData> {
    public static final int DEFAULT_TEMPERATURE = 293;
    public static final int MELT_TEMP = 3000;
    public static final int SMOKE_TEMP = 2000;
    private final Map<BlockPos, List<CableRoutePath>> NET_DATA = new HashMap<BlockPos, List<CableRoutePath>>();
    private final Long2IntMap cableHeat = new Long2IntOpenHashMap();
    private final Long2LongMap cableAmps = new Long2LongOpenHashMap();
    private long lastHeatUpdate;
    private long lastVoltageUpdate;

    protected EnergyNet(LevelPipeNet<CableData, ? extends EnergyNet> world) {
        super(world);
        this.lastVoltageUpdate = this.lastHeatUpdate = world.getWorld().m_46467_();
    }

    public List<CableRoutePath> getNetData(BlockPos pipePos) {
        List<CableRoutePath> data = this.NET_DATA.get(pipePos);
        if (data == null) {
            data = EnergyNetWalker.createNetData(this, pipePos);
            if (data == null) {
                return Collections.emptyList();
            }
            data.sort(Comparator.comparingInt(CableRoutePath::getDistance));
            this.NET_DATA.put(pipePos, data);
        }
        return data;
    }

    public void onNeighbourUpdate(BlockPos fromPos) {
        this.NET_DATA.clear();
    }

    public void onPipeConnectionsUpdate() {
        this.NET_DATA.clear();
    }

    protected void transferNodeData(Map<BlockPos, Node<CableData>> transferredNodes, PipeNet<CableData> parentNet) {
        super.transferNodeData(transferredNodes, parentNet);
        this.NET_DATA.clear();
        ((EnergyNet)parentNet).NET_DATA.clear();
    }

    protected void writeNodeData(CableData nodeData, CompoundTag tagCompound) {
        tagCompound.m_128405_("voltage", nodeData.properties().getVoltage());
        tagCompound.m_128405_("amperage", nodeData.properties().getAmperage());
        tagCompound.m_128405_("loss", nodeData.properties().getLossPerBlock());
        tagCompound.m_128344_("connections", nodeData.connections());
    }

    protected CableData readNodeData(CompoundTag tagCompound) {
        int voltage = tagCompound.m_128451_("voltage");
        int amperage = tagCompound.m_128451_("amperage");
        int lossPerBlock = tagCompound.m_128451_("loss");
        return new CableData(new WireProperties(voltage, amperage, lossPerBlock), tagCompound.m_128445_("connections"));
    }

    private void updateCableHeat() {
        long latestTime = this.getWorldData().getWorld().m_46467_();
        long duration = latestTime - this.lastHeatUpdate;
        this.lastHeatUpdate = latestTime;
        if (duration > 0L) {
            ObjectIterator iter = this.cableHeat.long2IntEntrySet().iterator();
            while (iter.hasNext()) {
                Long2IntMap.Entry entry = (Long2IntMap.Entry)iter.next();
                if (this.containsNode(BlockPos.m_122022_((long)entry.getLongKey()))) {
                    int temp = entry.getIntValue();
                    long newTemp = (long)temp - duration * 50L;
                    if (newTemp > 293L) {
                        entry.setValue((int)newTemp);
                        continue;
                    }
                    iter.remove();
                    continue;
                }
                iter.remove();
            }
        } else if (duration < 0L) {
            this.cableHeat.clear();
        }
    }

    public boolean applyHeat(BlockPos cablePos, int heat) {
        this.updateCableHeat();
        int current = this.cableHeat.getOrDefault(cablePos.m_121878_(), 293);
        if (current + heat > 2000) {
            Direction facing = Direction.UP;
            float xPos = (float)facing.m_122429_() * 0.76f + (float)cablePos.m_123341_() + 0.25f;
            float yPos = (float)facing.m_122430_() * 0.76f + (float)cablePos.m_123342_() + 0.25f;
            float zPos = (float)facing.m_122431_() * 0.76f + (float)cablePos.m_123343_() + 0.25f;
            float ySpd = (float)facing.m_122430_() * 0.1f + 0.2f + 0.1f * GTValues.RNG.m_188501_();
            float temp = GTValues.RNG.m_188501_() * 2.0f * (float)Math.PI;
            float xSpd = (float)Math.sin(temp) * 0.1f;
            float zSpd = (float)Math.cos(temp) * 0.1f;
            this.getLevel().m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)(xPos + GTValues.RNG.m_188501_() * 0.5f), (double)(yPos + GTValues.RNG.m_188501_() * 0.5f), (double)(zPos + GTValues.RNG.m_188501_() * 0.5f), 10, (double)xSpd, (double)ySpd, (double)zSpd, 0.1);
        }
        if (current + heat > 3000) {
            this.cableHeat.remove(cablePos.m_121878_());
            return true;
        }
        this.cableHeat.put(cablePos.m_121878_(), current + heat);
        return false;
    }

    private void updateCableVoltage() {
        long latestTime = this.getWorldData().getWorld().m_46467_();
        if (this.lastVoltageUpdate != latestTime) {
            this.cableAmps.clear();
        }
        this.lastVoltageUpdate = latestTime;
    }

    public boolean incrementAmperage(BlockPos cablePos, long amps, int maxAmps) {
        this.updateCableVoltage();
        long lastAmps = this.cableAmps.getOrDefault(cablePos.m_121878_(), 0L);
        this.cableAmps.put(cablePos.m_121878_(), lastAmps + amps);
        long dif = lastAmps + amps - (long)maxAmps;
        if (dif > 0L) {
            return this.applyHeat(cablePos, (int)(dif * 40L));
        }
        return false;
    }
}

