/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.cable;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.WireProperties;
import com.gregtechceu.gtceu.common.blockentity.CableBlockEntity;
import com.gregtechceu.gtceu.common.pipelike.cable.CableData;
import com.gregtechceu.gtceu.common.pipelike.cable.CableRoutePath;
import com.gregtechceu.gtceu.common.pipelike.cable.EnergyNet;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import oshi.util.tuples.Pair;

public class EnergyNetHandler
implements IEnergyContainer {
    private final EnergyNet net;
    private final CableBlockEntity cable;
    private final List<CableRoutePath> paths;

    public EnergyNetHandler(EnergyNet net, CableBlockEntity cable) {
        this.net = Objects.requireNonNull(net);
        this.cable = Objects.requireNonNull(cable);
        this.paths = net.getNetData(cable.getPipePos());
    }

    public EnergyNet getNet() {
        return this.net;
    }

    @Override
    public long getEnergyCanBeInserted() {
        return this.getEnergyCapacity();
    }

    @Override
    public long acceptEnergyFromNetwork(Direction side, long voltage, long amperage) {
        long amperesUsed = 0L;
        HashSet<BlockPos> burnedCables = new HashSet<BlockPos>();
        for (CableRoutePath path : this.paths) {
            Pair<BlockPos, CableData> pair;
            WireProperties cable;
            long v;
            if (path.getMaxLoss() >= voltage || Objects.equals(this.cable.getPipePos(), path.getPipePos()) && side == path.getFaceToHandler()) continue;
            IEnergyContainer dest = path.getHandler(this.cable.getPipeLevel());
            Direction facing = path.getFaceToHandler().m_122424_();
            if (dest == null || !dest.inputsEnergy(facing) || dest.getEnergyCanBeInserted() <= 0L || (v = voltage - path.getMaxLoss()) <= 0L) continue;
            for (Pair<BlockPos, CableData> pair2 : path.getPath()) {
                WireProperties cable2 = ((CableData)pair2.getB()).properties();
                if ((long)cable2.getVoltage() >= voltage) continue;
                int heat = (int)(Math.log(GTUtil.getTierByVoltage(voltage) - GTUtil.getTierByVoltage(cable2.getVoltage())) * 45.0 + 36.5);
                if (this.net.applyHeat((BlockPos)pair2.getA(), heat)) {
                    burnedCables.add((BlockPos)pair2.getA());
                }
                v = Math.min((long)cable2.getVoltage(), v);
            }
            if (!burnedCables.isEmpty()) break;
            long amps = dest.acceptEnergyFromNetwork(facing, v, amperage - amperesUsed);
            if (amps == 0L) continue;
            amperesUsed += amps;
            long voltageTraveled = voltage;
            Pair<BlockPos, CableData>[] pairArray = path.getPath();
            int n = pairArray.length;
            for (int i = 0; i < n && (voltageTraveled -= (long)(cable = ((CableData)(pair = pairArray[i]).getB()).properties()).getLossPerBlock()) > 0L; ++i) {
                if (!this.net.incrementAmperage((BlockPos)pair.getA(), amps, cable.getAmperage())) continue;
                burnedCables.add((BlockPos)pair.getA());
            }
            if (burnedCables.isEmpty() && amperage != amperesUsed) continue;
            break;
        }
        for (BlockPos pos : burnedCables) {
            this.burnCable(this.net.getLevel(), pos);
        }
        return amperesUsed;
    }

    private void burnCable(ServerLevel serverLevel, BlockPos pos) {
        serverLevel.m_46597_(pos, Blocks.f_50083_.m_49966_());
    }

    @Override
    public long getInputAmperage() {
        return ((CableData)this.cable.getNodeData()).properties.getAmperage();
    }

    @Override
    public long getInputVoltage() {
        return ((CableData)this.cable.getNodeData()).properties.getVoltage();
    }

    @Override
    public long getEnergyCapacity() {
        return this.getInputVoltage() * this.getInputAmperage();
    }

    @Override
    public long changeEnergy(long energyToAdd) {
        GTCEu.LOGGER.warn("Do not use changeEnergy() for cables! Use acceptEnergyFromNetwork()");
        return this.acceptEnergyFromNetwork(null, energyToAdd / this.getInputAmperage(), energyToAdd / this.getInputVoltage()) * this.getInputVoltage();
    }

    @Override
    public boolean outputsEnergy(Direction side) {
        return true;
    }

    @Override
    public boolean inputsEnergy(Direction side) {
        return true;
    }

    @Override
    public long getEnergyStored() {
        return 0L;
    }

    @Override
    public boolean isOneProbeHidden() {
        return true;
    }
}

