/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.fluidpipe;

import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidPipeProperties;
import com.gregtechceu.gtceu.api.misc.RateCounter;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.FluidPipeData;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.FluidPipeNetWalker;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.PipeNetRoutePath;
import com.lowdragmc.lowdraglib.pipelike.LevelPipeNet;
import com.lowdragmc.lowdraglib.pipelike.PipeNet;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public class FluidPipeNet
extends PipeNet<FluidPipeData> {
    private final Map<BlockPos, List<PipeNetRoutePath>> NET_DATA = new HashMap<BlockPos, List<PipeNetRoutePath>>();
    private final Long2ObjectMap<Fluid[]> channelFluidsByBlock = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<RateCounter[]> throughputsCountersByBlock = new Long2ObjectOpenHashMap();
    private long lastUpdate;

    public FluidPipeNet(LevelPipeNet<FluidPipeData, ? extends PipeNet> world) {
        super(world);
        this.lastUpdate = world.getWorld().m_46467_();
    }

    public List<PipeNetRoutePath> getNetData(BlockPos pipePos) {
        List<PipeNetRoutePath> data = this.NET_DATA.get(pipePos);
        if (data == null) {
            data = FluidPipeNetWalker.createNetData(this, pipePos);
            if (data == null) {
                return Collections.emptyList();
            }
            data.sort(Comparator.comparingInt(PipeNetRoutePath::getDistance));
            this.NET_DATA.put(pipePos, data);
        }
        return data;
    }

    public void onNeighbourUpdate(BlockPos fromPos) {
        this.NET_DATA.clear();
    }

    public void onPipeConnectionsUpdate() {
        this.NET_DATA.clear();
    }

    public long getLastSecondTotalThroughput(BlockPos blockPos, int channel) {
        return this.getThroughputCounters(blockPos.m_121878_())[channel].getUsedSum();
    }

    public int getChannel(BlockPos pos, Fluid fluid) {
        this.updateTick();
        Fluid[] channelFluids = this.getChannelFluids(pos.m_121878_());
        for (int channel = 0; channel < channelFluids.length; ++channel) {
            if (channelFluids[channel] == null || !channelFluids[channel].equals(fluid)) continue;
            return channel;
        }
        return -1;
    }

    public int useChannel(BlockPos pos, Fluid fluid) {
        int channel = this.getChannel(pos, fluid);
        if (channel != -1) {
            return channel;
        }
        int newChannel = this.findBestFreeChannel(pos.m_121878_());
        if (newChannel == -1) {
            return -1;
        }
        this.getChannelFluids((long)pos.m_121878_())[newChannel] = fluid;
        return newChannel;
    }

    public void useThroughput(BlockPos pos, int channel, long amount) {
        this.updateTick();
        this.getThroughputCounters(pos.m_121878_())[channel].addUsed(amount);
    }

    public Fluid getFluid(BlockPos pos, int channel) {
        this.updateTick();
        return this.getChannelFluids(pos.m_121878_())[channel];
    }

    private void updateTick() {
        long latestTime = this.getWorldData().getWorld().m_46467_();
        if (this.lastUpdate == latestTime) {
            return;
        }
        this.channelFluidsByBlock.forEach((k, v) -> Arrays.fill(v, null));
        this.lastUpdate = latestTime;
    }

    @NotNull
    private RateCounter[] getThroughputCounters(long blockPos) {
        return (RateCounter[])this.throughputsCountersByBlock.computeIfAbsent(blockPos, bp -> (RateCounter[])Stream.generate(() -> new RateCounter(() -> this.getLevel().m_46467_(), 20)).limit(9L).toArray(RateCounter[]::new));
    }

    private Fluid[] getChannelFluids(long blockPos) {
        return (Fluid[])this.channelFluidsByBlock.computeIfAbsent(blockPos, bp -> new Fluid[9]);
    }

    private long[] getLastSecondTotalUsagePerChannel(long blockPos) {
        return Arrays.stream(this.getThroughputCounters(blockPos)).mapToLong(RateCounter::getUsedSum).toArray();
    }

    private int findBestFreeChannel(long pos) {
        Fluid[] channelFluids = this.getChannelFluids(pos);
        long[] lastSecondUsagePerChannel = this.getLastSecondTotalUsagePerChannel(pos);
        long leastUsedAmount = Long.MAX_VALUE;
        int bestChannel = -1;
        for (int channel = 0; channel < channelFluids.length; ++channel) {
            if (channelFluids[channel] != null || lastSecondUsagePerChannel[channel] >= leastUsedAmount) continue;
            leastUsedAmount = lastSecondUsagePerChannel[channel];
            bestChannel = channel;
        }
        return bestChannel;
    }

    protected void writeNodeData(FluidPipeData nodeData, CompoundTag tagCompound) {
        tagCompound.m_128405_("max_temperature", nodeData.properties.getMaxFluidTemperature());
        tagCompound.m_128356_("throughput", nodeData.properties.getThroughput());
        tagCompound.m_128379_("gas_proof", nodeData.properties.isGasProof());
        tagCompound.m_128379_("acid_proof", nodeData.properties.isAcidProof());
        tagCompound.m_128379_("cryo_proof", nodeData.properties.isCryoProof());
        tagCompound.m_128379_("plasma_proof", nodeData.properties.isPlasmaProof());
        tagCompound.m_128405_("channels", nodeData.properties.getChannels());
        tagCompound.m_128344_("connections", nodeData.connections());
    }

    protected FluidPipeData readNodeData(CompoundTag tagCompound) {
        int maxTemperature = tagCompound.m_128451_("max_temperature");
        long throughput = tagCompound.m_128454_("throughput");
        boolean gasProof = tagCompound.m_128471_("gas_proof");
        boolean acidProof = tagCompound.m_128471_("acid_proof");
        boolean cryoProof = tagCompound.m_128471_("cryo_proof");
        boolean plasmaProof = tagCompound.m_128471_("plasma_proof");
        int channels = tagCompound.m_128451_("channels");
        return new FluidPipeData(new FluidPipeProperties(maxTemperature, throughput, gasProof, acidProof, cryoProof, plasmaProof, channels), tagCompound.m_128445_("connections"));
    }

    public Snapshot createSnapshot() {
        Long2ObjectOpenHashMap channelUsedCopied = new Long2ObjectOpenHashMap();
        this.channelFluidsByBlock.forEach((arg_0, arg_1) -> FluidPipeNet.lambda$createSnapshot$6((Long2ObjectMap)channelUsedCopied, arg_0, arg_1));
        Long2ObjectOpenHashMap throughputCountersCopied = new Long2ObjectOpenHashMap();
        this.throughputsCountersByBlock.forEach((k, v) -> throughputCountersCopied.put(k.longValue(), (Object)((RateCounter[])Arrays.stream(v).map(RateCounter::copy).toArray(RateCounter[]::new))));
        return new Snapshot((Long2ObjectMap<Fluid[]>)channelUsedCopied, (Long2ObjectMap<RateCounter[]>)throughputCountersCopied);
    }

    public void resetData(Snapshot snapshot) {
        this.channelFluidsByBlock.clear();
        this.channelFluidsByBlock.putAll(snapshot.channelFluids);
        this.throughputsCountersByBlock.clear();
        this.throughputsCountersByBlock.putAll(snapshot.throughputCounters);
    }

    private static /* synthetic */ void lambda$createSnapshot$6(Long2ObjectMap channelUsedCopied, Long k, Fluid[] v) {
        channelUsedCopied.put(k.longValue(), (Object)Arrays.copyOf(v, v.length));
    }

    public record Snapshot(Long2ObjectMap<Fluid[]> channelFluids, Long2ObjectMap<RateCounter[]> throughputCounters) {
    }
}

