/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.item;

import com.gregtechceu.gtceu.api.data.chemical.material.properties.ItemPipeProperties;
import com.gregtechceu.gtceu.common.pipelike.item.ItemNetWalker;
import com.gregtechceu.gtceu.common.pipelike.item.ItemPipeData;
import com.gregtechceu.gtceu.utils.FacingPos;
import com.lowdragmc.lowdraglib.pipelike.LevelPipeNet;
import com.lowdragmc.lowdraglib.pipelike.Node;
import com.lowdragmc.lowdraglib.pipelike.PipeNet;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ItemPipeNet
extends PipeNet<ItemPipeData> {
    private final Map<BlockPos, List<Inventory>> NET_DATA = new HashMap<BlockPos, List<Inventory>>();

    public ItemPipeNet(LevelPipeNet<ItemPipeData, ? extends PipeNet<ItemPipeData>> world) {
        super(world);
    }

    public List<Inventory> getNetData(BlockPos pipePos) {
        List<Inventory> data = this.NET_DATA.get(pipePos);
        if (data == null) {
            data = ItemNetWalker.createNetData(this, pipePos);
            if (data == null) {
                return Collections.emptyList();
            }
            data.sort(Comparator.comparingInt(inv -> inv.properties.getPriority()));
            this.NET_DATA.put(pipePos, data);
        }
        return data;
    }

    public void onNeighbourUpdate(BlockPos fromPos) {
        this.NET_DATA.clear();
    }

    public void onPipeConnectionsUpdate() {
        this.NET_DATA.clear();
    }

    protected void transferNodeData(Map<BlockPos, Node<ItemPipeData>> transferredNodes, PipeNet<ItemPipeData> parentNet) {
        super.transferNodeData(transferredNodes, parentNet);
        this.NET_DATA.clear();
        ((ItemPipeNet)parentNet).NET_DATA.clear();
    }

    protected void writeNodeData(ItemPipeData nodeData, CompoundTag tagCompound) {
        tagCompound.m_128405_("Resistance", nodeData.properties.getPriority());
        tagCompound.m_128350_("Rate", nodeData.properties.getTransferRate());
        tagCompound.m_128344_("Connections", nodeData.connections);
    }

    protected ItemPipeData readNodeData(CompoundTag tagCompound) {
        return new ItemPipeData(new ItemPipeProperties(tagCompound.m_128451_("Range"), tagCompound.m_128457_("Rate")), tagCompound.m_128445_("Connections"));
    }

    public static class Inventory {
        private final BlockPos pipePos;
        private final Direction faceToHandler;
        private final int distance;
        private final ItemPipeProperties properties;
        private final List<Predicate<ItemStack>> filters;

        public Inventory(BlockPos pipePos, Direction facing, int distance, ItemPipeProperties properties, List<Predicate<ItemStack>> filters) {
            this.pipePos = pipePos;
            this.faceToHandler = facing;
            this.distance = distance;
            this.properties = properties;
            this.filters = filters;
        }

        public boolean matchesFilters(ItemStack stack) {
            for (Predicate<ItemStack> filter : this.filters) {
                if (filter.test(stack)) continue;
                return false;
            }
            return true;
        }

        public BlockPos getHandlerPos() {
            return this.pipePos.m_121945_(this.faceToHandler);
        }

        public IItemTransfer getHandler(Level world) {
            BlockEntity tile = world.m_7702_(this.getHandlerPos());
            if (tile != null) {
                return ItemTransferHelper.getItemTransfer((Level)world, (BlockPos)this.getHandlerPos(), (Direction)this.faceToHandler.m_122424_());
            }
            return null;
        }

        public FacingPos toFacingPos() {
            return new FacingPos(this.getPipePos(), this.faceToHandler);
        }

        public BlockPos getPipePos() {
            return this.pipePos;
        }

        public Direction getFaceToHandler() {
            return this.faceToHandler;
        }

        public int getDistance() {
            return this.distance;
        }

        public ItemPipeProperties getProperties() {
            return this.properties;
        }

        public List<Predicate<ItemStack>> getFilters() {
            return this.filters;
        }
    }
}

