/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.item;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ItemPipeProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.pipenet.IMaterialPipeType;
import com.gregtechceu.gtceu.client.model.PipeModel;
import com.gregtechceu.gtceu.common.pipelike.item.ItemPipeData;
import net.minecraft.resources.ResourceLocation;

public enum ItemPipeType implements IMaterialPipeType<ItemPipeData>
{
    SMALL("small", 0.375f, TagPrefix.pipeSmallItem, 0.5f, 1.5f),
    NORMAL("normal", 0.5f, TagPrefix.pipeNormalItem, 1.0f, 1.0f),
    LARGE("large", 0.75f, TagPrefix.pipeLargeItem, 2.0f, 0.75f),
    HUGE("huge", 0.875f, TagPrefix.pipeHugeItem, 4.0f, 0.5f),
    RESTRICTIVE_SMALL("small_restrictive", 0.375f, TagPrefix.pipeSmallRestrictive, 0.5f, 150.0f),
    RESTRICTIVE_NORMAL("normal_restrictive", 0.5f, TagPrefix.pipeNormalRestrictive, 1.0f, 100.0f),
    RESTRICTIVE_LARGE("large_restrictive", 0.75f, TagPrefix.pipeLargeRestrictive, 2.0f, 75.0f),
    RESTRICTIVE_HUGE("huge_restrictive", 0.875f, TagPrefix.pipeHugeRestrictive, 4.0f, 50.0f);

    public static final ResourceLocation TYPE_ID;
    public static final ItemPipeType[] VALUES;
    public final String name;
    private final float thickness;
    private final float rateMultiplier;
    private final float resistanceMultiplier;
    private final TagPrefix tagPrefix;

    private ItemPipeType(String name, float thickness, TagPrefix orePrefix, float rateMultiplier, float resistanceMultiplier) {
        this.name = name;
        this.thickness = thickness;
        this.tagPrefix = orePrefix;
        this.rateMultiplier = rateMultiplier;
        this.resistanceMultiplier = resistanceMultiplier;
    }

    public boolean isRestrictive() {
        return this.ordinal() > 3;
    }

    public String getSizeForTexture() {
        if (!this.isRestrictive()) {
            return this.name;
        }
        return this.name.substring(0, this.name.length() - 12);
    }

    @Override
    public ItemPipeData modifyProperties(ItemPipeData baseProperties) {
        return new ItemPipeData(new ItemPipeProperties((int)((double)((float)baseProperties.properties.getPriority() * this.resistanceMultiplier) + 0.5), baseProperties.properties.getTransferRate() * this.rateMultiplier), baseProperties.connections);
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public ResourceLocation type() {
        return TYPE_ID;
    }

    public PipeModel createPipeModel(Material material) {
        PipeModel model = material.hasProperty(PropertyKey.WOOD) ? new PipeModel(this.thickness, () -> GTCEu.id("block/pipe/pipe_side_wood"), () -> GTCEu.id("block/pipe/pipe_%s_in_wood".formatted(this.isRestrictive() ? ItemPipeType.values()[this.ordinal() - 4].name : this.name)), null, null) : new PipeModel(this.thickness, () -> GTCEu.id("block/pipe/pipe_side"), () -> GTCEu.id("block/pipe/pipe_%s_in".formatted(this.isRestrictive() ? ItemPipeType.values()[this.ordinal() - 4].name : this.name)), null, null);
        if (this.isRestrictive()) {
            model.setSideOverlayTexture(GTCEu.id("block/pipe/pipe_restrictive"));
        }
        return model;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public float getThickness() {
        return this.thickness;
    }

    public float getRateMultiplier() {
        return this.rateMultiplier;
    }

    @Override
    public TagPrefix getTagPrefix() {
        return this.tagPrefix;
    }

    static {
        TYPE_ID = GTCEu.id("item");
        VALUES = ItemPipeType.values();
    }
}

