/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.recipe;

import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;

public class RockBreakerCondition
extends RecipeCondition {
    public static final RockBreakerCondition INSTANCE = new RockBreakerCondition();

    @Override
    public String getType() {
        return "rock_breaker";
    }

    @Override
    public Component getTooltips() {
        return Component.m_237115_((String)"recipe.condition.rock_breaker.tooltip");
    }

    @Override
    public boolean test(@NotNull GTRecipe recipe, @NotNull RecipeLogic recipeLogic) {
        Fluid fluidA = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(recipe.data.m_128461_("fluidA")));
        Fluid fluidB = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(recipe.data.m_128461_("fluidB")));
        boolean hasFluidA = false;
        boolean hasFluidB = false;
        Level level = recipeLogic.machine.self().getLevel();
        BlockPos pos = recipeLogic.machine.self().getPos();
        for (Direction side : Direction.values()) {
            if (side.m_122434_() == Direction.Axis.Y) continue;
            FluidState fluid = level.m_6425_(pos.m_121945_(side));
            if (fluid.m_76152_() == fluidA) {
                hasFluidA = true;
            }
            if (fluid.m_76152_() == fluidB) {
                hasFluidB = true;
            }
            if (!hasFluidA || !hasFluidB) continue;
            return true;
        }
        return false;
    }

    @Override
    public RecipeCondition createTemplate() {
        return new RockBreakerCondition();
    }
}

