/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.core.mixins;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.core.MixinHelpers;
import com.gregtechceu.gtceu.core.mixins.BlockBehaviourAccessor;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.Platform;
import java.util.Map;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.packs.VanillaBlockLoot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LootDataManager.class})
public abstract class LootTablesMixin {
    @Inject(method={"apply"}, at={@At(value="HEAD")})
    public void gtceu$injectLootTables(Map<LootDataType<?>, Map<ResourceLocation, ?>> allElements, CallbackInfo ci) {
        if (Platform.isDatagen()) {
            return;
        }
        Map<ResourceLocation, ?> lootTables = allElements.get(LootDataType.f_278413_);
        GTBlocks.MATERIAL_BLOCKS.rowMap().forEach((prefix, map) -> {
            if (TagPrefix.ORES.containsKey(prefix)) {
                map.forEach((material, blockEntry) -> {
                    ItemStack dropItem;
                    ResourceLocation lootTableId = new ResourceLocation(blockEntry.getId().m_135827_(), "blocks/" + blockEntry.getId().m_135815_());
                    Block block = (Block)blockEntry.get();
                    if (prefix != TagPrefix.oreNetherrack && prefix != TagPrefix.oreEndstone && !ConfigHolder.INSTANCE.worldgen.allUniqueStoneTypes) {
                        TagPrefix orePrefix = TagPrefix.ORES.get(prefix).isNether() ? (TagPrefix.ORES.get(prefix).stoneType().get().m_204336_(CustomTags.ENDSTONE_ORE_REPLACEABLES) ? TagPrefix.oreEndstone : TagPrefix.oreNetherrack) : TagPrefix.ore;
                        block = ChemicalHelper.getBlock(orePrefix, material);
                    }
                    if ((dropItem = ChemicalHelper.get(TagPrefix.rawOre, material)).m_41619_()) {
                        dropItem = ChemicalHelper.get(TagPrefix.gem, material);
                    }
                    if (dropItem.m_41619_()) {
                        dropItem = ChemicalHelper.get(TagPrefix.dust, material);
                    }
                    int oreMultiplier = TagPrefix.ORES.get(prefix).isNether() ? 2 : 1;
                    LootTable.Builder builder = BlockLootSubProvider.m_247502_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)new VanillaBlockLoot().m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)dropItem.m_41720_()).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)Math.max(1, material.getProperty(PropertyKey.ORE).getOreMultiplier() * oreMultiplier)))))));
                    Material outputDustMat = (Material)GTRegistries.MATERIALS.get(FormattingUtil.toLowerCaseUnder(prefix.name));
                    if (outputDustMat != null) {
                        builder.m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ChemicalHelper.get(TagPrefix.dust, outputDustMat).m_41720_()).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_)).m_79078_((LootItemFunction.Builder)LimitCount.m_165215_((IntRange)IntRange.m_165011_((int)0, (int)2))).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_())));
                    }
                    lootTables.put(lootTableId, builder.m_79165_(LootContextParamSets.f_81421_).m_79167_());
                    ((BlockBehaviourAccessor)blockEntry.get()).setDrops(lootTableId);
                });
            } else {
                MixinHelpers.addMaterialBlockLootTables(lootTables, prefix, map);
            }
        });
        GTBlocks.CABLE_BLOCKS.rowMap().forEach((prefix, map) -> MixinHelpers.addMaterialBlockLootTables(lootTables, prefix, map));
        GTBlocks.FLUID_PIPE_BLOCKS.rowMap().forEach((prefix, map) -> MixinHelpers.addMaterialBlockLootTables(lootTables, prefix, map));
        GTBlocks.ITEM_PIPE_BLOCKS.rowMap().forEach((prefix, map) -> MixinHelpers.addMaterialBlockLootTables(lootTables, prefix, map));
        GTBlocks.SURFACE_ROCK_BLOCKS.forEach((material, blockEntry) -> {
            ResourceLocation lootTableId = new ResourceLocation(blockEntry.getId().m_135827_(), "blocks/" + blockEntry.getId().m_135815_());
            LootTable.Builder builder = new VanillaBlockLoot().m_245765_((ItemLike)ChemicalHelper.get(TagPrefix.dustTiny, material).m_41720_(), (NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)5.0f)).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_));
            lootTables.put(lootTableId, builder.m_79165_(LootContextParamSets.f_81421_).m_79167_());
            ((BlockBehaviourAccessor)blockEntry.get()).setDrops(lootTableId);
        });
        GTRegistries.MACHINES.forEach(machine -> {
            Block block = machine.getBlock();
            ResourceLocation id = machine.getId();
            ResourceLocation lootTableId = new ResourceLocation(id.m_135827_(), "blocks/" + id.m_135815_());
            ((BlockBehaviourAccessor)block).setDrops(lootTableId);
            lootTables.put(lootTableId, new VanillaBlockLoot().m_247033_((ItemLike)block).m_79165_(LootContextParamSets.f_81421_).m_79167_());
        });
    }
}

