/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.core.mixins;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKey;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.core.IGTTagLoader;
import com.gregtechceu.gtceu.core.MixinHelpers;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagLoader;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TagLoader.class})
public class TagLoaderMixin<T>
implements IGTTagLoader<T> {
    @Unique
    @Nullable
    private Registry<T> gtceu$storedRegistry;

    @Inject(method={"load"}, at={@At(value="RETURN")})
    public void gtceu$load(ResourceManager resourceManager, CallbackInfoReturnable<Map<ResourceLocation, List<TagLoader.EntryWithSource>>> cir) {
        Map tagMap = (Map)cir.getReturnValue();
        if (this.gtceu$getRegistry() == null) {
            return;
        }
        if (this.gtceu$getRegistry() == BuiltInRegistries.f_257033_) {
            ChemicalHelper.UNIFICATION_ENTRY_ITEM.forEach((entry, itemLikes) -> {
                if (itemLikes.isEmpty()) {
                    return;
                }
                Material material = entry.material;
                if (material != null) {
                    TagKey<Item>[] materialTags;
                    for (TagKey<Item> materialTag : materialTags = entry.tagPrefix.getAllItemTags(material)) {
                        ArrayList tags = new ArrayList();
                        itemLikes.forEach(item -> tags.add(new TagLoader.EntryWithSource(TagEntry.m_215925_((ResourceLocation)BuiltInRegistries.f_257033_.m_7981_((Object)item.m_5456_())), "GTCEu Custom Tags")));
                        tagMap.computeIfAbsent(materialTag.f_203868_(), path -> new ArrayList()).addAll(tags);
                    }
                }
            });
            GTItems.TOOL_ITEMS.rowMap().forEach((toolTier, map) -> map.forEach((type, item) -> {
                if (item != null) {
                    TagLoader.EntryWithSource entry = new TagLoader.EntryWithSource(TagEntry.m_215925_((ResourceLocation)item.getId()), "GTCEu Custom Tags");
                    tagMap.computeIfAbsent(type.itemTag.f_203868_(), path -> new ArrayList()).add(entry);
                }
            }));
        } else if (this.gtceu$getRegistry() == BuiltInRegistries.f_256975_) {
            GTBlocks.MATERIAL_BLOCKS.rowMap().forEach((prefix, map) -> MixinHelpers.addMaterialBlockTags(tagMap, prefix, map));
            GTBlocks.CABLE_BLOCKS.rowMap().forEach((prefix, map) -> MixinHelpers.addMaterialBlockTags(tagMap, prefix, map));
            GTBlocks.FLUID_PIPE_BLOCKS.rowMap().forEach((prefix, map) -> MixinHelpers.addMaterialBlockTags(tagMap, prefix, map));
            GTBlocks.ITEM_PIPE_BLOCKS.rowMap().forEach((prefix, map) -> MixinHelpers.addMaterialBlockTags(tagMap, prefix, map));
            GTRegistries.MACHINES.forEach(machine -> {
                ResourceLocation id = machine.getId();
                tagMap.computeIfAbsent(GTToolType.WRENCH.harvestTag.f_203868_(), path -> new ArrayList()).add(new TagLoader.EntryWithSource(TagEntry.m_215925_((ResourceLocation)id), "GTCEu Custom Tags"));
                if (!ConfigHolder.INSTANCE.machines.requireGTToolsForBlocks) {
                    tagMap.computeIfAbsent(BlockTags.f_144282_.f_203868_(), path -> new ArrayList()).add(new TagLoader.EntryWithSource(TagEntry.m_215925_((ResourceLocation)id), "GTCEu Custom Tags"));
                }
            });
            GTBlocks.ALL_FUSION_CASINGS.forEach((casingType, block) -> {
                ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)((Block)block.get()));
                tagMap.computeIfAbsent(CustomTags.TOOL_TIERS[casingType.getHarvestLevel()].f_203868_(), path -> new ArrayList()).add(new TagLoader.EntryWithSource(TagEntry.m_215925_((ResourceLocation)blockId), "GTCEu Custom Tags"));
            });
        } else if (this.gtceu$getRegistry() == BuiltInRegistries.f_257020_) {
            for (Material material : GTRegistries.MATERIALS) {
                if (!material.hasProperty(PropertyKey.FLUID)) continue;
                FluidProperty property = material.getProperty(PropertyKey.FLUID);
                for (FluidStorageKey key : FluidStorageKey.allKeys()) {
                    Fluid fluid = property.getStorage().get(key);
                    if (fluid == null) continue;
                    ChemicalHelper.FLUID_MATERIAL.put(fluid, material);
                    ResourceLocation fluidId = BuiltInRegistries.f_257020_.m_7981_((Object)fluid);
                    tagMap.computeIfAbsent(TagUtil.createFluidTag(fluidId.m_135815_()).f_203868_(), path -> new ArrayList()).add(new TagLoader.EntryWithSource(TagEntry.m_215925_((ResourceLocation)fluidId), "GTCEu Custom Tags"));
                }
            }
        }
    }

    @Override
    @Nullable
    public Registry<T> gtceu$getRegistry() {
        return this.gtceu$storedRegistry;
    }

    @Override
    public void gtceu$setRegistry(Registry<T> registry) {
        this.gtceu$storedRegistry = registry;
    }
}

