/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.forge;

import com.gregtechceu.gtceu.api.registry.registrate.CompassNode;
import com.gregtechceu.gtceu.api.registry.registrate.CompassSection;
import com.gregtechceu.gtceu.api.registry.registrate.SoundEntryBuilder;
import com.gregtechceu.gtceu.common.data.GTConfiguredFeatures;
import com.gregtechceu.gtceu.common.data.GTDamageTypes;
import com.gregtechceu.gtceu.common.data.GTPlacements;
import com.gregtechceu.gtceu.common.data.GTWorldgen;
import com.gregtechceu.gtceu.common.data.forge.GTBiomeModifiers;
import com.gregtechceu.gtceu.data.forge.BiomeTagsProviderImpl;
import com.gregtechceu.gtceu.data.forge.GTRegistriesDatapackGenerator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.NoiseData;
import net.minecraft.data.worldgen.biome.BiomeData;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        RegistryAccess.Frozen registryAccess = RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_);
        CompletableFuture<HolderLookup.Provider> registries = DataGenerators.createProvider((RegistryAccess)registryAccess);
        if (event.includeServer()) {
            Set<String> set = Set.of("gtceu");
            generator.addProvider(true, (DataProvider)new SoundEntryBuilder.SoundEntryProvider(generator.getPackOutput(), "gtceu"));
            generator.addProvider(true, (DataProvider)new CompassSection.CompassSectionProvider(generator.getPackOutput(), rl -> event.getExistingFileHelper().exists(rl, PackType.CLIENT_RESOURCES)));
            generator.addProvider(true, (DataProvider)new CompassNode.CompassNodeProvider(generator.getPackOutput(), rl -> event.getExistingFileHelper().exists(rl, PackType.CLIENT_RESOURCES)));
            generator.addProvider(true, DataGenerators.bindRegistries(BiomeTagsProviderImpl::new, registries));
            generator.addProvider(true, DataGenerators.bindRegistries((output, provider) -> new GTRegistriesDatapackGenerator((PackOutput)output, registries, new RegistrySetBuilder().m_254916_(Registries.f_268580_, GTDamageTypes::bootstrap), set, "DamageType Data"), registries));
            generator.addProvider(true, DataGenerators.bindRegistries((output, provider) -> new GTRegistriesDatapackGenerator((PackOutput)output, registries, new RegistrySetBuilder().m_254916_(Registries.f_256911_, GTConfiguredFeatures::bootstrap).m_254916_(Registries.f_256988_, GTPlacements::bootstrap).m_254916_(Registries.f_257040_, GTWorldgen::bootstrapDensityFunctions).m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, ctx -> GTBiomeModifiers.bootstrap((BootstapContext<BiomeModifier>)ctx, provider)), set, "Worldgen Data"), registries));
        }
    }

    private static <T extends DataProvider> DataProvider.Factory<T> bindRegistries(BiFunction<PackOutput, CompletableFuture<HolderLookup.Provider>, T> factory, CompletableFuture<HolderLookup.Provider> factories) {
        return packOutput -> (DataProvider)factory.apply(packOutput, factories);
    }

    private static CompletableFuture<HolderLookup.Provider> createProvider(RegistryAccess registryAccess) {
        CompletableFuture<HolderLookup.Provider> vanillaLookup = CompletableFuture.supplyAsync(VanillaRegistries::m_255371_, Util.m_183991_());
        return vanillaLookup.thenApply(provider -> {
            RegistrySetBuilder builder = new RegistrySetBuilder().m_254916_(Registries.f_256865_, NoiseData::m_236475_).m_254916_(Registries.f_256952_, BiomeData::m_272174_);
            return builder.m_254929_(registryAccess, provider);
        });
    }
}

