/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.loader;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.NoopVeinGenerator;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTOres;
import com.gregtechceu.gtceu.integration.kjs.GTCEuServerEvents;
import com.gregtechceu.gtceu.integration.kjs.events.GTOreVeinEventJS;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.storage.loot.Deserializers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OreDataLoader
extends SimpleJsonResourceReloadListener {
    public static OreDataLoader INSTANCE;
    public static final Gson GSON_INSTANCE;
    private static final String FOLDER = "gtceu/ore_veins";
    protected static final Logger LOGGER;

    public OreDataLoader() {
        super(GSON_INSTANCE, FOLDER);
    }

    protected void apply(Map<ResourceLocation, JsonElement> resourceList, ResourceManager resourceManager, ProfilerFiller profiler) {
        GTRegistries.ORE_VEINS.registry().clear();
        GTOres.init();
        if (GTCEu.isKubeJSLoaded()) {
            RunKJSEventInSeparateClassBecauseForgeIsDumb.fireKJSEvent();
        }
        RegistryOps ops = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)GTRegistries.builtinRegistry());
        for (Map.Entry<ResourceLocation, JsonElement> entry : resourceList.entrySet()) {
            ResourceLocation location = entry.getKey();
            try {
                GTOreDefinition ore = OreDataLoader.fromJson(location, GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)"top element"), (RegistryOps<JsonElement>)ops);
                if (ore == null) {
                    LOGGER.info("Skipping loading ore vein {} as it's serializer returned null", (Object)location);
                    continue;
                }
                if (ore.getVeinGenerator() instanceof NoopVeinGenerator) {
                    LOGGER.info("Removing ore vein {} as it's generator was marked as no-operation", (Object)location);
                    GTRegistries.ORE_VEINS.remove(location);
                    continue;
                }
                if (GTRegistries.ORE_VEINS.containKey(location)) {
                    GTRegistries.ORE_VEINS.replace(location, ore);
                    continue;
                }
                GTRegistries.ORE_VEINS.register(location, ore);
            }
            catch (JsonParseException | IllegalArgumentException jsonParseException) {
                LOGGER.error("Parsing error loading ore vein {}", (Object)location, (Object)jsonParseException);
            }
        }
        Iterator iterator = GTRegistries.ORE_VEINS.entries().iterator();
        while (iterator.hasNext()) {
            GTOreDefinition gTOreDefinition = (GTOreDefinition)iterator.next().getValue();
            if (gTOreDefinition.getVeinGenerator() != null) {
                gTOreDefinition.getVeinGenerator().build();
                continue;
            }
            iterator.remove();
        }
        GTOres.updateLargestVeinSize();
    }

    public static GTOreDefinition fromJson(ResourceLocation id, JsonObject json, RegistryOps<JsonElement> ops) {
        return (GTOreDefinition)GTOreDefinition.FULL_CODEC.decode(ops, (Object)json).map(Pair::getFirst).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
    }

    static {
        GSON_INSTANCE = Deserializers.m_78799_().create();
        LOGGER = LogManager.getLogger();
    }

    public static final class RunKJSEventInSeparateClassBecauseForgeIsDumb {
        public static void fireKJSEvent() {
            GTCEuServerEvents.ORE_VEIN_MODIFICATION.post((ScriptTypeHolder)ScriptType.SERVER, (EventJS)new GTOreVeinEventJS());
        }
    }
}

