/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.generated;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.MarkerMaterials;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ToolProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class ToolRecipeHandler {
    public static void init(Consumer<FinishedRecipe> provider) {
        TagPrefix.plate.executeHandler(PropertyKey.TOOL, (tagPrefix, material, property) -> ToolRecipeHandler.processTool(tagPrefix, material, property, provider));
        TagPrefix.plate.executeHandler(PropertyKey.TOOL, (tagPrefix, material, property) -> ToolRecipeHandler.processElectricTool(tagPrefix, material, property, provider));
        ToolRecipeHandler.registerCustomToolRecipes(provider);
    }

    private static void processTool(TagPrefix prefix, Material material, ToolProperty property, Consumer<FinishedRecipe> provider) {
        ItemStack stick = new ItemStack((ItemLike)Items.f_42398_);
        UnificationEntry plate = new UnificationEntry(TagPrefix.plate, material);
        UnificationEntry ingot = new UnificationEntry(material.hasProperty(PropertyKey.GEM) ? TagPrefix.gem : TagPrefix.ingot, material);
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.MINING_HAMMER, true, "PPf", "PPS", "PPh", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.SAW, false, "PPS", "fhS", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.AXE, false, "PIh", "PS ", "fS ", Character.valueOf('P'), plate, Character.valueOf('I'), ingot, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.HOE, false, "PIh", "fS ", " S ", Character.valueOf('P'), plate, Character.valueOf('I'), ingot, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.PICKAXE, false, "PII", "fSh", " S ", Character.valueOf('P'), plate, Character.valueOf('I'), ingot, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.SCYTHE, false, "PPI", "fSh", " S ", Character.valueOf('P'), plate, Character.valueOf('I'), ingot, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.SHOVEL, false, "fPh", " S ", " S ", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.SWORD, false, " P ", "fPh", " S ", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.HARD_HAMMER, true, "II ", "IIS", "II ", Character.valueOf('I'), ingot, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.FILE, true, " P ", " P ", " S ", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.KNIFE, false, "fPh", " S ", Character.valueOf('P'), plate, Character.valueOf('S'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.WRENCH, false, "PhP", " P ", " P ", Character.valueOf('P'), plate);
        }
        if (material.hasFlag(MaterialFlags.GENERATE_ROD)) {
            UnificationEntry rod = new UnificationEntry(TagPrefix.rod, material);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.PLUNGER, false, "xRR", " SR", "S f", Character.valueOf('S'), rod, Character.valueOf('R'), new UnificationEntry(TagPrefix.plate, GTMaterials.Rubber));
            if (material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
                ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.BUTCHERY_KNIFE, false, "PPf", "PP ", "Sh ", Character.valueOf('P'), plate, Character.valueOf('S'), rod);
                if (material.hasFlag(MaterialFlags.GENERATE_BOLT_SCREW)) {
                    ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.WIRE_CUTTER, false, "PfP", "hPd", "STS", Character.valueOf('P'), plate, Character.valueOf('T'), new UnificationEntry(TagPrefix.screw, material), Character.valueOf('S'), rod);
                }
            }
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.SCREWDRIVER, true, " fS", " Sh", "W  ", Character.valueOf('S'), rod, Character.valueOf('W'), stick);
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.CROWBAR, true, "hDS", "DSD", "SDf", Character.valueOf('S'), rod, Character.valueOf('D'), new UnificationEntry(TagPrefix.dye, MarkerMaterials.Color.Blue));
        }
    }

    private static void processElectricTool(TagPrefix prefix, Material material, ToolProperty property, Consumer<FinishedRecipe> provider) {
        TagPrefix toolPrefix;
        int voltageMultiplier;
        int n = voltageMultiplier = material.getBlastTemperature() > 2800 ? GTValues.VA[1] : GTValues.VA[0];
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
            UnificationEntry plate = new UnificationEntry(TagPrefix.plate, material);
            UnificationEntry steelPlate = new UnificationEntry(TagPrefix.plate, GTMaterials.Steel);
            UnificationEntry steelRing = new UnificationEntry(TagPrefix.ring, GTMaterials.Steel);
            toolPrefix = TagPrefix.toolHeadDrill;
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("drill_head_%s", material), ChemicalHelper.get(toolPrefix, material), "XSX", "XSX", "ShS", Character.valueOf('X'), plate, Character.valueOf('S'), steelPlate);
            toolPrefix = TagPrefix.toolHeadChainsaw;
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("chainsaw_head_%s", material), ChemicalHelper.get(toolPrefix, material), "SRS", "XhX", "SRS", Character.valueOf('X'), plate, Character.valueOf('S'), steelPlate, Character.valueOf('R'), steelRing);
            toolPrefix = TagPrefix.toolHeadWrench;
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("wrench_head_%s", material), ChemicalHelper.get(toolPrefix, material), "hXW", "XRX", "WXd", Character.valueOf('X'), plate, Character.valueOf('R'), steelRing, Character.valueOf('W'), new UnificationEntry(TagPrefix.screw, GTMaterials.Steel));
            toolPrefix = TagPrefix.toolHeadBuzzSaw;
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("buzzsaw_blade_%s", material), ChemicalHelper.get(toolPrefix, material), "sXh", "X X", "fXx", Character.valueOf('X'), plate);
            if (material.hasFlag(MaterialFlags.GENERATE_GEAR)) {
                GTRecipeTypes.LATHE_RECIPES.recipeBuilder("buzzsaw_gear_" + material, new Object[0]).inputItems(TagPrefix.gear, material).outputItems(toolPrefix, material).duration((int)material.getMass() * 4).EUt(8L * (long)voltageMultiplier).save(provider);
            }
        }
        if (material.hasFlag(MaterialFlags.GENERATE_LONG_ROD)) {
            toolPrefix = TagPrefix.toolHeadScrewdriver;
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("screwdriver_tip_%s", material), ChemicalHelper.get(toolPrefix, material), "fR", " h", Character.valueOf('R'), new UnificationEntry(TagPrefix.rodLong, material));
        }
    }

    public static void addToolRecipe(Consumer<FinishedRecipe> provider, @Nonnull Material material, @Nonnull GTToolType tool, boolean mirrored, Object ... recipe) {
        ItemStack toolStack = ToolHelper.get(tool, material);
        if (toolStack.m_41619_()) {
            return;
        }
        if (mirrored) {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("%s_%s", tool.name, material), toolStack, recipe);
        } else {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("%s_%s", tool.name, material), toolStack, recipe);
        }
    }

    public static void registerCustomToolRecipes(Consumer<FinishedRecipe> provider) {
        ToolRecipeHandler.registerFlintToolRecipes(provider);
        ToolRecipeHandler.registerMortarRecipes(provider);
        ToolRecipeHandler.registerSoftToolRecipes(provider);
        ToolRecipeHandler.registerElectricRecipes(provider);
    }

    private static void registerFlintToolRecipes(Consumer<FinishedRecipe> provider) {
        UnificationEntry flint = new UnificationEntry(TagPrefix.gem, GTMaterials.Flint);
        ItemStack stick = new ItemStack((ItemLike)Items.f_42398_);
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.MORTAR, false, " I ", "SIS", "SSS", Character.valueOf('I'), flint, Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50069_));
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.SWORD, false, "I", "I", "S", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.PICKAXE, false, "III", " S ", " S ", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.SHOVEL, false, "I", "S", "S", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.AXE, true, "II", "IS", " S", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.HOE, true, "II", " S", " S", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
        ToolRecipeHandler.addToolRecipe(provider, GTMaterials.Flint, GTToolType.KNIFE, false, "I", "S", Character.valueOf('I'), flint, Character.valueOf('S'), stick);
    }

    private static void registerMortarRecipes(Consumer<FinishedRecipe> provider) {
        for (Material material : new Material[]{GTMaterials.Bronze, GTMaterials.Iron, GTMaterials.Invar, GTMaterials.Steel, GTMaterials.DamascusSteel, GTMaterials.CobaltBrass, GTMaterials.WroughtIron}) {
            ToolRecipeHandler.addToolRecipe(provider, material, GTToolType.MORTAR, false, " I ", "SIS", "SSS", Character.valueOf('I'), new UnificationEntry(material.hasProperty(PropertyKey.GEM) ? TagPrefix.gem : TagPrefix.ingot, material), Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_50069_));
        }
    }

    private static void registerSoftToolRecipes(Consumer<FinishedRecipe> provider) {
        Material[] softMaterials = new Material[]{GTMaterials.Wood, GTMaterials.Rubber, GTMaterials.Polyethylene, GTMaterials.Polytetrafluoroethylene, GTMaterials.Polybenzimidazole};
        ItemStack stick = new ItemStack((ItemLike)Items.f_42398_);
        for (int i = 0; i < softMaterials.length; ++i) {
            Material material = softMaterials[i];
            if (material.hasProperty(PropertyKey.WOOD)) {
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("soft_mallet_%s", material), ToolHelper.get(GTToolType.SOFT_MALLET, material), "II ", "IIS", "II ", Character.valueOf('I'), ItemTags.f_13168_, Character.valueOf('S'), stick);
                continue;
            }
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("soft_mallet_%s", material), ToolHelper.get(GTToolType.SOFT_MALLET, material), "II ", "IIS", "II ", Character.valueOf('I'), new UnificationEntry(TagPrefix.ingot, material), Character.valueOf('S'), stick);
        }
    }

    private static void registerElectricRecipes(Consumer<FinishedRecipe> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, "prospector_lv", GTItems.PROSPECTOR_LV.asStack(), "EPS", "CDC", "PBP", Character.valueOf('E'), GTItems.EMITTER_LV.asStack(), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Steel), Character.valueOf('S'), GTItems.SENSOR_LV.asStack(), Character.valueOf('D'), new UnificationEntry(TagPrefix.plate, GTMaterials.Glass), Character.valueOf('C'), CustomTags.LV_CIRCUITS, Character.valueOf('B'), CustomTags.LV_BATTERIES);
        VanillaRecipeHelper.addShapedRecipe(provider, "prospector_hv", GTItems.PROSPECTOR_HV.asStack(), "EPS", "CDC", "PBP", Character.valueOf('E'), GTItems.EMITTER_HV.asStack(), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.StainlessSteel), Character.valueOf('S'), GTItems.SENSOR_HV.asStack(), Character.valueOf('D'), GTItems.COVER_SCREEN.asStack(), Character.valueOf('C'), CustomTags.HV_CIRCUITS, Character.valueOf('B'), CustomTags.HV_BATTERIES);
        VanillaRecipeHelper.addShapedRecipe(provider, "prospector_luv", GTItems.PROSPECTOR_LUV.asStack(), "EPS", "CDC", "PBP", Character.valueOf('E'), GTItems.EMITTER_LuV.asStack(), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.RhodiumPlatedPalladium), Character.valueOf('S'), GTItems.SENSOR_HV.asStack(), Character.valueOf('D'), GTItems.COVER_SCREEN.asStack(), Character.valueOf('C'), CustomTags.LuV_CIRCUITS, Character.valueOf('B'), CustomTags.LuV_BATTERIES);
    }
}

