/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidDefinition;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.material.Fluid;

public class GTOreVeinWidget
extends WidgetGroup {
    private final String name;
    private final int weight;
    private final String range;
    private final String dimensions;
    private final Set<ResourceKey<Level>> dimensionFilter;
    public static final int width = 120;

    public GTOreVeinWidget(GTOreDefinition oreDefinition) {
        super(0, 0, 120, 160);
        this.name = this.getOreName(oreDefinition);
        this.weight = oreDefinition.getWeight();
        this.dimensionFilter = oreDefinition.getDimensionFilter();
        this.dimensions = this.dimensions();
        this.range = this.range(oreDefinition);
        this.setClientSideWidget();
        this.setupBaseGui(oreDefinition);
        this.setupText(oreDefinition);
    }

    public GTOreVeinWidget(BedrockFluidDefinition fluid) {
        super(0, 0, 120, 140);
        this.name = this.getFluidName(fluid);
        this.weight = fluid.getWeight();
        this.dimensionFilter = fluid.getDimensionFilter();
        this.dimensions = this.dimensions();
        this.range = "NULL";
        this.setClientSideWidget();
        this.setupBaseGui(fluid);
        this.setupText(fluid);
    }

    private String range(GTOreDefinition oreDefinition) {
        HeightProvider height = oreDefinition.getRange().f_191674_;
        int minHeight = 0;
        int maxHeight = 0;
        if (height instanceof UniformHeight) {
            UniformHeight uniform = (UniformHeight)height;
            minHeight = uniform.f_162025_.m_142322_(null);
            maxHeight = uniform.f_162026_.m_142322_(null);
        }
        return String.format("%d - %d", minHeight, maxHeight);
    }

    private void setupBaseGui(GTOreDefinition oreDefinition) {
        NonNullList containedOresAsItemStacks = NonNullList.m_122779_();
        List<Integer> chances = oreDefinition.getVeinGenerator().getAllChances();
        containedOresAsItemStacks.addAll(GTOreVeinWidget.getContainedOresAndBlocks(oreDefinition));
        int n = containedOresAsItemStacks.size();
        int x = (120 - 18 * n) / 2;
        int i = 0;
        while (i < n) {
            SlotWidget oreSlot = new SlotWidget((IItemTransfer)new ItemStackTransfer(containedOresAsItemStacks), i, x, 18, false, false);
            int finalI = i++;
            oreSlot.setOnAddedTooltips((stack, tooltips) -> tooltips.add(Component.m_130674_((String)LocalizationUtils.format((String)"gtceu.jei.ore_vein_diagram.chance", (Object[])new Object[]{chances.get(finalI)}))));
            oreSlot.setIngredientIO(IngredientIO.OUTPUT);
            this.addWidget((Widget)oreSlot);
            x += 18;
        }
    }

    private void setupBaseGui(BedrockFluidDefinition fluid) {
        Fluid storedFluid = fluid.getStoredFluid().get();
        TankWidget fluidSlot = new TankWidget((IFluidStorage)new FluidStorage(FluidStack.create((Fluid)storedFluid, (long)1000L)), 51, 18, false, false);
        fluidSlot.setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)fluidSlot);
    }

    private void setupText(GTOreDefinition oreDefinition) {
        this.addWidget((Widget)new ImageWidget(5, 0, 110, 16, (IGuiTexture)new TextTexture("gtceu.jei.ore_vein." + this.name).setType(TextTexture.TextType.LEFT_ROLL).setWidth(110)));
        this.addWidget((Widget)new LabelWidget(5, 40, LocalizationUtils.format((String)"gtceu.jei.ore_vein_diagram.spawn_range", (Object[])new Object[0])));
        this.addWidget((Widget)new LabelWidget(5, 50, this.range));
        this.addWidget((Widget)new LabelWidget(5, 60, LocalizationUtils.format((String)"gtceu.jei.ore_vein_diagram.weight", (Object[])new Object[]{this.weight})));
        this.addWidget((Widget)new LabelWidget(5, 70, LocalizationUtils.format((String)"gtceu.jei.ore_vein_diagram.dimensions", (Object[])new Object[0])));
        this.addWidget((Widget)new LabelWidget(5, 80, this.dimensions));
    }

    private void setupText(BedrockFluidDefinition fluid) {
        this.addWidget((Widget)new ImageWidget(5, 0, 110, 16, (IGuiTexture)new TextTexture("gtceu.jei.bedrock_fluid." + this.name).setType(TextTexture.TextType.LEFT_ROLL).setWidth(110)));
        this.addWidget((Widget)new LabelWidget(5, 40, LocalizationUtils.format((String)"gtceu.jei.ore_vein_diagram.weight", (Object[])new Object[]{this.weight})));
        this.addWidget((Widget)new LabelWidget(5, 50, LocalizationUtils.format((String)"gtceu.jei.ore_vein_diagram.dimensions", (Object[])new Object[0])));
        this.addWidget((Widget)new LabelWidget(5, 60, this.dimensions));
    }

    private String dimensions() {
        if (this.dimensionFilter == null) {
            return "Any";
        }
        return this.dimensionFilter.stream().map(dimension -> dimension.m_135782_().toString()).collect(Collectors.joining("\n"));
    }

    public static List<ItemStack> getContainedOresAndBlocks(GTOreDefinition oreDefinition) {
        return oreDefinition.getVeinGenerator().getAllEntries().stream().map(entry -> (ItemStack)((Either)entry.getKey()).map(state -> state.m_60734_().m_5456_().m_7968_(), material -> ChemicalHelper.get(TagPrefix.rawOre, material))).toList();
    }

    public String getOreName(GTOreDefinition oreDefinition) {
        ResourceLocation id = (ResourceLocation)GTRegistries.ORE_VEINS.getKey(oreDefinition);
        return id.m_135815_();
    }

    public String getFluidName(BedrockFluidDefinition fluid) {
        ResourceLocation id = (ResourceLocation)GTRegistries.BEDROCK_FLUID_DEFINITIONS.getKey(fluid);
        return id.m_135815_();
    }

    public String getName() {
        return this.name;
    }

    public int getWeight() {
        return this.weight;
    }

    public String getRange() {
        return this.range;
    }

    public String getDimensions() {
        return this.dimensions;
    }

    public Set<ResourceKey<Level>> getDimensionFilter() {
        return this.dimensionFilter;
    }
}

