/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.gui.widget;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.AEListGridWidget;
import com.gregtechceu.gtceu.integration.ae2.util.AEConfigSlot;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class AEItemDisplayWidget
extends Widget {
    private final AEListGridWidget gridWidget;
    private final int index;

    public AEItemDisplayWidget(int x, int y, AEListGridWidget gridWidget, int index) {
        super(new Position(x, y), new Size(18, 18));
        this.gridWidget = gridWidget;
        this.index = index;
    }

    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        Position position = this.getPosition();
        GenericStack item = this.gridWidget.getAt(this.index);
        GuiTextures.SLOT.draw(graphics, mouseX, mouseY, (float)position.x, (float)position.y, 18, 18);
        GuiTextures.NUMBER_BACKGROUND.draw(graphics, mouseX, mouseY, (float)(position.x + 18), (float)position.y, 140, 18);
        int stackX = position.x + 1;
        int stackY = position.y + 1;
        if (item != null) {
            ItemStack itemStack;
            AEKey aEKey = item.what();
            if (aEKey instanceof AEItemKey) {
                AEItemKey key = (AEItemKey)aEKey;
                itemStack = new ItemStack((ItemLike)key.getItem(), (int)item.amount());
            } else {
                itemStack = ItemStack.f_41583_;
            }
            ItemStack realStack = itemStack;
            realStack.m_41764_(1);
            DrawerHelper.drawItemStack((GuiGraphics)graphics, (ItemStack)realStack, (int)stackX, (int)stackY, (int)-1, null);
            String amountStr = String.format("x%,d", item.amount());
            DrawerHelper.drawText((GuiGraphics)graphics, (String)amountStr, (float)(stackX + 20), (float)(stackY + 5), (float)1.0f, (int)-1);
        }
        if (this.isMouseOverElement(mouseX, mouseY)) {
            AEConfigSlot.drawSelectionOverlay(graphics, stackX, stackY, 16, 16);
        }
    }

    public void drawInForeground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        GenericStack item;
        if (this.isMouseOverElement(mouseX, mouseY) && (item = this.gridWidget.getAt(this.index)) != null) {
            graphics.m_280153_(Minecraft.m_91087_().f_91062_, GenericStack.wrapInItemStack((GenericStack)item), mouseX, mouseY);
        }
    }
}

