/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.machine;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.me.helpers.BlockEntityNodeListener;
import appeng.me.helpers.IGridConnectedBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.common.machine.multiblock.part.ItemBusPartMachine;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.integration.ae2.util.SerializableManagedGridNode;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.ReadOnlyManaged;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class MEBusPartMachine
extends ItemBusPartMachine
implements IInWorldGridNodeHost,
IGridConnectedBlockEntity {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MEBusPartMachine.class, ItemBusPartMachine.MANAGED_FIELD_HOLDER);
    public static final int ME_UPDATE_INTERVAL = ConfigHolder.INSTANCE.compat.ae2.updateIntervals;
    @Persisted
    @ReadOnlyManaged(onDirtyMethod="onGridNodeDirty", serializeMethod="serializeGridNode", deserializeMethod="deserializeGridNode")
    private final SerializableManagedGridNode mainNode;
    protected final IActionSource actionSource;
    @DescSynced
    protected boolean isOnline;
    private IGrid aeProxy;

    public MEBusPartMachine(IMachineBlockEntity holder, IO io, Object ... args) {
        super(holder, 9, io, args);
        this.mainNode = (SerializableManagedGridNode)this.createMainNode().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).setVisualRepresentation((ItemLike)this.getDefinition().getItem()).setIdlePowerUsage(ConfigHolder.INSTANCE.compat.ae2.meHatchEnergyUsage).setInWorldNode(true).setExposedOnSides(this.hasFrontFacing() ? EnumSet.of(this.getFrontFacing()) : EnumSet.allOf(Direction.class)).setTagName("proxy");
        this.actionSource = IActionSource.ofMachine(() -> ((SerializableManagedGridNode)this.mainNode).getNode());
    }

    protected boolean shouldSyncME() {
        return this.getOffsetTimer() % (long)ME_UPDATE_INTERVAL == 0L;
    }

    @Override
    public void setFrontFacing(Direction facing) {
        super.setFrontFacing(facing);
        if (this.isFacingValid(facing)) {
            this.mainNode.setExposedOnSides(this.hasFrontFacing() ? EnumSet.of(facing) : EnumSet.allOf(Direction.class));
        }
    }

    @Override
    protected void updateInventorySubscription() {
        if (this.isWorkingEnabled() && (this.io == IO.OUT && !this.getInventory().isEmpty() || this.io == IO.IN) && this.getLevel() != null && GridHelper.getNodeHost((Level)this.getLevel(), (BlockPos)this.getPos().m_121945_(this.getFrontFacing())) != null) {
            this.autoIOSubs = this.subscribeServerTick(this.autoIOSubs, () -> this.autoIO());
        } else if (this.autoIOSubs != null) {
            this.autoIOSubs.unsubscribe();
            this.autoIOSubs = null;
        }
    }

    public boolean updateMEStatus() {
        if (this.aeProxy == null) {
            this.aeProxy = this.mainNode.getGrid();
        }
        this.isOnline = this.aeProxy != null ? this.mainNode.isOnline() && this.mainNode.isPowered() : false;
        return this.isOnline;
    }

    protected IManagedGridNode createMainNode() {
        return new SerializableManagedGridNode(this, BlockEntityNodeListener.INSTANCE);
    }

    public void saveChanges() {
        this.onChanged();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::createManagedNode));
            this.inventorySubs = this.getInventory().addChangedListener(this::updateInventorySubscription);
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        this.mainNode.destroy();
    }

    @Override
    public void onChanged() {
        super.onChanged();
        this.updateInventorySubscription();
    }

    protected void createManagedNode() {
        this.mainNode.create(this.getLevel(), this.getPos());
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public boolean onGridNodeDirty(SerializableManagedGridNode node) {
        return node != null && node.isActive() && node.isOnline();
    }

    public CompoundTag serializeGridNode(SerializableManagedGridNode node) {
        return node.serializeNBT();
    }

    public SerializableManagedGridNode deserializeGridNode(CompoundTag tag) {
        this.mainNode.deserializeNBT(tag);
        return this.mainNode;
    }

    public SerializableManagedGridNode getMainNode() {
        return this.mainNode;
    }
}

