/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.integration.jade.provider.CapabilityBlockProvider;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IBoxStyle;
import snownee.jade.api.ui.IElementHelper;

public class ElectricContainerBlockProvider
extends CapabilityBlockProvider<IEnergyContainer> {
    public ElectricContainerBlockProvider() {
        super(GTCEu.id("electric_container_provider"));
    }

    @Override
    @Nullable
    protected IEnergyContainer getCapability(Level level, BlockPos pos, @Nullable Direction side) {
        return GTCapabilityHelper.getEnergyContainer(level, pos, side);
    }

    @Override
    protected void write(CompoundTag data, IEnergyContainer capability) {
        data.m_128356_("Energy", capability.getEnergyStored());
        data.m_128356_("MaxEnergy", capability.getEnergyCapacity());
    }

    @Override
    protected void addTooltip(CompoundTag capData, ITooltip tooltip, Player player, BlockAccessor block, BlockEntity blockEntity, IPluginConfig config) {
        long maxStorage = capData.m_128454_("MaxEnergy");
        if (maxStorage == 0L) {
            return;
        }
        long stored = capData.m_128454_("Energy");
        IElementHelper helper = tooltip.getElementHelper();
        tooltip.add(helper.progress(this.getProgress(stored, maxStorage), (Component)Component.m_237113_((String)(stored + " / " + maxStorage + " EU")), helper.progressStyle().color(-1120768, -1120768).textColor(-1), (IBoxStyle)Util.m_137469_((Object)BoxStyle.DEFAULT, style -> {
            style.borderColor = -11184811;
        }), true));
    }

    @Override
    protected boolean allowDisplaying(IEnergyContainer capability) {
        return !capability.isOneProbeHidden();
    }
}

