/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.builders;

import com.google.gson.JsonArray;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.worldgen.BiomeWeightModifier;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.IWorldGenLayer;
import com.gregtechceu.gtceu.api.data.worldgen.generator.IndicatorGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.VeinGenerator;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import org.slf4j.Logger;

public class OreVeinBuilderJS {
    private final ResourceLocation id;
    public transient int clusterSize;
    public transient int weight;
    public transient float density;
    public transient float discardChanceOnAirExposure;
    public transient IWorldGenLayer layer;
    public transient HeightRangePlacement heightRange;
    public transient BiomeWeightModifier biomeWeightModifier;
    public VeinGenerator generator;
    private final transient List<IndicatorGenerator> indicatorGenerators = new ArrayList<IndicatorGenerator>();
    private final transient Set<ResourceKey<Level>> dimensions = new HashSet<ResourceKey<Level>>();
    private final transient JsonArray biomeFilter = new JsonArray();
    private boolean isBuilt = false;

    public OreVeinBuilderJS(ResourceLocation id) {
        this.id = id;
    }

    public OreVeinBuilderJS addSpawnDimension(ResourceLocation dimension) {
        this.dimensions.add((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimension));
        return this;
    }

    public OreVeinBuilderJS addSpawnBiome(String biome) {
        this.biomeFilter.add(biome);
        return this;
    }

    public OreVeinBuilderJS addIndicator(IndicatorGenerator indicatorGenerator) {
        this.indicatorGenerators.add(indicatorGenerator);
        return this;
    }

    public VeinGenerator generatorBuilder(ResourceLocation id) {
        return this.build().generator(id);
    }

    @HideFromJS
    public GTOreDefinition build() {
        RegistryOps registryOps = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)GTRegistries.builtinRegistry());
        Supplier<HolderSet<Biome>> biomes = this.biomeFilter.isEmpty() ? null : () -> (HolderSet)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256952_).decode((DynamicOps)registryOps, this.biomeFilter.size() == 1 ? this.biomeFilter.get(0) : this.biomeFilter).map(Pair::getFirst).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0));
        this.isBuilt = true;
        return new GTOreDefinition(this.id, this.clusterSize, this.density, this.weight, this.layer, this.dimensions, this.heightRange, this.discardChanceOnAirExposure, biomes, this.biomeWeightModifier, this.generator, this.indicatorGenerators);
    }

    public OreVeinBuilderJS clusterSize(int clusterSize) {
        this.clusterSize = clusterSize;
        return this;
    }

    public OreVeinBuilderJS weight(int weight) {
        this.weight = weight;
        return this;
    }

    public OreVeinBuilderJS density(float density) {
        this.density = density;
        return this;
    }

    public OreVeinBuilderJS discardChanceOnAirExposure(float discardChanceOnAirExposure) {
        this.discardChanceOnAirExposure = discardChanceOnAirExposure;
        return this;
    }

    public OreVeinBuilderJS layer(IWorldGenLayer layer) {
        this.layer = layer;
        return this;
    }

    public OreVeinBuilderJS heightRange(HeightRangePlacement heightRange) {
        this.heightRange = heightRange;
        return this;
    }

    public OreVeinBuilderJS biomeWeightModifier(BiomeWeightModifier biomeWeightModifier) {
        this.biomeWeightModifier = biomeWeightModifier;
        return this;
    }

    public OreVeinBuilderJS generator(VeinGenerator generator) {
        this.generator = generator;
        return this;
    }

    public boolean isBuilt() {
        return this.isBuilt;
    }
}

