/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.builders.machine;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.registry.registrate.MachineBuilder;
import com.gregtechceu.gtceu.integration.kjs.builders.machine.MachineFunctionPresets;
import com.gregtechceu.gtceu.integration.kjs.builders.machine.SimpleMachineBuilder;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.BaseFunction;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;

public class CustomTieredMachineBuilder
extends SimpleMachineBuilder {
    public CustomTieredMachineBuilder(String name, Function<IMachineBlockEntity, MetaMachine> machineConstructor) {
        super(name, machineConstructor);
    }

    @Override
    public CustomTieredMachineBuilder tier(int tier) {
        return (CustomTieredMachineBuilder)super.tier(tier);
    }

    private static CustomTieredMachineBuilder[] customTiered(String name, BiFunction<IMachineBlockEntity, Integer, MetaMachine> machineConstructor, Integer ... tiers) {
        CustomTieredMachineBuilder[] builders = new CustomTieredMachineBuilder[15];
        Integer[] integerArray = tiers;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            CustomTieredMachineBuilder register;
            int tier = integerArray[i];
            builders[tier] = register = new CustomTieredMachineBuilder(GTValues.VN[tier].toLowerCase(Locale.ROOT) + "_" + name, holder -> (MetaMachine)machineConstructor.apply((IMachineBlockEntity)holder, tier)).tier(tier);
        }
        return builders;
    }

    public static MachineBuilder<MachineDefinition> createAll(String name, Object ... args) {
        MachineBuilder[] builders = new CustomTieredMachineBuilder[]{};
        if (args.length > 1) {
            Integer[] tiers = MachineFunctionPresets.mapTierArray(MachineFunctionPresets.copyArgs(args, 1));
            Object object = args[0];
            if (object instanceof BiFunction) {
                BiFunction machineFunction = (BiFunction)object;
                builders = CustomTieredMachineBuilder.customTiered(name, machineFunction, tiers);
            } else {
                object = args[0];
                if (object instanceof BaseFunction) {
                    BaseFunction machineFunction = (BaseFunction)object;
                    builders = CustomTieredMachineBuilder.customTiered(name, (BiFunction)UtilsJS.makeFunctionProxy((ScriptType)ScriptType.STARTUP, BiFunction.class, (BaseFunction)machineFunction), tiers);
                }
            }
        }
        return MachineFunctionPresets.builder((String)name, (MachineBuilder[])builders, CustomTieredMachineBuilder.class, MachineDefinition::createDefinition, MetaMachineBlock::new, MetaMachineBlockEntity::createBlockEntity);
    }
}

