/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.rei.recipe;

import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.integration.rei.recipe.GTRecipeDisplay;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.rei.IGui2Renderer;
import com.lowdragmc.lowdraglib.rei.ModularUIDisplayCategory;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.function.Function;
import javax.annotation.Nonnull;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;

public class GTRecipeTypeDisplayCategory
extends ModularUIDisplayCategory<GTRecipeDisplay> {
    public static final Function<GTRecipeType, CategoryIdentifier<GTRecipeDisplay>> CATEGORIES = Util.m_143827_(recipeType -> CategoryIdentifier.of((ResourceLocation)recipeType.registryName));
    private final GTRecipeType recipeType;
    private final Renderer icon;
    private final Size size;

    public GTRecipeTypeDisplayCategory(GTRecipeType recipeType) {
        this.recipeType = recipeType;
        Size size = recipeType.getJEISize();
        this.size = new Size(size.width + 8, size.height + 8);
        this.icon = recipeType.getIconSupplier() != null ? IGui2Renderer.toDrawable((IGuiTexture)new ItemStackTexture(new ItemStack[]{recipeType.getIconSupplier().get()})) : IGui2Renderer.toDrawable((IGuiTexture)new ItemStackTexture(new ItemStack[]{Items.f_42127_.m_7968_()}));
    }

    public CategoryIdentifier<? extends GTRecipeDisplay> getCategoryIdentifier() {
        return CATEGORIES.apply(this.recipeType);
    }

    public int getDisplayHeight() {
        return this.getSize().height;
    }

    public int getDisplayWidth(GTRecipeDisplay display) {
        return this.getSize().width;
    }

    @Nonnull
    public Component getTitle() {
        return Component.m_237115_((String)this.recipeType.registryName.m_214298_());
    }

    public static void registerDisplays(DisplayRegistry registry) {
        for (RecipeType recipeType : BuiltInRegistries.f_256990_) {
            if (!(recipeType instanceof GTRecipeType)) continue;
            GTRecipeType gtRecipeType = (GTRecipeType)recipeType;
            registry.registerRecipeFiller(GTRecipe.class, (RecipeType)gtRecipeType, GTRecipeDisplay::new);
        }
    }

    public static void registerWorkStations(CategoryRegistry registry) {
        for (GTRecipeType gtRecipeType : GTRegistries.RECIPE_TYPES) {
            for (MachineDefinition machine : GTRegistries.MACHINES) {
                if (machine.getRecipeTypes() == null) continue;
                for (GTRecipeType type : machine.getRecipeTypes()) {
                    if (type != gtRecipeType) continue;
                    registry.addWorkstations(CATEGORIES.apply(gtRecipeType), new EntryStack[]{EntryStacks.of((ItemStack)machine.asStack())});
                }
            }
        }
    }

    public Renderer getIcon() {
        return this.icon;
    }

    public Size getSize() {
        return this.size;
    }
}

