/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.top.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IWorkable;
import com.gregtechceu.gtceu.integration.top.provider.CapabilityInfoProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class WorkableInfoProvider
extends CapabilityInfoProvider<IWorkable> {
    public ResourceLocation getID() {
        return GTCEu.id("workable_provider");
    }

    @Override
    @Nullable
    protected IWorkable getCapability(Level level, BlockPos pos, @Nullable Direction side) {
        return GTCapabilityHelper.getWorkable(level, pos, side);
    }

    @Override
    protected void addProbeInfo(IWorkable capability, IProbeInfo probeInfo, Player player, BlockEntity blockEntity, IProbeHitData data) {
        String text;
        if (!capability.isActive()) {
            return;
        }
        int currentProgress = capability.getProgress();
        int maxProgress = capability.getMaxProgress();
        if (maxProgress < 20) {
            text = " / " + maxProgress + " t";
        } else {
            currentProgress = Math.round((float)currentProgress / 20.0f);
            maxProgress = Math.round((float)maxProgress / 20.0f);
            text = " / " + maxProgress + " s";
        }
        if (maxProgress > 0) {
            int color = capability.isWorkingEnabled() ? -11748585 : -4514776;
            probeInfo.progress(currentProgress, maxProgress, probeInfo.defaultProgressStyle().suffix(text).filledColor(color).alternateFilledColor(color).borderColor(-11184811));
        }
    }
}

