/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;

public class OreDictExprFilter {
    private static final Pattern PARTS_PATTERN = Pattern.compile("\\*+");

    public static List<MatchRule> parseExpression(String expression) {
        ArrayList<MatchRule> rules = new ArrayList<MatchRule>();
        OreDictExprFilter.parseExpression(rules, expression);
        return rules;
    }

    public static int parseExpression(List<MatchRule> rules, String expression) {
        rules.clear();
        StringBuilder builder = new StringBuilder();
        block6: for (int i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (c == ' ') continue;
            if (c == '(') {
                ArrayList<MatchRule> subRules = new ArrayList<MatchRule>();
                i = OreDictExprFilter.parseExpression(subRules, expression.substring(i + 1)) + i + 1;
                rules.add(MatchRule.group(subRules, builder.toString()));
                builder = new StringBuilder();
                continue;
            }
            switch (c) {
                case '&': {
                    rules.add(new MatchRule(builder.toString()));
                    rules.add(new MatchRule(MatchLogic.AND));
                    builder = new StringBuilder();
                    continue block6;
                }
                case '|': {
                    rules.add(new MatchRule(builder.toString()));
                    rules.add(new MatchRule(MatchLogic.OR));
                    builder = new StringBuilder();
                    continue block6;
                }
                case '^': {
                    rules.add(new MatchRule(builder.toString()));
                    rules.add(new MatchRule(MatchLogic.XOR));
                    builder = new StringBuilder();
                    continue block6;
                }
                case ')': {
                    rules.add(new MatchRule(builder.toString()));
                    return i + 1;
                }
                default: {
                    builder.append(c);
                }
            }
        }
        if (builder.length() > 0) {
            rules.add(new MatchRule(builder.toString()));
        }
        return expression.length();
    }

    public static boolean matchesOreDict(List<MatchRule> rules, ItemStack stack) {
        Set oreDicts = stack.m_204131_().map(TagKey::f_203868_).map(ResourceLocation::m_135815_).collect(Collectors.toSet());
        if (oreDicts.isEmpty()) {
            return false;
        }
        if (rules == null || rules.isEmpty()) {
            return false;
        }
        for (String oreDict : oreDicts) {
            if (!OreDictExprFilter.matches(rules, oreDict)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesOreDict(List<MatchRule> rules, FluidStack stack) {
        Set oreDicts = stack.getFluid().m_76145_().m_205075_().map(TagKey::f_203868_).map(ResourceLocation::m_135815_).collect(Collectors.toSet());
        if (oreDicts.size() == 0) {
            return false;
        }
        if (rules == null || rules.isEmpty()) {
            return false;
        }
        for (String oreDict : oreDicts) {
            if (!OreDictExprFilter.matches(rules, oreDict)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(List<MatchRule> rules, String oreDict) {
        boolean first = true;
        boolean lastResult = false;
        MatchLogic lastLogic = null;
        for (MatchRule rule : rules) {
            if (lastLogic == null && (rule.logic == MatchLogic.AND || rule.logic == MatchLogic.OR || rule.logic == MatchLogic.XOR)) {
                lastLogic = rule.logic;
                continue;
            }
            if (lastLogic == null && !first) continue;
            if (lastLogic != null) {
                switch (lastLogic) {
                    case AND: {
                        if (lastResult) break;
                        return false;
                    }
                    case OR: {
                        if (!lastResult) break;
                        return true;
                    }
                }
            }
            boolean newResult = rule.isGroup() ? rule.logic == MatchLogic.NOT ^ OreDictExprFilter.matches(rule.subRules, oreDict) : OreDictExprFilter.matches(rule, oreDict);
            if (lastLogic == MatchLogic.XOR && lastResult == newResult) {
                return false;
            }
            lastLogic = null;
            lastResult = newResult;
            first = false;
        }
        return lastResult;
    }

    private static boolean matches(MatchRule rule, String oreDict) {
        String filter = rule.expression;
        if (filter.equals("*")) {
            return true;
        }
        boolean startWild = filter.startsWith("*");
        boolean endWild = filter.endsWith("*");
        if (startWild) {
            filter = filter.substring(1);
        }
        String[] parts = PARTS_PATTERN.split(filter);
        return rule.logic == MatchLogic.NOT ^ OreDictExprFilter.matches(parts, oreDict, startWild, endWild);
    }

    private static boolean matches(String[] filter, String oreDict, boolean startWild, boolean endWild) {
        int newIndex;
        String part;
        int i;
        String lastlastPart = filter[0];
        String lastPart = filter[0];
        int index = oreDict.indexOf(lastPart);
        if (!startWild && index != 0 || index < 0) {
            return false;
        }
        boolean didGoBack = false;
        for (i = 1; i < filter.length; ++i) {
            part = filter[i];
            newIndex = oreDict.indexOf(part, index + lastPart.length());
            if (newIndex < 0) {
                if (i > 1 && !didGoBack) {
                    i -= 2;
                    lastPart = lastlastPart;
                    didGoBack = true;
                    continue;
                }
                return false;
            }
            lastlastPart = lastPart;
            lastPart = part;
            index = newIndex;
            if (!didGoBack) continue;
            didGoBack = false;
        }
        if (endWild || lastPart.length() + index == oreDict.length()) {
            return true;
        }
        for (i = filter.length - 1; i < filter.length; ++i) {
            part = filter[i];
            newIndex = oreDict.indexOf(part, index + lastPart.length());
            if (newIndex < 0) {
                if (i > 1 && !didGoBack) {
                    i -= 2;
                    lastPart = lastlastPart;
                    didGoBack = true;
                    continue;
                }
                return false;
            }
            lastlastPart = lastPart;
            lastPart = part;
            index = newIndex;
            if (!didGoBack) continue;
            didGoBack = false;
        }
        return lastPart.length() + index == oreDict.length();
    }

    public static class MatchRule {
        public final MatchLogic logic;
        public final String expression;
        private final List<MatchRule> subRules;

        private MatchRule(MatchLogic logic, String expression, List<MatchRule> subRules) {
            if (expression.startsWith("!")) {
                logic = MatchLogic.NOT;
                expression = expression.substring(1);
            }
            this.logic = logic;
            this.expression = expression;
            this.subRules = subRules;
        }

        public MatchRule(MatchLogic logic, String expression) {
            this(logic, expression, null);
        }

        public MatchRule(MatchLogic logic) {
            this(logic, "");
        }

        public MatchRule(String expression) {
            this(MatchLogic.ANY, expression);
        }

        public static MatchRule not(String expression, boolean not) {
            return new MatchRule(not ? MatchLogic.NOT : MatchLogic.ANY, expression);
        }

        public static MatchRule group(List<MatchRule> subRules, String expression) {
            MatchLogic logic = expression.startsWith("!") ? MatchLogic.NOT : MatchLogic.ANY;
            return new MatchRule(logic, "", subRules);
        }

        public boolean isGroup() {
            return this.subRules != null;
        }

        @Nullable
        public List<MatchRule> getSubRules() {
            return this.subRules;
        }
    }

    public static enum MatchLogic {
        OR,
        AND,
        XOR,
        NOT,
        ANY;

    }
}

