/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.blocks;

import earth.terrarium.handcrafted.common.blockentities.ContainerBlockEntity;
import earth.terrarium.handcrafted.common.blocks.base.Hammerable;
import earth.terrarium.handcrafted.common.blocks.base.properties.CounterProperty;
import earth.terrarium.handcrafted.common.constants.ConstantComponents;
import earth.terrarium.handcrafted.common.registry.ModItems;
import earth.terrarium.handcrafted.common.registry.ModSoundEvents;
import earth.terrarium.handcrafted.common.utils.InteractionUtils;
import earth.terrarium.handcrafted.common.utils.TooltipUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CounterBlock
extends HorizontalDirectionalBlock
implements Hammerable,
EntityBlock {
    public static final IntegerProperty TYPE = IntegerProperty.m_61631_((String)"type", (int)1, (int)3);
    public static final EnumProperty<CounterProperty> COUNTER = EnumProperty.m_61587_((String)"counter", CounterProperty.class);

    public CounterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)TYPE, (Comparable)Integer.valueOf(1))).m_61124_(COUNTER, (Comparable)((Object)CounterProperty.CALCITE)));
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (!level.m_5776_() && state.m_60734_() != newState.m_60734_() && !((CounterProperty)((Object)state.m_61143_(COUNTER))).toBlock().m_150930_(Items.f_151047_)) {
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)((CounterProperty)((Object)state.m_61143_(COUNTER))).toBlock());
        }
        if (state.m_60734_() != newState.m_60734_()) {
            ContainerBlockEntity container;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ContainerBlockEntity && (container = (ContainerBlockEntity)blockEntity).m_6643_() > 0) {
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)container);
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, moved);
        }
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        InteractionResult result = InteractionUtils.interactCounter(state, level, pos, player, hand, COUNTER);
        if (result != InteractionResult.PASS || !((blockEntity = level.m_7702_(pos)) instanceof ContainerBlockEntity)) {
            return result;
        }
        ContainerBlockEntity container = (ContainerBlockEntity)blockEntity;
        if (player.m_21120_(hand).m_150930_((Item)ModItems.HAMMER.get())) {
            return InteractionResult.PASS;
        }
        player.m_5893_((MenuProvider)container);
        return InteractionResult.SUCCESS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, TYPE, COUNTER});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_().m_122424_());
    }

    @Override
    public void onHammer(Level level, BlockPos pos, BlockState state, Direction side, Player user, Vec3 hitPos) {
        if (level.m_5776_()) {
            return;
        }
        level.m_46597_(pos, (BlockState)state.m_61122_((Property)TYPE));
        level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.HAMMER_WOOD.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ContainerBlockEntity(pos, state);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        TooltipUtils.addDescriptionComponent(tooltip, ConstantComponents.COUNTER, ConstantComponents.HAMMER_USE_LOOK);
    }
}

