/*
 * Decompiled with CFR 0.152.
 */
package commoble.hyperbox;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import commoble.hyperbox.CommonConfig;
import commoble.hyperbox.ConfigHelper;
import commoble.hyperbox.blocks.ApertureBlock;
import commoble.hyperbox.blocks.ApertureBlockEntity;
import commoble.hyperbox.blocks.HyperboxBlock;
import commoble.hyperbox.blocks.HyperboxBlockEntity;
import commoble.hyperbox.blocks.HyperboxBlockItem;
import commoble.hyperbox.blocks.HyperboxMenu;
import commoble.hyperbox.client.ClientProxy;
import commoble.hyperbox.dimension.DelayedTeleportData;
import commoble.hyperbox.dimension.HyperboxChunkGenerator;
import commoble.hyperbox.dimension.HyperboxDimension;
import commoble.hyperbox.dimension.HyperboxWorldData;
import commoble.hyperbox.dimension.ReturnPointCapability;
import commoble.hyperbox.dimension.TeleportHelper;
import commoble.hyperbox.network.C2SSaveHyperboxPacket;
import commoble.hyperbox.network.PacketSerializer;
import commoble.infiniverse.api.InfiniverseAPI;
import commoble.infiniverse.api.UnregisterDimensionEvent;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="hyperbox")
public class Hyperbox {
    public static final String MODID = "hyperbox";
    public static Hyperbox INSTANCE;
    public static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel CHANNEL;
    public static final ResourceLocation HYPERBOX_ID;
    public static final ResourceKey<Biome> BIOME_KEY;
    public static final ResourceKey<Level> WORLD_KEY;
    public static final ResourceKey<LevelStem> DIMENSION_KEY;
    public static final ResourceKey<DimensionType> DIMENSION_TYPE_KEY;
    public final CommonConfig commonConfig;
    public final RegistryObject<HyperboxBlock> hyperboxBlock;
    public final RegistryObject<HyperboxBlock> hyperboxPreviewBlock;
    public final RegistryObject<ApertureBlock> apertureBlock;
    public final RegistryObject<BlockItem> hyperboxItem;
    public final RegistryObject<BlockEntityType<HyperboxBlockEntity>> hyperboxBlockEntityType;
    public final RegistryObject<BlockEntityType<ApertureBlockEntity>> apertureBlockEntityType;
    public final RegistryObject<MenuType<HyperboxMenu>> hyperboxMenuType;
    public final RegistryObject<Codec<HyperboxChunkGenerator>> hyperboxChunkGeneratorCodec;

    public Hyperbox() {
        INSTANCE = this;
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        this.commonConfig = ConfigHelper.register(ModConfig.Type.COMMON, CommonConfig::new);
        DeferredRegister soundEvents = Hyperbox.makeVanillaRegister(modBus, Registries.f_256840_);
        DeferredRegister blocks = Hyperbox.makeRegister(modBus, ForgeRegistries.BLOCKS);
        DeferredRegister items = Hyperbox.makeRegister(modBus, ForgeRegistries.ITEMS);
        DeferredRegister tileEntities = Hyperbox.makeRegister(modBus, ForgeRegistries.BLOCK_ENTITY_TYPES);
        DeferredRegister menuTypes = Hyperbox.makeRegister(modBus, ForgeRegistries.MENU_TYPES);
        DeferredRegister chunkGeneratorCodecs = Hyperbox.makeVanillaRegister(modBus, Registries.f_256783_);
        soundEvents.register("ambience", () -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(MODID, "ambience")));
        this.hyperboxBlock = blocks.register(MODID, () -> new HyperboxBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50492_).m_60913_(2.0f, 1200.0f).m_60924_(HyperboxBlock::getIsNormalCube)));
        this.hyperboxPreviewBlock = blocks.register("hyperbox_preview", () -> new HyperboxBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50492_).m_60913_(2.0f, 1200.0f).m_60924_(HyperboxBlock::getIsNormalCube)));
        this.hyperboxItem = items.register(MODID, () -> new HyperboxBlockItem((Block)this.hyperboxBlock.get(), new Item.Properties()));
        this.hyperboxBlockEntityType = tileEntities.register(MODID, () -> BlockEntityType.Builder.m_155273_(HyperboxBlockEntity::create, (Block[])new Block[]{(Block)this.hyperboxBlock.get()}).m_58966_(null));
        this.apertureBlock = blocks.register("aperture", () -> new ApertureBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50375_).m_60953_(state -> 6).m_60924_(HyperboxBlock::getIsNormalCube)));
        this.apertureBlockEntityType = tileEntities.register("aperture", () -> BlockEntityType.Builder.m_155273_(ApertureBlockEntity::create, (Block[])new Block[]{(Block)this.apertureBlock.get()}).m_58966_(null));
        this.hyperboxMenuType = menuTypes.register(MODID, () -> new MenuType(HyperboxMenu::makeClientMenu, FeatureFlags.f_244377_));
        this.hyperboxChunkGeneratorCodec = chunkGeneratorCodecs.register(MODID, HyperboxChunkGenerator::makeCodec);
        modBus.addListener(this::onRegisterCapabilities);
        modBus.addListener(this::onBuildTabContents);
        forgeBus.addListener(this::onUnregisterDimension);
        forgeBus.addListener(EventPriority.HIGH, this::onHighPriorityWorldTick);
        forgeBus.addGenericListener(Entity.class, this::onAttachEntityCapabilities);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientProxy.doClientModInit(modBus, forgeBus);
        }
        int id = 0;
        PacketSerializer.register(id++, CHANNEL, C2SSaveHyperboxPacket.SERIALIZER);
    }

    private void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(ReturnPointCapability.class);
    }

    private void onBuildTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256791_ || event.getTabKey() == CreativeModeTabs.f_257028_) {
            event.accept(this.hyperboxItem);
        }
    }

    private void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof Player) {
            event.addCapability(ReturnPointCapability.ID, (ICapabilityProvider)new ReturnPointCapability());
        }
    }

    private void onUnregisterDimension(UnregisterDimensionEvent event) {
        ServerLevel level = event.getLevel();
        MinecraftServer server = level.m_7654_();
        DimensionType hyperboxDimensionType = HyperboxDimension.getDimensionType(server);
        if (level.m_6042_() == hyperboxDimensionType) {
            for (ServerPlayer player : Lists.newArrayList((Iterable)level.m_6907_())) {
                TeleportHelper.ejectPlayerFromDeadWorld(player);
            }
        }
    }

    private void onHighPriorityWorldTick(TickEvent.LevelTickEvent event) {
        Level level = event.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (event.phase == TickEvent.Phase.END) {
                this.onPreServerWorldTick(serverLevel);
            } else {
                this.onPostServerWorldTick(serverLevel);
            }
        }
    }

    private void onPreServerWorldTick(ServerLevel level) {
        boolean shouldChunkBeForced;
        boolean isChunkForced;
        if (((Boolean)this.commonConfig.autoForceHyperboxChunks.get()).booleanValue() && HyperboxDimension.getDimensionType(level.m_7654_()) == level.m_6042_() && (isChunkForced = level.m_8902_().contains(HyperboxChunkGenerator.CHUNKID)) != (shouldChunkBeForced = Hyperbox.shouldHyperboxChunkBeForced(level))) {
            level.m_8602_(HyperboxChunkGenerator.CHUNKPOS.f_45578_, HyperboxChunkGenerator.CHUNKPOS.f_45579_, shouldChunkBeForced);
        }
    }

    private void onPostServerWorldTick(@Nonnull ServerLevel level) {
        MinecraftServer server = level.m_7654_();
        if (Hyperbox.shouldUnloadDimension(server, level)) {
            ResourceKey key = level.m_46472_();
            level.m_8643_(null, true, false);
            InfiniverseAPI.get().markDimensionForUnregistration(server, key);
        }
        DelayedTeleportData.tick(level);
    }

    public static boolean shouldUnloadDimension(MinecraftServer server, @Nonnull ServerLevel targetLevel) {
        DimensionType hyperboxDimensionType = HyperboxDimension.getDimensionType(server);
        if (hyperboxDimensionType != targetLevel.m_6042_()) {
            return false;
        }
        if ((targetLevel.m_46467_() + (long)targetLevel.hashCode()) % 20L != 0L) {
            return false;
        }
        HyperboxWorldData hyperboxData = HyperboxWorldData.getOrCreate(targetLevel);
        ResourceKey<Level> parentKey = hyperboxData.getParentWorld();
        BlockPos parentPos = hyperboxData.getParentPos();
        ServerLevel parentLevel = server.m_129880_(parentKey);
        if (parentLevel == null) {
            return true;
        }
        if (!parentLevel.m_7232_(parentPos.m_123341_() >> 4, parentPos.m_123343_() >> 4)) {
            return false;
        }
        BlockEntity te = parentLevel.m_7702_(parentPos);
        if (!(te instanceof HyperboxBlockEntity)) {
            return true;
        }
        HyperboxBlockEntity hyperbox = (HyperboxBlockEntity)te;
        ResourceKey key = targetLevel.m_46472_();
        return hyperbox.getLevelKey().map(childKey -> !childKey.equals((Object)key)).orElse(true);
    }

    private static boolean shouldHyperboxChunkBeForced(ServerLevel hyperboxLevel) {
        HyperboxWorldData data;
        ResourceKey<Level> parentKey;
        MinecraftServer server = hyperboxLevel.m_7654_();
        ServerLevel parentLevel = server.m_129880_(parentKey = (data = HyperboxWorldData.getOrCreate(hyperboxLevel)).getParentWorld());
        if (parentLevel == null) {
            return false;
        }
        BlockPos parentPos = data.getParentPos();
        return parentLevel.m_46805_(parentPos);
    }

    private static <T> DeferredRegister<T> makeRegister(IEventBus modBus, IForgeRegistry<T> registry) {
        DeferredRegister register = DeferredRegister.create(registry, (String)MODID);
        register.register(modBus);
        return register;
    }

    private static <T> DeferredRegister<T> makeVanillaRegister(IEventBus modBus, ResourceKey<Registry<T>> registryKey) {
        DeferredRegister register = DeferredRegister.create(registryKey, (String)MODID);
        register.register(modBus);
        return register;
    }

    static {
        CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, MODID), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        HYPERBOX_ID = new ResourceLocation(MODID, MODID);
        BIOME_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)HYPERBOX_ID);
        WORLD_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)HYPERBOX_ID);
        DIMENSION_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256862_, (ResourceLocation)HYPERBOX_ID);
        DIMENSION_TYPE_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)HYPERBOX_ID);
    }
}

