/*
 * Decompiled with CFR 0.152.
 */
package commoble.hyperbox.blocks;

import commoble.hyperbox.blocks.HyperboxBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class HyperboxBlockItem
extends BlockItem
implements DyeableLeatherItem {
    public static final int DEFAULT_COLOR = 4863306;
    public static final String BLOCKENTITY_KEY = "BlockEntityTag";
    public static final String DISPLAY_KEY = "display";
    public static final String COLOR_KEY = "color";

    public HyperboxBlockItem(Block block, Item.Properties builder) {
        super(block, builder);
    }

    public int m_41121_(ItemStack stack) {
        CompoundTag displayTag = stack.m_41737_(DISPLAY_KEY);
        if (displayTag != null && displayTag.m_128425_(COLOR_KEY, 99)) {
            return displayTag.m_128451_(COLOR_KEY);
        }
        CompoundTag blockEntityTag = stack.m_41737_(BLOCKENTITY_KEY);
        if (blockEntityTag != null && blockEntityTag.m_128425_(COLOR_KEY, 99)) {
            return blockEntityTag.m_128451_(COLOR_KEY);
        }
        return 4863306;
    }

    public boolean m_41113_(ItemStack stack) {
        CompoundTag displayTag = stack.m_41737_(DISPLAY_KEY);
        if (displayTag != null && displayTag.m_128425_(COLOR_KEY, 99)) {
            return true;
        }
        CompoundTag blockEntityTag = stack.m_41737_(BLOCKENTITY_KEY);
        return blockEntityTag != null && blockEntityTag.m_128425_(COLOR_KEY, 99);
    }

    public void m_41123_(ItemStack stack) {
        CompoundTag blockEntityTag;
        CompoundTag displayTag = stack.m_41737_(DISPLAY_KEY);
        if (displayTag != null && displayTag.m_128441_(COLOR_KEY)) {
            displayTag.m_128473_(COLOR_KEY);
        }
        if ((blockEntityTag = stack.m_41737_(BLOCKENTITY_KEY)) != null && blockEntityTag.m_128441_(COLOR_KEY)) {
            blockEntityTag.m_128473_(COLOR_KEY);
        }
    }

    public void m_41115_(ItemStack stack, int color) {
        stack.m_41698_(DISPLAY_KEY).m_128405_(COLOR_KEY, color);
        stack.m_41698_(BLOCKENTITY_KEY).m_128405_(COLOR_KEY, color);
    }

    protected boolean m_7274_(BlockPos pos, Level level, Player player, ItemStack stack, BlockState state) {
        BlockEntity blockEntity;
        boolean success = super.m_7274_(pos, level, player, stack, state);
        if (success && (blockEntity = level.m_7702_(pos)) instanceof HyperboxBlockEntity) {
            HyperboxBlockEntity hyperbox = (HyperboxBlockEntity)blockEntity;
            hyperbox.setColor(HyperboxBlockItem.getColorIfHyperbox(stack));
        }
        return success;
    }

    public static int getColorIfHyperbox(ItemStack stack) {
        int n;
        Item item = stack.m_41720_();
        if (item instanceof HyperboxBlockItem) {
            HyperboxBlockItem hyperboxItem = (HyperboxBlockItem)item;
            n = hyperboxItem.m_41121_(stack);
        } else {
            n = 4863306;
        }
        return n;
    }
}

