/*
 * Decompiled with CFR 0.152.
 */
package commoble.hyperbox.dimension;

import commoble.hyperbox.Hyperbox;
import commoble.hyperbox.dimension.HyperboxChunkGenerator;
import commoble.hyperbox.dimension.HyperboxWorldData;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;

public class HyperboxDimension {
    public static LevelStem createDimension(MinecraftServer server) {
        return new LevelStem(HyperboxDimension.getDimensionTypeHolder(server), (ChunkGenerator)new HyperboxChunkGenerator(server));
    }

    public static Holder<DimensionType> getDimensionTypeHolder(MinecraftServer server) {
        return server.m_206579_().m_175515_(Registries.f_256787_).m_246971_(Hyperbox.DIMENSION_TYPE_KEY);
    }

    public static DimensionType getDimensionType(MinecraftServer server) {
        return (DimensionType)HyperboxDimension.getDimensionTypeHolder(server).m_203334_();
    }

    public static IterationResult getHyperboxIterationDepth(MinecraftServer server, ServerLevel targetWorld, ServerLevel hyperboxWorld) {
        if (hyperboxWorld == null || targetWorld == null) {
            return IterationResult.FAILURE;
        }
        if (hyperboxWorld == targetWorld) {
            return IterationResult.NONE;
        }
        HashSet<ResourceKey<Level>> foundKeys = new HashSet<ResourceKey<Level>>();
        ServerLevel nextWorld = hyperboxWorld;
        ResourceKey<Level> nextKey = nextWorld.m_46472_();
        int iterations = 0;
        DimensionType hyperboxDimensionType = HyperboxDimension.getDimensionType(server);
        while (nextWorld.m_6042_() == hyperboxDimensionType && !foundKeys.contains(nextKey)) {
            foundKeys.add(nextKey);
            HyperboxWorldData data = HyperboxWorldData.getOrCreate(nextWorld);
            ResourceKey<Level> parentKey = data.getParentWorld();
            ServerLevel parentWorld = server.m_129880_(parentKey);
            ++iterations;
            if (parentWorld == targetWorld) {
                return new IterationResult(iterations, data.getParentPos());
            }
            if (parentWorld == null) {
                return IterationResult.FAILURE;
            }
            nextKey = parentKey;
            nextWorld = parentWorld;
        }
        return IterationResult.FAILURE;
    }

    public record IterationResult(int iterations, @Nullable BlockPos parentPos) {
        public static final IterationResult FAILURE = new IterationResult(-1, null);
        public static final IterationResult NONE = new IterationResult(0, null);
    }
}

