/*
 * Decompiled with CFR 0.152.
 */
package commoble.hyperbox.network;

import commoble.hyperbox.blocks.HyperboxMenu;
import commoble.hyperbox.network.PacketSerializer;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public record C2SSaveHyperboxPacket(String dimension, String name, boolean enterImmediate) implements Consumer<NetworkEvent.Context>
{
    public static final PacketSerializer<C2SSaveHyperboxPacket> SERIALIZER = new PacketSerializer<C2SSaveHyperboxPacket>(C2SSaveHyperboxPacket.class, (packet, buffer) -> {
        buffer.m_130070_(packet.dimension);
        buffer.m_130070_(packet.name);
        buffer.writeBoolean(packet.enterImmediate);
    }, buffer -> new C2SSaveHyperboxPacket(buffer.m_130277_(), buffer.m_130277_(), buffer.readBoolean()));

    @Override
    public void accept(NetworkEvent.Context context) {
        AbstractContainerMenu abstractContainerMenu;
        ServerPlayer player = context.getSender();
        if (player == null || !((abstractContainerMenu = player.f_36096_) instanceof HyperboxMenu)) {
            return;
        }
        HyperboxMenu menu = (HyperboxMenu)abstractContainerMenu;
        if (this.dimension == null || this.dimension.isBlank()) {
            player.m_5661_((Component)Component.m_237110_((String)"menu.hyperbox.message.no_id", (Object[])new Object[]{this.dimension}), false);
            player.m_6915_();
            return;
        }
        if (!ResourceLocation.m_135841_((String)this.dimension)) {
            player.m_5661_((Component)Component.m_237110_((String)"menu.hyperbox.message.invalid_id", (Object[])new Object[]{this.dimension}), false);
            player.m_6915_();
            return;
        }
        ResourceLocation dimensionId = new ResourceLocation("hyperbox", this.dimension);
        ResourceKey levelKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimensionId);
        ServerLevel level = player.m_284548_();
        if (level.m_7654_().m_129880_(levelKey) != null) {
            player.m_5661_((Component)Component.m_237110_((String)"menu.hyperbox.message.existing_id", (Object[])new Object[]{dimensionId}), false);
            player.m_6915_();
            return;
        }
        menu.hyperbox().ifPresentOrElse(hyperbox -> {
            hyperbox.setLevelKey((ResourceKey<Level>)levelKey);
            if (this.name != null && !this.name.isEmpty()) {
                hyperbox.setName((Component)Component.m_237113_((String)this.name));
            }
            if (this.enterImmediate) {
                hyperbox.teleportPlayerOrOpenMenu(player, Direction.DOWN);
            } else {
                player.m_6915_();
            }
        }, () -> ((ServerPlayer)player).m_6915_());
    }
}

