/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.item.IFCustomItem;
import com.buuz135.industrial.item.infinity.IInfinityDrillScreenAddons;
import com.buuz135.industrial.item.infinity.InfinityCapabilityProvider;
import com.buuz135.industrial.item.infinity.InfinityEnergyStorage;
import com.buuz135.industrial.item.infinity.InfinityTier;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.proxy.CommonProxy;
import com.buuz135.industrial.proxy.network.BackpackOpenedMessage;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.ISpecialCreativeTabItem;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.capability.FluidHandlerScreenProviderItemStack;
import com.hrznstudio.titanium.client.screen.addon.ArrowButtonScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.client.screen.addon.TankScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.component.button.ArrowButtonComponent;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.container.BasicAddonContainer;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.itemstack.ItemStackHarnessRegistry;
import com.hrznstudio.titanium.network.IButtonHandler;
import com.hrznstudio.titanium.network.locator.LocatorFactory;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import com.hrznstudio.titanium.network.locator.PlayerInventoryFinder;
import com.hrznstudio.titanium.network.locator.instance.HeldStackLocatorInstance;
import com.hrznstudio.titanium.tab.TitaniumTab;
import com.hrznstudio.titanium.util.FacingUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Pair;

public class ItemInfinity
extends IFCustomItem
implements MenuProvider,
IButtonHandler,
IInfinityDrillScreenAddons,
ISpecialCreativeTabItem {
    private final int powerConsumption;
    private final int biofuelConsumption;
    private final boolean usesDepth;
    private boolean usesArea;

    public ItemInfinity(String name, TitaniumTab group, Item.Properties builder, int powerConsumption, int biofuelConsumption, boolean usesDepth) {
        super(name, group, builder);
        this.powerConsumption = powerConsumption;
        this.biofuelConsumption = biofuelConsumption;
        this.usesDepth = usesDepth;
        this.usesArea = true;
    }

    public static long getPowerFromStack(ItemStack stack) {
        long power = 0L;
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Energy")) {
            power = stack.m_41783_().m_128454_("Energy");
        }
        return power;
    }

    public void disableArea() {
        this.usesArea = false;
    }

    public String getFormattedArea(ItemStack stack, InfinityTier tier, int radius, boolean usesDepth) {
        int diameter = radius * 2 + 1;
        return diameter + "x" + diameter + "x" + (tier == InfinityTier.ARTIFACT || usesDepth ? diameter : 1);
    }

    public static InfinityTier getSelectedTier(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("Selected") ? InfinityTier.valueOf(stack.m_41783_().m_128461_("Selected")) : (InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinity.getPowerFromStack(stack)).getLeft());
    }

    public static boolean canCharge(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("CanCharge")) {
            return stack.m_41783_().m_128471_("CanCharge");
        }
        return true;
    }

    public void m_7836_(ItemStack stack, Level worldIn, Player playerIn) {
        super.m_7836_(stack, worldIn, playerIn);
        if (!stack.m_41782_()) {
            this.addNbt(stack, 0L, 0, false);
        }
    }

    public void addNbt(ItemStack stack, long power, int fuel, boolean special) {
        CompoundTag tagCompound = new CompoundTag();
        tagCompound.m_128356_("Energy", power);
        CompoundTag fluid = new CompoundTag();
        fluid.m_128359_("FluidName", "biofuel");
        fluid.m_128405_("Amount", fuel);
        tagCompound.m_128365_("Fluid", (Tag)fluid);
        tagCompound.m_128379_("Special", special);
        tagCompound.m_128359_("Selected", ((InfinityTier)((Object)InfinityTier.getTierBraquet(power).getLeft())).name());
        tagCompound.m_128379_("CanCharge", true);
        stack.m_41751_(tagCompound);
    }

    public void addToTab(BuildCreativeModeTabContentsEvent event) {
        for (InfinityTier value : InfinityTier.values()) {
            event.m_246342_(this.createStack(value.getPowerNeeded(), 0, false));
        }
        event.m_246342_(this.createStack(InfinityTier.ARTIFACT.getPowerNeeded(), 1000000, true));
    }

    public ItemStack createStack(long power, int fuel, boolean special) {
        ItemStack stack = new ItemStack((ItemLike)this);
        this.addNbt(stack, power, fuel, special);
        return stack;
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public int m_6473_() {
        return 50;
    }

    public UseAnim m_6164_(ItemStack p_77661_1_) {
        return UseAnim.BOW;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged && !oldStack.equals(newStack);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return this.enoughFuel(stack) ? 10.0f : 0.0f;
    }

    public boolean m_142522_(ItemStack p_150899_) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        if (!((Boolean)DistExecutor.safeRunForDist(() -> Screen::m_96638_, () -> Boolean.FALSE::booleanValue)).booleanValue()) {
            int fuel = this.getFuelFromStack(stack);
            return (int)Math.round((double)fuel * 13.0 / 1000000.0);
        }
        long power = ItemInfinity.getPowerFromStack(stack);
        return (int)Math.round((double)power * 13.0 / (double)((InfinityTier)((Object)InfinityTier.getTierBraquet(power).getRight())).getPowerNeeded());
    }

    public int m_142159_(ItemStack p_150901_) {
        return (Boolean)DistExecutor.safeRunForDist(() -> Screen::m_96638_, () -> Boolean.FALSE::booleanValue) == false ? 13304063 : 53503;
    }

    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == null;
    }

    public int getFuelFromStack(ItemStack stack) {
        int fuelAmount = 0;
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Fluid") && stack.m_41783_().m_128469_("Fluid").m_128441_("Amount")) {
            fuelAmount = stack.m_41783_().m_128469_("Fluid").m_128451_("Amount");
        }
        return fuelAmount;
    }

    public boolean isSpecial(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("Special") && stack.m_41783_().m_128471_("Special");
    }

    public boolean isSpecialEnabled(ItemStack stack) {
        return this.isSpecial(stack) && stack.m_41783_().m_128441_("SpecialEnabled") && stack.m_41783_().m_128471_("SpecialEnabled");
    }

    public void setSpecialEnabled(ItemStack stack, boolean special) {
        if (this.isSpecial(stack)) {
            stack.m_41783_().m_128379_("SpecialEnabled", special);
        }
    }

    public boolean enoughFuel(ItemStack stack) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)stack);
        return (double)this.getFuelFromStack(stack) >= (double)this.biofuelConsumption * (1.0 / (double)(i + 1)) || (double)ItemInfinity.getPowerFromStack(stack) >= (double)this.powerConsumption * (1.0 / (double)(i + 1));
    }

    public void consumeFuel(ItemStack stack) {
        double i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)stack);
        if ((double)this.getFuelFromStack(stack) >= (double)this.biofuelConsumption * (1.0 / (i + 1.0))) {
            stack.m_41783_().m_128469_("Fluid").m_128405_("Amount", (int)Math.max(0.0, (double)stack.m_41783_().m_128469_("Fluid").m_128451_("Amount") - (double)this.biofuelConsumption * (1.0 / (i + 1.0))));
        } else {
            stack.m_41783_().m_128356_("Energy", (long)((double)stack.m_41783_().m_128454_("Energy") - (double)this.powerConsumption * (1.0 / (i + 1.0))));
        }
    }

    public void setCanCharge(ItemStack stack, boolean canCharge) {
        stack.m_41783_().m_128379_("CanCharge", canCharge);
    }

    public void setSelectedDrillTier(ItemStack stack, InfinityTier tier) {
        stack.m_41783_().m_128359_("Selected", tier.name());
    }

    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        long power = ItemInfinity.getPowerFromStack(stack);
        Pair<InfinityTier, InfinityTier> braquet = InfinityTier.getTierBraquet(power);
        InfinityTier current = ItemInfinity.getSelectedTier(stack);
        if (this.usesArea) {
            tooltip.add((Component)Component.m_237115_((String)"text.industrialforegoing.display.current_area").m_130946_(" ").m_130946_(this.getFormattedArea(stack, current, current.getRadius(), this.usesDepth)).m_130940_(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.m_237115_((String)"text.industrialforegoing.display.tier").m_130946_(" " + ((InfinityTier)((Object)braquet.getLeft())).getColor() + ((InfinityTier)((Object)braquet.getLeft())).getLocalizedName()).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"text.industrialforegoing.display.power").m_130946_(" ").m_130946_(ChatFormatting.RED + NumberFormat.getNumberInstance(Locale.ROOT).format(power) + ChatFormatting.GREEN).m_130946_("/").m_130946_(NumberFormat.getNumberInstance(Locale.ROOT).format(((InfinityTier)((Object)braquet.getRight())).getPowerNeeded())).m_130946_("RF ").m_7220_((Component)Component.m_237115_((String)"text.industrialforegoing.display.next_tier")).m_130940_(ChatFormatting.GRAY));
        int fuelAmount = this.getFuelFromStack(stack);
        tooltip.add((Component)Component.m_237115_((String)"text.industrialforegoing.display.fluid").m_130946_(" ").m_130946_(ChatFormatting.LIGHT_PURPLE + NumberFormat.getNumberInstance(Locale.ROOT).format(fuelAmount) + ChatFormatting.GRAY).m_130946_("/").m_130946_(NumberFormat.getNumberInstance(Locale.ROOT).format(1000000L)).m_130946_(" mb of Biofuel").m_130940_(ChatFormatting.GRAY));
        if (this.usesArea) {
            tooltip.add((Component)Component.m_237115_((String)"text.industrialforegoing.display.max_area").m_130946_(" ").m_130946_(this.getFormattedArea(stack, (InfinityTier)((Object)braquet.getLeft()), ((InfinityTier)((Object)braquet.getLeft())).getRadius(), this.usesDepth)).m_130940_(ChatFormatting.GRAY));
        }
        if (ItemInfinity.canCharge(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"text.industrialforegoing.display.charging").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)"text.industrialforegoing.display.enabled").m_130940_(ChatFormatting.GREEN)));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"text.industrialforegoing.display.charging").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)"text.industrialforegoing.display.disabled").m_130940_(ChatFormatting.RED)));
        }
        if (this.isSpecial(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"text.industrialforegoing.display.special").m_130940_(ChatFormatting.GOLD));
        }
    }

    public Pair<BlockPos, BlockPos> getArea(BlockPos pos, Direction facing, InfinityTier currentTier, boolean withDepth) {
        int radius = currentTier.getRadius();
        BlockPos bottomLeft = pos.m_5484_(facing.m_122434_() == Direction.Axis.Y ? Direction.SOUTH : Direction.DOWN, radius).m_5484_(facing.m_122434_() == Direction.Axis.Y ? Direction.WEST : facing.m_122428_(), radius);
        BlockPos topRight = pos.m_5484_(facing.m_122434_() == Direction.Axis.Y ? Direction.NORTH : Direction.UP, radius).m_5484_(facing.m_122434_() == Direction.Axis.Y ? Direction.EAST : facing.m_122427_(), radius);
        if (facing.m_122434_() != Direction.Axis.Y && radius > 0) {
            bottomLeft = bottomLeft.m_5484_(Direction.UP, radius - 1);
            topRight = topRight.m_5484_(Direction.UP, radius - 1);
        }
        if (currentTier == InfinityTier.ARTIFACT && withDepth) {
            topRight = topRight.m_5484_(facing.m_122424_(), radius);
        }
        return Pair.of((Object)bottomLeft, (Object)topRight);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ListMultimap multimap = MultimapBuilder.hashKeys().arrayListValues().build();
        if (slot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 3.0, AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", -2.5, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)this.m_5524_()).m_130940_(ChatFormatting.DARK_GRAY);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int menu, Inventory p_createMenu_2_, Player playerEntity) {
        return new BasicAddonContainer((Object)ItemStackHarnessRegistry.createItemStackHarness((ItemStack)playerEntity.m_21205_()), (LocatorInstance)new HeldStackLocatorInstance(true), new ContainerLevelAccess(){

            public <T> Optional<T> m_6721_(BiFunction<Level, BlockPos, T> p_221484_1_) {
                return Optional.empty();
            }
        }, playerEntity.f_36093_, menu);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player player, InteractionHand handIn) {
        if (player.m_6047_()) {
            if (player instanceof ServerPlayer) {
                IndustrialForegoing.NETWORK.get().sendTo((Object)new BackpackOpenedMessage(player.f_36093_.f_35977_, PlayerInventoryFinder.MAIN), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, buffer -> LocatorFactory.writePacketBuffer((FriendlyByteBuf)buffer, (LocatorInstance)new HeldStackLocatorInstance(handIn == InteractionHand.MAIN_HAND)));
            }
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(handIn));
        }
        if (CommonProxy.CONTRIBUTORS.contains(player.m_20148_().toString())) {
            player.m_21120_(handIn).m_41784_().m_128379_("Special", true);
        }
        return super.m_7203_(worldIn, player, handIn);
    }

    public boolean m_41468_() {
        return true;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new InfinityCapabilityProvider(stack, this.getTankConstructor(stack), this.getEnergyConstructor(stack));
    }

    public void handleButtonMessage(int id, Player playerEntity, CompoundTag compound) {
        ItemStack stack = playerEntity.m_21120_(InteractionHand.MAIN_HAND);
        if (!(stack.m_41720_() instanceof ItemInfinity)) {
            stack = playerEntity.m_21120_(InteractionHand.OFF_HAND);
        }
        if (stack.m_41720_() instanceof ItemInfinity) {
            if (id == 1) {
                InfinityTier prev = ItemInfinity.getSelectedTier(stack).getPrev((InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinity.getPowerFromStack(stack)).getLeft()));
                this.setSelectedDrillTier(stack, prev);
            }
            if (id == 2) {
                InfinityTier next = ItemInfinity.getSelectedTier(stack).getNext((InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinity.getPowerFromStack(stack)).getLeft()));
                this.setSelectedDrillTier(stack, next);
            }
            if (id == 3) {
                this.setCanCharge(stack, !ItemInfinity.canCharge(stack));
            }
            if (id == -10) {
                this.setSpecialEnabled(stack, !this.isSpecialEnabled(stack));
            }
        }
    }

    public void registerRecipe(Consumer<FinishedRecipe> consumer) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IFactory<? extends IScreenAddon>> getScreenAddons(final Supplier<ItemStack> stack) {
        ArrayList<IFactory<? extends IScreenAddon>> factory = new ArrayList<IFactory<? extends IScreenAddon>>();
        factory.add(() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(154, 20, 14, 14, FacingUtil.Sideness.RIGHT).setId(2)));
        factory.add(() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(54, 20, 14, 14, FacingUtil.Sideness.LEFT).setId(1)));
        factory.add(() -> new TextScreenAddon("", 72, 24, false){

            public String getText() {
                InfinityTier current = ItemInfinity.getSelectedTier((ItemStack)stack.get());
                return ChatFormatting.DARK_GRAY + "Area: " + ItemInfinity.this.getFormattedArea((ItemStack)stack.get(), current, current.getRadius(), ItemInfinity.this.usesDepth);
            }
        });
        factory.add(() -> new StateButtonAddon(new ButtonComponent(54, 36, 14, 14).setId(3), new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[0]), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[0])}){

            public int getState() {
                return ItemInfinity.canCharge((ItemStack)stack.get()) ? 0 : 1;
            }
        });
        factory.add(() -> new TextScreenAddon("", 72, 40, false){

            public String getText() {
                if (ItemInfinity.canCharge((ItemStack)stack.get())) {
                    return ChatFormatting.DARK_GRAY + Component.m_237115_((String)"text.industrialforegoing.display.charging").getString() + ChatFormatting.GREEN + Component.m_237115_((String)"text.industrialforegoing.display.enabled").getString();
                }
                return ChatFormatting.DARK_GRAY + Component.m_237115_((String)"text.industrialforegoing.display.charging").getString() + ChatFormatting.RED + Component.m_237115_((String)"text.industrialforegoing.display.disabled").getString();
            }
        });
        if (this.isSpecial(stack.get())) {
            factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new StateButtonAddon(new ButtonComponent(12, 80, 14, 15).setId(-10), new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[0]), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[0])}){

                public int getState() {
                    return ItemInfinity.this.isSpecialEnabled((ItemStack)stack.get()) ? 0 : 1;
                }
            }));
            factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new TextScreenAddon(ChatFormatting.GOLD + Component.m_237115_((String)"text.industrialforegoing.display.special").getString(), 30, 84, false)));
        }
        return factory;
    }

    public IFactory<? extends FluidHandlerScreenProviderItemStack> getTankConstructor(ItemStack stack) {
        return () -> new FluidHandlerScreenProviderItemStack(stack, 1000000){

            public boolean canFillFluidType(FluidStack fluid) {
                return fluid != null && fluid.getFluid() != null && fluid.getFluid().equals(ModuleCore.BIOFUEL.getSourceFluid().get());
            }

            public boolean canDrainFluidType(FluidStack fluid) {
                return false;
            }

            @Nonnull
            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new TankScreenAddon(30, 20, (IFluidTank)this, FluidTankComponent.Type.NORMAL));
            }
        };
    }

    public IFactory<InfinityEnergyStorage> getEnergyConstructor(final ItemStack stack) {
        return () -> new InfinityEnergyStorage(InfinityTier.ARTIFACT.getPowerNeeded(), 10, 20){

            @Override
            public long getLongEnergyStored() {
                if (stack.m_41782_()) {
                    return Math.min(stack.m_41783_().m_128454_("Energy"), InfinityTier.ARTIFACT.getPowerNeeded());
                }
                return 0L;
            }

            @Override
            public void setEnergyStored(long energy) {
                if (!stack.m_41782_()) {
                    stack.m_41751_(new CompoundTag());
                }
                stack.m_41783_().m_128356_("Energy", Math.min(energy, InfinityTier.ARTIFACT.getPowerNeeded()));
            }

            @Override
            public boolean canReceive() {
                return ItemInfinity.canCharge(stack);
            }
        };
    }
}

