/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrialforegoingsouls.block;

import com.buuz135.industrialforegoingsouls.IndustrialForegoingSouls;
import com.buuz135.industrialforegoingsouls.block.tile.SoulPipeBlockEntity;
import com.buuz135.industrialforegoingsouls.config.IFSoulsClient;
import com.google.common.collect.ImmutableMap;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block_network.INetworkDirectionalConnection;
import com.hrznstudio.titanium.block_network.NetworkManager;
import com.hrznstudio.titanium.block_network.element.NetworkElement;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.mutable.MutableObject;

public class SoulPipeBlock
extends BasicTileBlock<SoulPipeBlockEntity>
implements INetworkDirectionalConnection,
SimpleWaterloggedBlock {
    public static final Map<Direction, EnumProperty<PipeState>> DIRECTIONS = new HashMap<Direction, EnumProperty<PipeState>>();
    public static final Map<Direction, VoxelShape> DIR_SHAPES = ImmutableMap.builder().put((Object)Direction.UP, (Object)Block.m_49796_((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0)).put((Object)Direction.DOWN, (Object)Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0)).put((Object)Direction.NORTH, (Object)Block.m_49796_((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)6.0)).put((Object)Direction.SOUTH, (Object)Block.m_49796_((double)5.0, (double)5.0, (double)10.0, (double)11.0, (double)11.0, (double)16.0)).put((Object)Direction.EAST, (Object)Block.m_49796_((double)10.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0)).put((Object)Direction.WEST, (Object)Block.m_49796_((double)0.0, (double)5.0, (double)5.0, (double)6.0, (double)11.0, (double)11.0)).build();
    private static final Map<BlockState, VoxelShape> SHAPE_CACHE = new HashMap<BlockState, VoxelShape>();
    private static final Map<BlockState, VoxelShape> COLL_SHAPE_CACHE = new HashMap<BlockState, VoxelShape>();
    private static final VoxelShape CENTER_SHAPE = Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);

    public SoulPipeBlock() {
        super("soul_network_pipe", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_280606_(), SoulPipeBlockEntity.class);
        this.setItemGroup(IndustrialForegoingSouls.TAB);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntityType.BlockEntitySupplier<?> getTileEntityFactory() {
        return (pos, state) -> new SoulPipeBlockEntity(this, (BlockEntityType<?>)((BlockEntityType)((RegistryObject)IndustrialForegoingSouls.SOUL_PIPE_BLOCK.getRight()).get()), pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_((Property[])DIRECTIONS.values().toArray(Property[]::new));
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    private BlockState createState(Level world, BlockPos pos, BlockState curr) {
        BlockState state = this.m_49966_();
        FluidState fluid = world.m_6425_(pos);
        if (fluid.m_205070_(FluidTags.f_13131_) && fluid.m_76186_() == 8) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
        }
        for (Direction dir : Direction.values()) {
            EnumProperty<PipeState> prop = DIRECTIONS.get(dir);
            PipeState type = this.getConnectionType(world, pos, dir, state);
            state = (BlockState)state.m_61124_(prop, (Comparable)((Object)type));
        }
        return state;
    }

    protected PipeState getConnectionType(Level world, BlockPos pos, Direction direction, BlockState state) {
        INetworkDirectionalConnection networkDirectionalConnection;
        BlockState relativeState = world.m_8055_(pos.m_121945_(direction));
        if (relativeState.m_60734_() instanceof SoulPipeBlock) {
            return PipeState.PIPE;
        }
        Block block = relativeState.m_60734_();
        if (block instanceof INetworkDirectionalConnection && (networkDirectionalConnection = (INetworkDirectionalConnection)block).canConnect(relativeState, direction.m_122424_())) {
            return PipeState.BLOCK;
        }
        return PipeState.NO;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.createState(context.m_43725_(), context.m_8083_(), this.m_49966_());
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        NetworkElement pipe;
        BlockState newState = this.createState(worldIn, pos, state);
        if (newState != state) {
            worldIn.m_46597_(pos, newState);
        }
        if (!worldIn.f_46443_ && (pipe = NetworkManager.get((Level)worldIn).getElement(pos)) != null && pipe.getNetwork() != null) {
            pipe.getNetwork().scanGraph(worldIn, pos);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.cacheAndGetShape(state, worldIn, pos, s -> s.m_60651_(worldIn, pos, context), SHAPE_CACHE, null);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.cacheAndGetShape(state, worldIn, pos, s -> s.m_60742_(worldIn, pos, context), COLL_SHAPE_CACHE, s -> {
            MutableObject newShape = new MutableObject((Object)Shapes.m_83040_());
            s.m_83286_((x1, y1, z1, x2, y2, z2) -> newShape.setValue((Object)Shapes.m_83113_((VoxelShape)Shapes.m_166049_((double)x1, (double)y1, (double)z1, (double)x2, (double)(y2 + 0.1875), (double)z2), (VoxelShape)((VoxelShape)newShape.getValue()), (BooleanOp)BooleanOp.f_82695_)));
            return ((VoxelShape)newShape.getValue()).m_83296_();
        });
    }

    private VoxelShape cacheAndGetShape(BlockState state, BlockGetter worldIn, BlockPos pos, Function<BlockState, VoxelShape> coverShapeSelector, Map<BlockState, VoxelShape> cache, Function<VoxelShape, VoxelShape> shapeModifier) {
        VoxelShape shape = cache.get(state);
        if (shape == null) {
            shape = CENTER_SHAPE;
            for (Map.Entry<Direction, EnumProperty<PipeState>> entry : DIRECTIONS.entrySet()) {
                if (state.m_61143_((Property)entry.getValue()) == PipeState.NO) continue;
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)DIR_SHAPES.get(entry.getKey()));
            }
            if (shapeModifier != null) {
                shape = shapeModifier.apply(shape);
            }
            cache.put(state, shape);
        }
        return shape;
    }

    public boolean canConnect(BlockState state, Direction direction) {
        return true;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        for (Direction direction : Direction.values()) {
            boolean opositteConnected;
            boolean connected = state.m_61143_((Property)DIRECTIONS.get(direction)) != PipeState.NO;
            boolean bl = opositteConnected = state.m_61143_((Property)DIRECTIONS.get(direction.m_122424_())) != PipeState.NO;
            if (!(random.m_188500_() <= IFSoulsClient.SOUL_PIPES_PARTICLES) || !connected || !opositteConnected) continue;
            Vec3i vector = direction.m_122436_();
            double velocity = 12.0;
            double border = 0.34;
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            if (direction.m_122434_() == Direction.Axis.X) {
                y += 0.5 + (random.m_188499_() ? -border : border);
                x += 0.5;
                z += 0.5 + (random.m_188499_() ? -border : border);
            } else if (direction.m_122434_() == Direction.Axis.Z) {
                y += 0.5 + (random.m_188499_() ? -border : border);
                x += 0.5 + (random.m_188499_() ? -border : border);
                z += 0.5;
            } else {
                y += 0.5;
                x += 0.5 + (random.m_188499_() ? -border : border);
                z += 0.5 + (random.m_188499_() ? -border : border);
            }
            level.m_7106_((ParticleOptions)ParticleTypes.f_235898_, (double)pos.m_123341_() + x, (double)pos.m_123342_() + y, (double)pos.m_123343_() + z, (double)vector.m_123341_() / velocity, (double)vector.m_123342_() / velocity, (double)vector.m_123343_() / velocity);
        }
    }

    public FluidState m_5888_(BlockState p_56969_) {
        return (Boolean)p_56969_.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_56969_);
    }

    static {
        for (Direction value : Direction.values()) {
            DIRECTIONS.put(value, (EnumProperty<PipeState>)EnumProperty.m_61587_((String)value.m_122433_().toLowerCase(Locale.ROOT), PipeState.class));
        }
    }

    public static enum PipeState implements StringRepresentable
    {
        NO,
        PIPE,
        BLOCK;


        public String m_7912_() {
            return this.name().toLowerCase();
        }
    }
}

