/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.capabilities.spell;

import io.redspace.ironsspellbooks.api.item.weapons.MagicSwordItem;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.util.MinecraftInstanceHelper;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SpellData
implements Comparable<SpellData> {
    public static final String ISB_SPELL = "ISB_spell";
    public static final String LEGACY_SPELL_TYPE = "type";
    public static final String SPELL_ID = "id";
    public static final String SPELL_LEVEL = "level";
    public static final SpellData EMPTY = new SpellData(SpellRegistry.none(), 0);
    private MutableComponent displayName;
    private final AbstractSpell spell;
    private final int spellLevel;

    private SpellData() throws Exception {
        throw new Exception("Cannot create empty spell data.");
    }

    public SpellData(AbstractSpell spell, int level) {
        this.spell = Objects.requireNonNull(spell);
        this.spellLevel = level;
    }

    public static SpellData getSpellData(ItemStack stack) {
        CompoundTag tag = stack.m_41737_(ISB_SPELL);
        if (tag != null) {
            return new SpellData(SpellRegistry.getSpell(new ResourceLocation(tag.m_128461_(SPELL_ID))), tag.m_128451_(SPELL_LEVEL));
        }
        Item item = stack.m_41720_();
        if (item instanceof MagicSwordItem) {
            MagicSwordItem magicSwordItem = (MagicSwordItem)item;
            AbstractSpell spell = magicSwordItem.getImbuedSpell();
            SpellData.setSpellData(stack, spell, magicSwordItem.getImbuedLevel());
            return new SpellData(spell, magicSwordItem.getImbuedLevel());
        }
        return EMPTY;
    }

    public static boolean hasSpellData(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41737_(ISB_SPELL);
        return tag != null;
    }

    public static void setSpellData(ItemStack stack, String spellId, int spellLevel) {
        CompoundTag spellTag = new CompoundTag();
        spellTag.m_128359_(SPELL_ID, spellId);
        spellTag.m_128405_(SPELL_LEVEL, spellLevel);
        stack.m_41700_(ISB_SPELL, (Tag)spellTag);
    }

    public static void setSpellData(ItemStack stack, SpellData spellData) {
        SpellData.setSpellData(stack, spellData.getSpell().getSpellId(), spellData.getLevel());
    }

    public static void setSpellData(ItemStack stack, AbstractSpell spell, int spellLevel) {
        SpellData.setSpellData(stack, spell.getSpellId(), spellLevel);
    }

    public AbstractSpell getSpell() {
        if (this.spell == null) {
            return SpellRegistry.none();
        }
        return this.spell;
    }

    public int getLevel() {
        return this.spellLevel;
    }

    public SpellRarity getRarity() {
        return this.getSpell().getRarity(this.getLevel());
    }

    public Component getDisplayName() {
        if (this.displayName == null) {
            this.displayName = this.getSpell().getDisplayName(MinecraftInstanceHelper.instance.player()).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)((Item)ItemRegistry.SCROLL.get()).m_5524_()));
        }
        return this.displayName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SpellData) {
            SpellData other = (SpellData)obj;
            return this.spell.equals(other.spell) && this.spellLevel == other.spellLevel;
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.spell.hashCode() + this.spellLevel;
    }

    @Override
    public int compareTo(SpellData other) {
        int i = this.spell.getSpellId().compareTo(other.spell.getSpellId());
        if (i == 0) {
            i = Integer.compare(this.spellLevel, other.spellLevel);
        }
        return i;
    }
}

