/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells.magic_arrow;

import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import io.redspace.ironsspellbooks.registries.EntityRegistry;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class MagicArrowProjectile
extends AbstractMagicProjectile {
    private final List<Entity> victims = new ArrayList<Entity>();
    private int penetration;
    BlockPos lastHitBlock;

    @Override
    public void trailParticles() {
        Vec3 vec3 = this.m_20182_().m_82546_(this.m_20184_());
        this.f_19853_.m_7106_(ParticleHelper.UNSTABLE_ENDER, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.0, 0.0, 0.0);
    }

    @Override
    public void impactParticles(double x, double y, double z) {
        MagicManager.spawnParticles(this.f_19853_, ParticleHelper.UNSTABLE_ENDER, x, y, z, 15, 0.1, 0.1, 0.1, 0.5, false);
    }

    @Override
    public float getSpeed() {
        return 2.7f;
    }

    @Override
    public Optional<SoundEvent> getImpactSound() {
        return Optional.empty();
    }

    public MagicArrowProjectile(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public MagicArrowProjectile(Level levelIn, LivingEntity shooter) {
        this((EntityType<? extends Projectile>)((EntityType)EntityRegistry.MAGIC_ARROW_PROJECTILE.get()), levelIn);
        this.m_5602_((Entity)shooter);
    }

    protected void m_8060_(BlockHitResult pResult) {
    }

    @Override
    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.m_82443_();
        if (!this.victims.contains(entity)) {
            DamageSources.applyDamage(entity, this.damage, ((AbstractSpell)SpellRegistry.MAGIC_ARROW_SPELL.get()).getDamageSource((Entity)this, this.m_19749_()), ((AbstractSpell)SpellRegistry.MAGIC_ARROW_SPELL.get()).getSchoolType());
            this.victims.add(entity);
        }
    }

    @Override
    protected void m_6532_(HitResult result) {
        if (!this.f_19853_.f_46443_) {
            BlockPos blockPos = BlockPos.m_274446_((Position)result.m_82450_());
            if (result.m_6662_() == HitResult.Type.BLOCK && !blockPos.equals((Object)this.lastHitBlock)) {
                ++this.penetration;
                this.lastHitBlock = blockPos;
            } else if (result.m_6662_() == HitResult.Type.ENTITY) {
                ++this.penetration;
                this.f_19853_.m_5594_(null, BlockPos.m_274446_((Position)this.m_20182_()), (SoundEvent)SoundRegistry.FORCE_IMPACT.get(), SoundSource.NEUTRAL, 2.0f, 0.65f);
            }
        }
        super.m_6532_(result);
    }

    @Override
    protected boolean shouldPierceShields() {
        return true;
    }
}

