/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.gui.arcane_anvil;

import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.UpgradeData;
import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.capabilities.spellbook.SpellBookData;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.item.SpellBook;
import io.redspace.ironsspellbooks.item.UniqueItem;
import io.redspace.ironsspellbooks.item.UpgradeOrbItem;
import io.redspace.ironsspellbooks.registries.BlockRegistry;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.registries.MenuRegistry;
import io.redspace.ironsspellbooks.util.UpgradeUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ArcaneAnvilMenu
extends ItemCombinerMenu {
    public ArcaneAnvilMenu(int pContainerId, Inventory inventory, ContainerLevelAccess containerLevelAccess) {
        super((MenuType)MenuRegistry.ARCANE_ANVIL_MENU.get(), pContainerId, inventory, containerLevelAccess);
    }

    public ArcaneAnvilMenu(int pContainerId, Inventory inventory, FriendlyByteBuf extraData) {
        this(pContainerId, inventory, ContainerLevelAccess.f_39287_);
    }

    protected boolean m_6560_(Player pPlayer, boolean pHasStack) {
        return true;
    }

    protected void m_142365_(Player p_150601_, ItemStack p_150602_) {
        this.f_39769_.m_8020_(0).m_41774_(1);
        this.f_39769_.m_8020_(1).m_41774_(1);
        this.f_39770_.m_39292_((level, pos) -> {
            level.m_5594_(null, pos, SoundEvents.f_11671_, SoundSource.BLOCKS, 0.8f, 1.1f);
            level.m_5594_(null, pos, SoundEvents.f_144242_, SoundSource.BLOCKS, 1.0f, 1.0f);
        });
    }

    protected boolean m_8039_(BlockState pState) {
        return pState.m_60713_((Block)BlockRegistry.ARCANE_ANVIL_BLOCK.get());
    }

    public void m_6640_() {
        ItemStack result = ItemStack.f_41583_;
        ItemStack baseItemStack = this.f_39769_.m_8020_(0);
        ItemStack modifierItemStack = this.f_39769_.m_8020_(1);
        if (!baseItemStack.m_41619_() && !modifierItemStack.m_41619_()) {
            Item scrollData3;
            if (baseItemStack.m_41720_() instanceof Scroll && modifierItemStack.m_41720_() instanceof Scroll) {
                SpellData spellData2;
                SpellData spellData1 = SpellData.getSpellData(baseItemStack);
                if (spellData1.equals(spellData2 = SpellData.getSpellData(modifierItemStack)) && spellData1.getLevel() < ServerConfigs.getSpellConfig(spellData1.getSpell()).maxLevel()) {
                    result = new ItemStack((ItemLike)ItemRegistry.SCROLL.get());
                    SpellData.setSpellData(result, spellData1.getSpell(), spellData1.getLevel() + 1);
                }
            } else if (baseItemStack.m_41720_() instanceof UniqueItem && modifierItemStack.m_41720_() instanceof Scroll) {
                SpellData scrollData2 = SpellData.getSpellData(modifierItemStack);
                if (baseItemStack.m_41720_() instanceof SpellBook) {
                    SpellBookData spellBookData = SpellBookData.getSpellBookData(baseItemStack);
                    SpellData[] spells = spellBookData.getInscribedSpells();
                    for (int i = 0; i < spells.length; ++i) {
                        SpellData spellData = spells[i];
                        if (spellData.getSpell() != scrollData2.getSpell() || spellData.getLevel() >= scrollData2.getLevel()) continue;
                        result = baseItemStack.m_41777_();
                        SpellBookData newData = SpellBookData.getSpellBookData(result);
                        newData.removeSpell(i, result);
                        newData.addSpell(scrollData2.getSpell(), scrollData2.getLevel(), i, result);
                        newData.setActiveSpellIndex(spellBookData.getActiveSpellIndex(), result);
                        SpellBookData.setSpellBookData(result, newData);
                        result.m_41784_().m_128379_("Improved", true);
                    }
                } else {
                    SpellData spellData = SpellData.getSpellData(baseItemStack);
                    if (spellData.getSpell() == scrollData2.getSpell() && spellData.getLevel() < scrollData2.getLevel()) {
                        result = baseItemStack.m_41777_();
                        SpellData.setSpellData(result, scrollData2);
                        result.m_41784_().m_128379_("Improved", true);
                    }
                }
            } else if (Utils.canImbue(baseItemStack) && modifierItemStack.m_41720_() instanceof Scroll) {
                result = baseItemStack.m_41777_();
                SpellData scrollData3 = SpellData.getSpellData(modifierItemStack);
                SpellData.setSpellData(result, scrollData3);
            } else if (Utils.canBeUpgraded(baseItemStack) && UpgradeData.getUpgradeData(baseItemStack).getCount() < (Integer)ServerConfigs.MAX_UPGRADES.get() && (scrollData3 = modifierItemStack.m_41720_()) instanceof UpgradeOrbItem) {
                UpgradeOrbItem upgradeOrb = (UpgradeOrbItem)scrollData3;
                result = baseItemStack.m_41777_();
                EquipmentSlot slot = UpgradeUtils.getRelevantEquipmentSlot(result);
                UpgradeData.getUpgradeData(result).addUpgrade(result, upgradeOrb.getUpgradeType(), slot);
            } else if (modifierItemStack.m_150930_((Item)ItemRegistry.SHRIVING_STONE.get()) && !(baseItemStack.m_41720_() instanceof Scroll)) {
                if (SpellData.hasSpellData(baseItemStack)) {
                    result = baseItemStack.m_41777_();
                    result.m_41749_("ISB_spell");
                } else if (UpgradeData.hasUpgradeData(baseItemStack)) {
                    result = baseItemStack.m_41777_();
                    result.m_41749_("ISBUpgrades");
                }
            }
        }
        this.f_39768_.m_6836_(0, result);
    }

    protected ItemCombinerMenuSlotDefinition m_266183_() {
        return ItemCombinerMenuSlotDefinition.m_266303_().m_266197_(0, 27, 47, p_266635_ -> true).m_266197_(1, 76, 47, p_266634_ -> true).m_266198_(2, 134, 47).m_266441_();
    }

    public boolean m_5882_(ItemStack pStack, Slot pSlot) {
        return pSlot.f_40218_ != this.f_39768_ && super.m_5882_(pStack, pSlot);
    }
}

