/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.player;

import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.effect.AbyssalShroudEffect;
import io.redspace.ironsspellbooks.effect.AscensionEffect;
import io.redspace.ironsspellbooks.effect.CustomDescriptionMobEffect;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.render.SpellRenderingHelper;
import io.redspace.ironsspellbooks.spells.blood.RayOfSiphoningSpell;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import io.redspace.ironsspellbooks.util.TooltipsUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientPlayerEvents {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side.isClient() && event.phase == TickEvent.Phase.END && event.player == Minecraft.m_91087_().f_91074_) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            ClientMagicData.getCooldowns().tick(1);
            if (ClientMagicData.getCastDuration() > 0) {
                ClientMagicData.handleCastDuration();
            }
            if (level != null) {
                List spellcasters = level.m_6249_((Entity)null, event.player.m_20191_().m_82400_(64.0), mob -> mob instanceof Player || mob instanceof AbstractSpellCastingMob);
                spellcasters.forEach(entity -> {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    SyncedSpellData spellData = ClientMagicData.getSyncedSpellData(livingEntity);
                    if (spellData.hasEffect(8L)) {
                        AbyssalShroudEffect.ambientParticles(level, livingEntity);
                    }
                    if (spellData.hasEffect(16L)) {
                        AscensionEffect.ambientParticles(level, livingEntity);
                    }
                    if (spellData.isCasting() && spellData.getCastingSpellId().equals(((AbstractSpell)SpellRegistry.RAY_OF_SIPHONING_SPELL.get()).getSpellId())) {
                        Vec3 impact = Utils.raycastForEntity(entity.f_19853_, entity, RayOfSiphoningSpell.getRange(0), true).m_82450_().m_82492_(0.0, 0.25, 0.0);
                        for (int i = 0; i < 8; ++i) {
                            Vec3 motion = new Vec3(Utils.getRandomScaled(0.2f), Utils.getRandomScaled(0.2f), Utils.getRandomScaled(0.2f));
                            entity.f_19853_.m_7106_(ParticleHelper.SIPHON, impact.f_82479_ + motion.f_82479_, impact.f_82480_ + motion.f_82480_, impact.f_82481_ + motion.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
                        }
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void beforeLivingRender(RenderLivingEvent.Pre<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> event) {
        SyncedSpellData syncedData;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if ((livingEntity instanceof Player || livingEntity instanceof AbstractSpellCastingMob) && (syncedData = ClientMagicData.getSyncedSpellData(livingEntity)).hasEffect(32L) && livingEntity.m_20177_((Player)player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void afterLivingRender(RenderLivingEvent.Post<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> event) {
        SyncedSpellData syncedData;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (syncedData = ClientMagicData.getSyncedSpellData(livingEntity)).isCasting()) {
            SpellRenderingHelper.renderSpellHelper(syncedData, livingEntity, event.getPoseStack(), event.getMultiBufferSource(), event.getPartialTick());
        }
    }

    @SubscribeEvent
    public static void imbuedWeaponTooltips(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (SpellData.getSpellData(stack) != SpellData.EMPTY) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            if (!(stack.m_41720_() instanceof Scroll)) {
                List<Component> additionalLines = TooltipsUtils.formatActiveSpellTooltip(stack, CastSource.SWORD, player);
                additionalLines.add(1, (Component)Component.m_237115_((String)"tooltip.irons_spellbooks.imbued_tooltip").m_130940_(ChatFormatting.GRAY));
                additionalLines.set(2, (Component)Component.m_237113_((String)" ").m_7220_(additionalLines.get(2)));
                if (event.getFlags().m_7050_()) {
                    event.getToolTip().addAll(event.getToolTip().size() - 2, additionalLines);
                } else {
                    event.getToolTip().addAll(additionalLines);
                }
            }
        }
    }

    @SubscribeEvent
    public static void customPotionTooltips(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        List mobEffects = PotionUtils.m_43547_((ItemStack)stack);
        if (mobEffects.size() > 0) {
            for (MobEffectInstance mobEffectInstance : mobEffects) {
                MobEffect mobEffect = mobEffectInstance.m_19544_();
                if (!(mobEffect instanceof CustomDescriptionMobEffect)) continue;
                CustomDescriptionMobEffect customDescriptionMobEffect = (CustomDescriptionMobEffect)mobEffect;
                CustomDescriptionMobEffect.handleCustomPotionTooltip(stack, event.getToolTip(), event.getFlags().m_7050_(), mobEffectInstance, customDescriptionMobEffect);
            }
        }
    }

    @SubscribeEvent
    public static void changeFogColor(ViewportEvent.ComputeFogColor event) {
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_21023_((MobEffect)MobEffectRegistry.PLANAR_SIGHT.get())) {
            int color = ((MobEffect)MobEffectRegistry.PLANAR_SIGHT.get()).m_19484_();
            float f = 0.0f;
            float f1 = 0.0f;
            float f2 = 0.0f;
            event.setRed((f += (float)(color >> 16 & 0xFF) / 255.0f) * 0.15f);
            event.setGreen((f1 += (float)(color >> 8 & 0xFF) / 255.0f) * 0.15f);
            event.setBlue((f2 += (float)(color >> 0 & 0xFF) / 255.0f) * 0.15f);
        }
    }
}

