/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.api.spells;

import com.google.common.util.concurrent.AtomicDouble;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.events.SpellCastEvent;
import io.redspace.ironsspellbooks.api.item.IScroll;
import io.redspace.ironsspellbooks.api.item.ISpellbook;
import io.redspace.ironsspellbooks.api.item.curios.RingData;
import io.redspace.ironsspellbooks.api.magic.IMagicManager;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.magic.MagicHelper;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.CastResult;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.ICastDataSerializable;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import io.redspace.ironsspellbooks.item.curios.CurioBaseItem;
import io.redspace.ironsspellbooks.network.ClientboundSyncMana;
import io.redspace.ironsspellbooks.network.ClientboundUpdateCastingState;
import io.redspace.ironsspellbooks.network.spell.ClientboundOnCastFinished;
import io.redspace.ironsspellbooks.network.spell.ClientboundOnCastStarted;
import io.redspace.ironsspellbooks.network.spell.ClientboundOnClientCast;
import io.redspace.ironsspellbooks.player.ClientInputEvents;
import io.redspace.ironsspellbooks.player.ClientSpellCastHelper;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.setup.Messages;
import io.redspace.ironsspellbooks.spells.NoneSpell;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.joml.Vector3f;
import top.theillusivec4.curios.api.CuriosApi;

public abstract class AbstractSpell {
    private String spellID = null;
    private String deathMessageId = null;
    private String spellName = null;
    protected int baseManaCost;
    protected int manaCostPerLevel;
    protected int baseSpellPower;
    protected int spellPowerPerLevel;
    protected int castTime;
    private volatile List<Double> rarityWeights;
    private final int maxRarity = SpellRarity.LEGENDARY.getValue();

    public final String getSpellName() {
        if (this.spellName == null) {
            ResourceLocation resourceLocation = Objects.requireNonNull(this.getSpellResource());
            this.spellName = resourceLocation.m_135815_().intern();
        }
        return this.spellName;
    }

    public final String getSpellId() {
        if (this.spellID == null) {
            ResourceLocation resourceLocation = Objects.requireNonNull(this.getSpellResource());
            this.spellID = resourceLocation.toString().intern();
        }
        return this.spellID;
    }

    public final ResourceLocation getSpellIconResource() {
        return new ResourceLocation(this.getSpellResource().m_135827_(), "textures/gui/spell_icons/" + this.getSpellName() + ".png");
    }

    public int getMinRarity() {
        return ServerConfigs.getSpellConfig(this).minRarity().getValue();
    }

    public int getMaxLevel() {
        return ServerConfigs.getSpellConfig(this).maxLevel();
    }

    public int getMinLevel() {
        return 1;
    }

    @Deprecated(forRemoval=true)
    public MutableComponent getDisplayName() {
        return Component.m_237115_((String)this.getComponentId());
    }

    public MutableComponent getDisplayName(Player player) {
        return Component.m_237115_((String)this.getComponentId());
    }

    public String getComponentId() {
        return String.format("spell.%s.%s", this.getSpellResource().m_135827_(), this.getSpellName());
    }

    public abstract ResourceLocation getSpellResource();

    public abstract DefaultConfig getDefaultConfig();

    public abstract CastType getCastType();

    public SchoolType getSchoolType() {
        return ServerConfigs.getSpellConfig(this).school();
    }

    public Vector3f getTargetingColor() {
        return this.getSchoolType().getTargetingColor();
    }

    public int getLevel(int level, @Nullable LivingEntity caster) {
        int addition = 0;
        if (caster != null) {
            addition = CuriosApi.getCuriosHelper().findCurios(caster, this::filterCurios).size();
        }
        return level + addition;
    }

    private boolean filterCurios(ItemStack itemStack) {
        return RingData.hasRingData(itemStack) && RingData.getRingData(itemStack).getSpell().equals(this);
    }

    public int getManaCost(int level, @Nullable LivingEntity caster) {
        return (int)((double)(this.baseManaCost + this.manaCostPerLevel * (this.getLevel(level, caster) - 1)) * ServerConfigs.getSpellConfig(this).manaMultiplier());
    }

    public int getSpellCooldown() {
        return ServerConfigs.getSpellConfig(this).cooldownInTicks();
    }

    public int getCastTime(int spellLevel) {
        return this.castTime;
    }

    public ICastDataSerializable getEmptyCastData() {
        return null;
    }

    public abstract Optional<SoundEvent> getCastStartSound();

    public abstract Optional<SoundEvent> getCastFinishSound();

    public AnimationHolder getCastStartAnimation() {
        return switch (this.getCastType()) {
            case CastType.INSTANT -> SpellAnimations.ANIMATION_INSTANT_CAST;
            case CastType.CONTINUOUS -> SpellAnimations.ANIMATION_CONTINUOUS_CAST;
            case CastType.LONG -> SpellAnimations.ANIMATION_LONG_CAST;
            default -> AnimationHolder.none();
        };
    }

    public AnimationHolder getCastFinishAnimation() {
        return switch (this.getCastType()) {
            case CastType.LONG -> SpellAnimations.ANIMATION_LONG_CAST_FINISH;
            default -> AnimationHolder.none();
        };
    }

    public float getSpellPower(int spellLevel, @Nullable Entity sourceEntity) {
        double entitySpellPowerModifier = 1.0;
        double entitySchoolPowerModifier = 1.0;
        float configPowerModifier = (float)ServerConfigs.getSpellConfig(this).powerMultiplier();
        int level = this.getLevel(spellLevel, null);
        if (sourceEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)sourceEntity;
            level = this.getLevel(spellLevel, livingEntity);
            entitySpellPowerModifier = (float)livingEntity.m_21133_((Attribute)AttributeRegistry.SPELL_POWER.get());
            entitySchoolPowerModifier = this.getSchoolType().getPowerFor(livingEntity);
        }
        return (float)((double)(this.baseSpellPower + this.spellPowerPerLevel * (level - 1)) * entitySpellPowerModifier * entitySchoolPowerModifier * (double)configPowerModifier);
    }

    public float getEntityPowerMultiplier(@Nullable LivingEntity entity) {
        if (entity == null) {
            return 1.0f;
        }
        float entitySpellPowerModifier = (float)entity.m_21133_((Attribute)AttributeRegistry.SPELL_POWER.get());
        double entitySchoolPowerModifier = this.getSchoolType().getPowerFor(entity);
        return (float)((double)entitySpellPowerModifier * entitySchoolPowerModifier);
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        double entityCastTimeModifier = 1.0;
        if (entity != null) {
            entityCastTimeModifier = this.getCastType() != CastType.CONTINUOUS ? 2.0 - Utils.softCapFormula(entity.m_21133_((Attribute)AttributeRegistry.CAST_TIME_REDUCTION.get())) : entity.m_21133_((Attribute)AttributeRegistry.CAST_TIME_REDUCTION.get());
        }
        return Math.round((float)this.getCastTime(spellLevel) * (float)entityCastTimeModifier);
    }

    public boolean attemptInitiateCast(ItemStack stack, int spellLevel, Level level, Player player, CastSource castSource, boolean triggerCooldown) {
        if (level.f_46443_) {
            return false;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        MagicData playerMagicData = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
        if (!playerMagicData.isCasting()) {
            CastResult castResult = this.canBeCastedBy(spellLevel, castSource, playerMagicData, (Player)serverPlayer);
            if (castResult.message != null) {
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket(castResult.message));
            }
            if (!castResult.isSuccess() || !this.checkPreCastConditions(level, spellLevel, (LivingEntity)serverPlayer, playerMagicData) || MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent(player, this.getSpellId(), spellLevel, this.getSchoolType(), castSource))) {
                return false;
            }
            CastType castType = this.getCastType();
            if (castType == CastType.INSTANT) {
                this.castSpell(level, spellLevel, serverPlayer, castSource, triggerCooldown);
            } else if (castType == CastType.LONG || castType == CastType.CONTINUOUS) {
                int effectiveCastTime = this.getEffectiveCastTime(spellLevel, (LivingEntity)player);
                playerMagicData.initiateCast(this, this.getLevel(spellLevel, (LivingEntity)player), effectiveCastTime, castSource);
                this.onServerPreCast(player.f_19853_, spellLevel, (LivingEntity)player, playerMagicData);
                Messages.sendToPlayer(new ClientboundUpdateCastingState(this.getSpellId(), this.getLevel(spellLevel, (LivingEntity)player), effectiveCastTime, castSource), serverPlayer);
            }
            Messages.sendToPlayersTrackingEntity(new ClientboundOnCastStarted(serverPlayer.m_20148_(), this.getSpellId(), spellLevel), (Entity)serverPlayer, true);
            return true;
        }
        Utils.serverSideCancelCast(serverPlayer);
        return false;
    }

    public void castSpell(Level world, int spellLevel, ServerPlayer serverPlayer, CastSource castSource, boolean triggerCooldown) {
        IMagicManager magicManager = MagicHelper.MAGIC_MANAGER;
        MagicData playerMagicData = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
        if (castSource.consumesMana()) {
            int newMana = playerMagicData.getMana() - this.getManaCost(spellLevel, (LivingEntity)serverPlayer);
            magicManager.setPlayerCurrentMana(serverPlayer, newMana);
            Messages.sendToPlayer(new ClientboundSyncMana(playerMagicData), serverPlayer);
        }
        if (triggerCooldown) {
            magicManager.addCooldown(serverPlayer, this, castSource);
        }
        this.onCast(world, spellLevel, (LivingEntity)serverPlayer, playerMagicData);
        Messages.sendToPlayer(new ClientboundOnClientCast(this.getSpellId(), this.getLevel(spellLevel, (LivingEntity)serverPlayer), castSource, playerMagicData.getAdditionalCastData()), serverPlayer);
        if (this.getCastType() == CastType.INSTANT) {
            this.onServerCastComplete(world, spellLevel, (LivingEntity)serverPlayer, playerMagicData, false);
        }
        if (serverPlayer.m_21205_().m_41720_() instanceof ISpellbook || serverPlayer.m_21205_().m_41720_() instanceof IScroll) {
            playerMagicData.setPlayerCastingItem(serverPlayer.m_21205_());
        } else {
            playerMagicData.setPlayerCastingItem(serverPlayer.m_21206_());
        }
    }

    public void onClientCast(Level level, int spellLevel, LivingEntity entity, ICastData castData) {
        this.playSound(this.getCastFinishSound(), (Entity)entity, true);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        this.playSound(this.getCastFinishSound(), (Entity)entity, true);
    }

    protected void playSound(Optional<SoundEvent> sound, Entity entity, boolean playDefaultSound) {
        if (sound.isPresent()) {
            entity.m_5496_(sound.get(), 2.0f, 0.9f + Utils.random.m_188501_() * 0.2f);
        } else if (playDefaultSound) {
            entity.m_5496_(this.defaultCastSound(), 2.0f, 0.9f + Utils.random.m_188501_() * 0.2f);
        }
    }

    public CastResult canBeCastedBy(int spellLevel, CastSource castSource, MagicData playerMagicData, Player player) {
        int playerMana = playerMagicData.getMana();
        boolean hasEnoughMana = playerMana - this.getManaCost(spellLevel, (LivingEntity)player) >= 0;
        boolean isSpellOnCooldown = playerMagicData.getPlayerCooldowns().isOnCooldown(this);
        if ((castSource == CastSource.SPELLBOOK || castSource == CastSource.SWORD) && isSpellOnCooldown) {
            return new CastResult(CastResult.Type.FAILURE, (Component)Component.m_237110_((String)"ui.irons_spellbooks.cast_error_cooldown", (Object[])new Object[]{this.getDisplayName(player)}).m_130940_(ChatFormatting.RED));
        }
        if (castSource.consumesMana() && !hasEnoughMana) {
            return new CastResult(CastResult.Type.FAILURE, (Component)Component.m_237110_((String)"ui.irons_spellbooks.cast_error_mana", (Object[])new Object[]{this.getDisplayName(player)}).m_130940_(ChatFormatting.RED));
        }
        return new CastResult(CastResult.Type.SUCCESS);
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        return this.checkPreCastConditions(level, entity, playerMagicData);
    }

    @Deprecated(forRemoval=true)
    public boolean checkPreCastConditions(Level level, LivingEntity entity, MagicData playerMagicData) {
        return true;
    }

    protected void playSound(Optional<SoundEvent> sound, Entity entity) {
        this.playSound(sound, entity, false);
    }

    private SoundEvent defaultCastSound() {
        return this.getSchoolType().getCastSound();
    }

    public void onServerCastComplete(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData, boolean cancelled) {
        playerMagicData.resetCastingState();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            Messages.sendToPlayersTrackingEntity(new ClientboundOnCastFinished(serverPlayer.m_20148_(), this.getSpellId(), cancelled), (Entity)serverPlayer, true);
        }
    }

    public void onClientPreCast(Level level, int spellLevel, LivingEntity entity, InteractionHand hand, @Nullable MagicData playerMagicData) {
        if (this.getCastType().immediatelySuppressRightClicks() && ClientInputEvents.isUseKeyDown) {
            ClientSpellCastHelper.setSuppressRightClicks(true);
        }
        this.playSound(this.getCastStartSound(), (Entity)entity);
    }

    public void onServerPreCast(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        this.playSound(this.getCastStartSound(), (Entity)entity);
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
    }

    public boolean shouldAIStopCasting(int spellLevel, Mob mob, LivingEntity target) {
        return false;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractSpell) {
            AbstractSpell other = (AbstractSpell)obj;
            return this.getSpellResource().equals((Object)other.getSpellResource());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRarityWeights() {
        NoneSpell noneSpell = SpellRegistry.none();
        synchronized (noneSpell) {
            if (this.rarityWeights == null) {
                int minRarity = this.getMinRarity();
                int maxRarity = this.getMaxRarity();
                List<Double> rarityRawConfig = SpellRarity.getRawRarityConfig();
                List<Double> rarityConfig = SpellRarity.getRarityConfig();
                if (minRarity != 0) {
                    List<Double> subList = rarityRawConfig.subList(minRarity, maxRarity + 1);
                    double subtotal = subList.stream().reduce(0.0, Double::sum);
                    List<Double> rarityRawWeights = subList.stream().map(item -> item / subtotal * (1.0 - subtotal) + item).toList();
                    AtomicDouble counter = new AtomicDouble();
                    this.rarityWeights = new ArrayList<Double>();
                    rarityRawWeights.forEach(item -> this.rarityWeights.add(counter.addAndGet(item.doubleValue())));
                } else {
                    this.rarityWeights = rarityConfig;
                }
            }
        }
    }

    public SpellRarity getRarity(int level) {
        if (this.rarityWeights == null) {
            this.initializeRarityWeights();
        }
        int maxLevel = this.getMaxLevel();
        int maxRarity = this.getMaxRarity();
        if (maxLevel == 1) {
            return SpellRarity.values()[this.getMinRarity()];
        }
        double percentOfMaxLevel = (double)level / (double)maxLevel;
        int lookupOffset = maxRarity + 1 - this.rarityWeights.size();
        for (int i = 0; i < this.rarityWeights.size(); ++i) {
            if (!(percentOfMaxLevel <= this.rarityWeights.get(i))) continue;
            return SpellRarity.values()[i + lookupOffset];
        }
        return SpellRarity.COMMON;
    }

    public String getDeathMessageId() {
        if (this.deathMessageId == null) {
            this.deathMessageId = this.getSpellId().replace(':', '.');
        }
        return this.deathMessageId;
    }

    public final SpellDamageSource getDamageSource(Entity attacker) {
        return this.getDamageSource(attacker, attacker);
    }

    public SpellDamageSource getDamageSource(Entity projectile, Entity attacker) {
        return SpellDamageSource.source(projectile, attacker, this);
    }

    public boolean isEnabled() {
        return ServerConfigs.getSpellConfig(this).enabled();
    }

    public int getMaxRarity() {
        return this.maxRarity;
    }

    public int getMinLevelForRarity(SpellRarity rarity) {
        if (this.rarityWeights == null) {
            this.initializeRarityWeights();
        }
        int minRarity = this.getMinRarity();
        int maxLevel = this.getMaxLevel();
        if (rarity.getValue() < minRarity) {
            return 0;
        }
        if (rarity.getValue() == minRarity) {
            return 1;
        }
        return (int)(this.rarityWeights.get(rarity.getValue() - (1 + minRarity)) * (double)maxLevel) + 1;
    }

    public boolean allowLooting() {
        return true;
    }

    public boolean canBeCraftedBy(Player player) {
        return true;
    }

    public boolean allowCrafting() {
        return true;
    }

    public boolean obfuscateStats(@Nullable Player player) {
        return false;
    }

    public boolean isLearned(@Nullable Player player) {
        return true;
    }

    public boolean canBeInterrupted(@Nullable Player player) {
        return this.getCastType() == CastType.LONG && !((CurioBaseItem)((Object)ItemRegistry.CONCENTRATION_AMULET.get())).isEquippedBy((LivingEntity)player);
    }

    public boolean stopSoundOnCancel() {
        return false;
    }
}

