/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.api.util;

import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.CastTargetingData;
import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.capabilities.spellbook.SpellBookData;
import io.redspace.ironsspellbooks.compat.tetra.TetraProxy;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.entity.spells.shield.ShieldEntity;
import io.redspace.ironsspellbooks.item.SpellBook;
import io.redspace.ironsspellbooks.item.UniqueItem;
import io.redspace.ironsspellbooks.network.ServerboundCancelCast;
import io.redspace.ironsspellbooks.network.ServerboundQuickCast;
import io.redspace.ironsspellbooks.network.spell.ClientboundSyncTargetingData;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.setup.Messages;
import io.redspace.ironsspellbooks.util.ModTags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockCollisions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class Utils {
    public static final RandomSource random = RandomSource.m_216337_();

    public static String getStackTraceAsString() {
        Stream<StackTraceElement> trace = Arrays.stream(Thread.currentThread().getStackTrace());
        StringBuffer sb = new StringBuffer();
        trace.forEach(item -> {
            sb.append(item.toString());
            sb.append("\n");
        });
        return sb.toString();
    }

    public static void spawnInWorld(Level level, BlockPos pos, ItemStack remaining) {
        if (!remaining.m_41619_()) {
            ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, remaining);
            itemEntity.m_32010_(40);
            itemEntity.m_20256_(itemEntity.m_20184_().m_82542_(0.0, 1.0, 0.0));
            level.m_7967_((Entity)itemEntity);
        }
    }

    public static boolean canBeUpgraded(ItemStack stack) {
        return !((List)ServerConfigs.UPGRADE_BLACKLIST.get()).contains(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString()) && (stack.m_41720_() instanceof SpellBook || stack.m_41720_() instanceof ArmorItem || ((List)ServerConfigs.UPGRADE_WHITELIST.get()).contains(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString()));
    }

    public static String timeFromTicks(float ticks, int decimalPlaces) {
        float ticks_to_seconds = 20.0f;
        float seconds_to_minutes = 60.0f;
        String affix = "s";
        float time = ticks / ticks_to_seconds;
        if (time > seconds_to_minutes) {
            time /= seconds_to_minutes;
            affix = "m";
        }
        return Utils.stringTruncation(time, decimalPlaces) + affix;
    }

    public static double softCapFormula(double x) {
        return x <= 1.75 ? x : 1.0 / (-16.0 * (x - 1.5)) + 2.0;
    }

    public static boolean isPlayerHoldingSpellBook(Player player) {
        return player.m_21205_().m_41720_() instanceof SpellBook || player.m_21206_().m_41720_() instanceof SpellBook;
    }

    public static ServerPlayer getServerPlayer(Level level, UUID uuid) {
        return level.m_7654_().m_6846_().m_11259_(uuid);
    }

    public static String stringTruncation(double f, int decimalPlaces) {
        if (f == Math.floor(f)) {
            return Integer.toString((int)f);
        }
        double multiplier = Math.pow(10.0, decimalPlaces);
        double truncatedValue = Math.floor(f * multiplier) / multiplier;
        String result = Double.toString(truncatedValue);
        result = (result = result.replaceAll("0*$", "")).endsWith(".") ? result.substring(0, result.length() - 1) : result;
        return result;
    }

    public static float intPow(float f, int exponent) {
        if (exponent == 0) {
            return 1.0f;
        }
        float b = f;
        for (int i = 1; i < Math.abs(exponent); ++i) {
            b *= f;
        }
        return exponent < 0 ? 1.0f / b : b;
    }

    public static double intPow(double d, int exponent) {
        if (exponent == 0) {
            return 1.0;
        }
        double b = d;
        for (int i = 1; i < Math.abs(exponent); ++i) {
            b *= d;
        }
        return exponent < 0 ? 1.0 / b : b;
    }

    public static float getAngle(Vec2 a, Vec2 b) {
        return Utils.getAngle(a.f_82470_, a.f_82471_, b.f_82470_, b.f_82471_);
    }

    public static float getAngle(double ax, double ay, double bx, double by) {
        return (float)Math.atan2(by - ay, bx - ax) + 3.141f;
    }

    public static BlockHitResult getTargetOld(Level level, Player player, ClipContext.Fluid clipContext, double reach) {
        float f = player.m_146909_();
        float f1 = player.m_146908_();
        Vec3 vec3 = player.m_146892_();
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        Vec3 vec31 = vec3.m_82520_((double)f6 * reach, (double)f5 * reach, (double)f7 * reach);
        return level.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, clipContext, (Entity)player));
    }

    public static BlockHitResult getTargetBlock(Level level, LivingEntity entity, ClipContext.Fluid clipContext, double reach) {
        Vec3 rotation = entity.m_20154_().m_82541_().m_82490_(reach);
        Vec3 pos = entity.m_146892_();
        Vec3 dest = rotation.m_82549_(pos);
        return level.m_45547_(new ClipContext(pos, dest, ClipContext.Block.COLLIDER, clipContext, (Entity)entity));
    }

    public static boolean hasLineOfSight(Level level, Vec3 start, Vec3 end, boolean checkForShields) {
        HitResult shieldImpact;
        List shieldEntities;
        if (checkForShields && (shieldEntities = level.m_45976_(ShieldEntity.class, new AABB(start, end))).size() > 0 && (shieldImpact = Utils.checkEntityIntersecting((Entity)shieldEntities.get(0), start, end, 0.0f)).m_6662_() != HitResult.Type.MISS) {
            end = shieldImpact.m_82450_();
        }
        return level.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null)).m_6662_() == HitResult.Type.MISS;
    }

    public static boolean hasLineOfSight(Level level, Entity entity1, Entity entity2, boolean checkForShields) {
        return Utils.hasLineOfSight(level, entity1.m_20191_().m_82399_(), entity2.m_20191_().m_82399_(), checkForShields);
    }

    public static BlockHitResult raycastForBlock(Level level, Vec3 start, Vec3 end, ClipContext.Fluid clipContext) {
        return level.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, clipContext, null));
    }

    public static HitResult checkEntityIntersecting(Entity entity, Vec3 start, Vec3 end, float bbInflation) {
        Vec3 hitPos = null;
        if (entity.isMultipartEntity()) {
            for (PartEntity p : entity.getParts()) {
                Vec3 hit = p.m_20191_().m_82400_((double)bbInflation).m_82371_(start, end).orElse(null);
                if (hit == null) continue;
                hitPos = hit;
                break;
            }
        } else {
            hitPos = entity.m_20191_().m_82400_((double)bbInflation).m_82371_(start, end).orElse(null);
        }
        if (hitPos != null) {
            return new EntityHitResult(entity, hitPos);
        }
        return BlockHitResult.m_82426_((Vec3)end, (Direction)Direction.UP, (BlockPos)BlockPos.m_274446_((Position)end));
    }

    public static Vec3 getPositionFromEntityLookDirection(Entity originEntity, float distance) {
        Vec3 start = originEntity.m_146892_();
        return originEntity.m_20154_().m_82541_().m_82490_((double)distance).m_82549_(start);
    }

    public static HitResult raycastForEntity(Level level, Entity originEntity, float distance, boolean checkForBlocks) {
        Vec3 start = originEntity.m_146892_();
        Vec3 end = originEntity.m_20154_().m_82541_().m_82490_((double)distance).m_82549_(start);
        return Utils.raycastForEntity(level, originEntity, start, end, checkForBlocks);
    }

    public static HitResult raycastForEntity(Level level, Entity originEntity, float distance, boolean checkForBlocks, float bbInflation) {
        Vec3 start = originEntity.m_146892_();
        Vec3 end = originEntity.m_20154_().m_82541_().m_82490_((double)distance).m_82549_(start);
        return Utils.internalRaycastForEntity(level, originEntity, start, end, checkForBlocks, bbInflation, Utils::canHitWithRaycast);
    }

    public static HitResult raycastForEntity(Level level, Entity originEntity, Vec3 start, Vec3 end, boolean checkForBlocks) {
        return Utils.internalRaycastForEntity(level, originEntity, start, end, checkForBlocks, 0.0f, Utils::canHitWithRaycast);
    }

    public static HitResult raycastForEntity(Level level, Entity originEntity, Vec3 start, Vec3 end, boolean checkForBlocks, float bbInflation, Predicate<? super Entity> filter) {
        return Utils.internalRaycastForEntity(level, originEntity, start, end, checkForBlocks, bbInflation, filter);
    }

    public static HitResult raycastForEntityOfClass(Level level, Entity originEntity, Vec3 start, Vec3 end, boolean checkForBlocks, Class<? extends Entity> c) {
        return Utils.internalRaycastForEntity(level, originEntity, start, end, checkForBlocks, 0.0f, entity -> entity.getClass() == c);
    }

    public static void quickCast(int slot) {
        SpellData spell;
        SpellBookData spellBookData;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        InteractionHand hand = InteractionHand.MAIN_HAND;
        ItemStack itemStack = player.m_21120_(hand);
        if (!(itemStack.m_41720_() instanceof SpellBook)) {
            hand = InteractionHand.OFF_HAND;
            itemStack = player.m_21120_(hand);
        }
        if (itemStack.m_41720_() instanceof SpellBook && (spellBookData = SpellBookData.getSpellBookData(itemStack)).getSpellSlots() >= 1 && (spell = spellBookData.getSpell(slot)) != null) {
            Messages.sendToServer(new ServerboundQuickCast(slot, hand));
        }
    }

    public static void releaseUsingHelper(LivingEntity entity, ItemStack itemStack, int ticksUsed) {
        ServerPlayer serverPlayer;
        MagicData pmd;
        if (entity instanceof ServerPlayer && (pmd = MagicData.getPlayerMagicData((LivingEntity)(serverPlayer = (ServerPlayer)entity))).isCasting()) {
            Utils.serverSideCancelCast(serverPlayer);
            serverPlayer.m_5810_();
        }
    }

    private static HitResult internalRaycastForEntity(Level level, Entity originEntity, Vec3 start, Vec3 end, boolean checkForBlocks, float bbInflation, Predicate<? super Entity> filter) {
        BlockHitResult blockHitResult = null;
        if (checkForBlocks) {
            blockHitResult = level.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, originEntity));
            end = blockHitResult.m_82450_();
        }
        AABB range = originEntity.m_20191_().m_82369_(end.m_82546_(start));
        ArrayList<HitResult> hits = new ArrayList<HitResult>();
        List entities = level.m_6249_(originEntity, range, filter);
        for (Entity target : entities) {
            HitResult hit = Utils.checkEntityIntersecting(target, start, end, bbInflation);
            if (hit.m_6662_() == HitResult.Type.MISS) continue;
            hits.add(hit);
        }
        if (!hits.isEmpty()) {
            hits.sort((o1, o2) -> (int)(o1.m_82450_().m_82557_(start) - o2.m_82450_().m_82557_(start)));
            return (HitResult)hits.get(0);
        }
        if (checkForBlocks) {
            return blockHitResult;
        }
        return BlockHitResult.m_82426_((Vec3)end, (Direction)Direction.UP, (BlockPos)BlockPos.m_274446_((Position)end));
    }

    public static void serverSideCancelCast(ServerPlayer serverPlayer) {
        ServerboundCancelCast.cancelCast(serverPlayer, MagicData.getPlayerMagicData((LivingEntity)serverPlayer).getCastingSpell().getSpell().getCastType() == CastType.CONTINUOUS);
    }

    public static void serverSideCancelCast(ServerPlayer serverPlayer, boolean triggerCooldown) {
        ServerboundCancelCast.cancelCast(serverPlayer, triggerCooldown);
    }

    public static float smoothstep(float a, float b, float x) {
        x = 6.0f * (x * x * x * x * x) - 15.0f * (x * x * x * x) + 10.0f * (x * x * x);
        return a + (b - a) * x;
    }

    private static boolean canHitWithRaycast(Entity entity) {
        return entity.m_6087_();
    }

    public static Vec2 rotationFromDirection(Vec3 vector) {
        float pitch = (float)Math.asin(vector.f_82480_);
        float yaw = (float)Math.atan2(vector.f_82479_, vector.f_82481_);
        return new Vec2(pitch, yaw);
    }

    @Deprecated(forRemoval=true)
    public static boolean doMeleeAttack(Mob attacker, Entity target, DamageSource damageSource, SchoolType schoolType) {
        return Utils.doMeleeAttack(attacker, target, damageSource);
    }

    public static boolean doMeleeAttack(Mob attacker, Entity target, DamageSource damageSource) {
        boolean flag;
        int i;
        float f = (float)attacker.m_21133_(Attributes.f_22281_);
        float f1 = (float)attacker.m_21133_(Attributes.f_22282_);
        if (target instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)attacker.m_21205_(), (MobType)((LivingEntity)target).m_6336_());
            f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)attacker);
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)attacker)) > 0) {
            target.m_20254_(i * 4);
        }
        if (flag = DamageSources.applyDamage(target, f, damageSource)) {
            if (f1 > 0.0f && target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                ((LivingEntity)target).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(attacker.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(attacker.m_146908_() * ((float)Math.PI / 180)))));
                attacker.m_20256_(attacker.m_20184_().m_82542_(0.6, 1.0, 0.6));
                livingTarget.m_6703_((LivingEntity)attacker);
            }
            if (target instanceof Player) {
                ItemStack pPlayerItemStack;
                Player player = (Player)target;
                ItemStack pMobItemStack = attacker.m_21205_();
                ItemStack itemStack = pPlayerItemStack = player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_;
                if (!pMobItemStack.m_41619_() && !pPlayerItemStack.m_41619_() && pMobItemStack.m_41720_() instanceof AxeItem && pPlayerItemStack.m_150930_(Items.f_42740_)) {
                    float f2 = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)attacker) * 0.05f;
                    if (attacker.m_217043_().m_188501_() < f2) {
                        player.m_36335_().m_41524_(Items.f_42740_, 100);
                        attacker.f_19853_.m_7605_((Entity)player, (byte)30);
                    }
                }
            }
            attacker.m_19970_((LivingEntity)attacker, target);
            attacker.m_21335_(target);
        }
        return flag;
    }

    public static void throwTarget(LivingEntity attacker, LivingEntity target, float multiplier, boolean ignoreKBResistance) {
        double d1;
        double d0 = attacker.m_21133_(Attributes.f_22282_) * (double)multiplier;
        double d2 = d0 - (d1 = ignoreKBResistance ? 0.0 : target.m_21133_(Attributes.f_22278_));
        if (!(d2 <= 0.0)) {
            double d3 = target.m_20185_() - attacker.m_20185_();
            double d4 = target.m_20189_() - attacker.m_20189_();
            float f = random.m_188503_(21) - 10;
            double d5 = d2 * (double)(random.m_188501_() * 0.5f + 0.2f);
            Vec3 vec3 = new Vec3(d3, 0.0, d4).m_82541_().m_82490_(d5).m_82524_(f);
            double d6 = d2 * (double)random.m_188501_() * 0.5;
            target.m_5997_(vec3.f_82479_, d6, vec3.f_82481_);
            target.f_19864_ = true;
        }
    }

    public static double getRandomScaled(double scale) {
        return (2.0 * Math.random() - 1.0) * scale;
    }

    public static Vec3 getRandomVec3(double scale) {
        return new Vec3(Utils.getRandomScaled(scale), Utils.getRandomScaled(scale), Utils.getRandomScaled(scale));
    }

    public static boolean shouldHealEntity(LivingEntity healer, LivingEntity target) {
        NeutralMob neutralMob;
        if (healer instanceof NeutralMob && (neutralMob = (NeutralMob)healer).m_21674_(target)) {
            return false;
        }
        if (healer == target) {
            return true;
        }
        if (target.m_6095_().m_204039_(ModTags.ALWAYS_HEAL) && !(healer instanceof Enemy)) {
            return true;
        }
        if (target.m_7307_((Entity)healer) || healer.m_7307_((Entity)target)) {
            return true;
        }
        if (healer.m_5647_() != null) {
            return target.m_20031_(healer.m_5647_());
        }
        if (healer instanceof Player) {
            return target instanceof Player;
        }
        return healer.m_6336_() == target.m_6336_() && healer instanceof Enemy ^ target instanceof Enemy;
    }

    public static boolean canImbue(ItemStack itemStack) {
        SwordItem swordItem;
        String id = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString();
        if (((List)ServerConfigs.IMBUE_BLACKLIST.get()).contains(id)) {
            return false;
        }
        if (((List)ServerConfigs.IMBUE_WHITELIST.get()).contains(id)) {
            return true;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof SwordItem && !((swordItem = (SwordItem)item) instanceof UniqueItem)) {
            return true;
        }
        return TetraProxy.PROXY.canImbue(itemStack);
    }

    public static InteractionResultHolder<ItemStack> onUseCastingHelper(@NotNull Level level, Player player, @NotNull InteractionHand hand, ItemStack stack, SpellData spellData) {
        AbstractSpell spell = spellData.getSpell();
        if (spell != SpellRegistry.none()) {
            if (level.f_46443_) {
                if (ClientMagicData.isCasting()) {
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
                if (ClientMagicData.getCooldowns().isOnCooldown(spell) || ((Boolean)ServerConfigs.SWORDS_CONSUME_MANA.get()).booleanValue() && ClientMagicData.getPlayerMana() < spell.getManaCost(spellData.getLevel(), null) || !ClientMagicData.getSyncedSpellData((LivingEntity)player).isSpellLearned(spell)) {
                    return InteractionResultHolder.m_19098_((Object)stack);
                }
                return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
            }
            if (spell.attemptInitiateCast(stack, spellData.getLevel(), level, player, CastSource.SWORD, true)) {
                if (spell.getCastType().holdToCast()) {
                    player.m_6672_(hand);
                }
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean validAntiMagicTarget(Entity entity) {
        if (entity instanceof AntiMagicSusceptible) return true;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return true;
        } else {
            if (!(entity instanceof AbstractSpellCastingMob)) return false;
            AbstractSpellCastingMob abstractSpellCastingMob = (AbstractSpellCastingMob)entity;
        }
        return true;
    }

    public static int findRelativeGroundLevel(Level level, Vec3 start, int maxSteps) {
        BlockPos pos;
        int i;
        if (level.m_8055_(BlockPos.m_274446_((Position)start)).m_60828_((BlockGetter)level, BlockPos.m_274446_((Position)start))) {
            for (i = 0; i < maxSteps; ++i) {
                pos = BlockPos.m_274446_((Position)(start = start.m_82520_(0.0, 1.0, 0.0)));
                if (level.m_8055_(pos).m_60828_((BlockGetter)level, pos)) continue;
                return pos.m_123342_();
            }
        }
        for (i = 0; i < maxSteps && !level.m_8055_(pos = BlockPos.m_274446_((Position)start).m_7495_()).m_60828_((BlockGetter)level, pos); ++i) {
            start = start.m_82520_(0.0, -1.0, 0.0);
        }
        return (int)start.f_82480_;
    }

    public static Vec3 moveToRelativeGroundLevel(Level level, Vec3 start, int maxSteps) {
        return Utils.moveToRelativeGroundLevel(level, start, maxSteps, maxSteps);
    }

    public static Vec3 moveToRelativeGroundLevel(Level level, Vec3 start, int maxStepsUp, int maxStepsDown) {
        BlockCollisions blockcollisions = new BlockCollisions((CollisionGetter)level, null, new AABB(0.0, 0.0, 0.0, 0.5, 0.5, 0.5).m_82383_(start), true, (p_286215_, p_286216_) -> p_286216_);
        if (blockcollisions.hasNext()) {
            for (int i = 1; i < maxStepsUp; ++i) {
                blockcollisions = new BlockCollisions((CollisionGetter)level, null, new AABB(0.0, 0.0, 0.0, 0.5, 0.5, 0.5).m_82383_(start.m_82520_(0.0, (double)i * 0.5, 0.0)), true, (p_286215_, p_286216_) -> p_286216_);
                if (blockcollisions.hasNext()) continue;
                start = start.m_82520_(0.0, (double)i * 0.5, 0.0);
                break;
            }
        }
        return level.m_45547_(new ClipContext(start, start.m_82520_(0.0, (double)(-maxStepsDown), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null)).m_82450_();
    }

    public static boolean checkMonsterSpawnRules(ServerLevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return !pLevel.m_204166_(pPos).m_203565_(Biomes.f_220594_) && !pLevel.m_204166_(pPos).m_203565_(Biomes.f_48215_) && Monster.m_219013_((EntityType)EntityType.f_20501_, (ServerLevelAccessor)pLevel, (MobSpawnType)pSpawnType, (BlockPos)pPos, (RandomSource)pRandom);
    }

    public static void sendTargetedNotification(ServerPlayer target, LivingEntity caster, AbstractSpell spell) {
        target.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"ui.irons_spellbooks.spell_target_warning", (Object[])new Object[]{caster.m_5446_().getString(), spell.getDisplayName((Player)target)}).m_130940_(ChatFormatting.LIGHT_PURPLE)));
    }

    public static boolean preCastTargetHelper(Level level, LivingEntity caster, MagicData playerMagicData, AbstractSpell spell, int range, float aimAssist) {
        return Utils.preCastTargetHelper(level, caster, playerMagicData, spell, range, aimAssist, true);
    }

    public static boolean preCastTargetHelper(Level level, LivingEntity caster, MagicData playerMagicData, AbstractSpell spell, int range, float aimAssist, boolean sendFailureMessage) {
        EntityHitResult entityHit;
        Entity entity;
        HitResult target = Utils.raycastForEntity(caster.f_19853_, (Entity)caster, range, true, aimAssist);
        if (target instanceof EntityHitResult && (entity = (entityHit = (EntityHitResult)target).m_82443_()) instanceof LivingEntity) {
            ServerPlayer serverPlayer;
            LivingEntity livingTarget = (LivingEntity)entity;
            playerMagicData.setAdditionalCastData(new CastTargetingData(livingTarget));
            if (caster instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)caster;
                Messages.sendToPlayer(new ClientboundSyncTargetingData(livingTarget, spell), serverPlayer);
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"ui.irons_spellbooks.spell_target_success", (Object[])new Object[]{livingTarget.m_5446_().getString(), spell.getDisplayName((Player)serverPlayer)}).m_130940_(ChatFormatting.GREEN)));
            }
            if (livingTarget instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)livingTarget;
                Utils.sendTargetedNotification(serverPlayer, caster, spell);
            }
            return true;
        }
        if (sendFailureMessage && caster instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)caster;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"ui.irons_spellbooks.cast_error_target").m_130940_(ChatFormatting.RED)));
        }
        return false;
    }

    public static Vector3f deconstructRGB(int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        return new Vector3f((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f);
    }

    public static int packRGB(Vector3f color) {
        int red = (int)(color.x() * 255.0f);
        int green = (int)(color.y() * 255.0f);
        int blue = (int)(color.z() * 255.0f);
        return red << 16 | green << 8 | blue;
    }

    public static CompoundTag saveAllItems(CompoundTag pTag, NonNullList<ItemStack> pList, String location) {
        ListTag listtag = new ListTag();
        for (int i = 0; i < pList.size(); ++i) {
            ItemStack itemstack = (ItemStack)pList.get(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.m_128344_("Slot", (byte)i);
            itemstack.m_41739_(compoundtag);
            listtag.add((Object)compoundtag);
        }
        if (!listtag.isEmpty()) {
            pTag.m_128365_(location, (Tag)listtag);
        }
        return pTag;
    }

    public static void loadAllItems(CompoundTag pTag, NonNullList<ItemStack> pList, String location) {
        ListTag listtag = pTag.m_128437_(location, 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            int j = compoundtag.m_128445_("Slot") & 0xFF;
            if (j < 0 || j >= pList.size()) continue;
            pList.set(j, (Object)ItemStack.m_41712_((CompoundTag)compoundtag));
        }
    }

    public static float getWeaponDamage(LivingEntity entity, MobType entityForDamageBonus) {
        if (entity != null) {
            float fist;
            float weapon = (float)entity.m_21133_(Attributes.f_22281_);
            if (weapon <= (fist = (float)entity.m_21172_(Attributes.f_22281_))) {
                weapon -= fist;
            }
            float enchant = EnchantmentHelper.m_44833_((ItemStack)entity.m_21205_(), (MobType)entityForDamageBonus);
            return weapon + enchant;
        }
        return 0.0f;
    }
}

