/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.effect.guiding_bolt;

import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.data.IronsDataStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class GuidingBoltManager
implements INBTSerializable<CompoundTag> {
    public static final GuidingBoltManager INSTANCE = new GuidingBoltManager();
    private final HashMap<UUID, ArrayList<Projectile>> trackedEntities = new HashMap();
    private final HashMap<ResourceKey<Level>, List<Projectile>> dirtyProjectiles = new HashMap();
    private final int tickDelay = 3;

    public void startTracking(LivingEntity entity) {
        if (!this.trackedEntities.containsKey(entity.m_20148_())) {
            this.trackedEntities.put(entity.m_20148_(), new ArrayList());
            IronsDataStorage.INSTANCE.m_77762_();
        }
    }

    public void stopTracking(LivingEntity entity) {
        this.trackedEntities.remove(entity.m_20148_());
        IronsDataStorage.INSTANCE.m_77762_();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag uuids = new ListTag();
        for (UUID key : this.trackedEntities.keySet()) {
            uuids.add((Object)NbtUtils.m_129226_((UUID)key));
        }
        tag.m_128365_("TrackedEntities", (Tag)uuids);
        return tag;
    }

    public void deserializeNBT(CompoundTag compoundTag) {
        ListTag list = compoundTag.m_128437_("TrackedEntities", 11);
        for (Tag uuidTag : list) {
            try {
                UUID uuid = NbtUtils.m_129233_((Tag)uuidTag);
                this.trackedEntities.put(uuid, new ArrayList());
            }
            catch (Exception ignored) {}
        }
    }

    @SubscribeEvent
    public static void onProjectileShot(EntityJoinLevelEvent event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            Entity entity;
            ServerLevel serverLevel = (ServerLevel)level;
            if (!GuidingBoltManager.INSTANCE.trackedEntities.isEmpty() && (entity = event.getEntity()) instanceof Projectile) {
                Projectile projectile = (Projectile)entity;
                GuidingBoltManager.INSTANCE.dirtyProjectiles.computeIfAbsent((ResourceKey<Level>)serverLevel.m_46472_(), key -> new ArrayList()).add(projectile);
            }
        }
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.START || GuidingBoltManager.INSTANCE.dirtyProjectiles.isEmpty()) {
            return;
        }
        Level level = event.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            List list = GuidingBoltManager.INSTANCE.dirtyProjectiles.getOrDefault(serverLevel.m_46472_(), List.of());
            for (int i = list.size() - 1; i >= 0; --i) {
                Projectile projectile = (Projectile)list.get(i);
                if (!projectile.isAddedToWorld()) continue;
                Vec3 start = projectile.m_20182_();
                int searchRange = 32;
                Vec3 end = Utils.raycastForBlock((Level)serverLevel, start, projectile.m_20184_().m_82541_().m_82490_((double)searchRange).m_82549_(start), ClipContext.Fluid.NONE).m_82450_();
                for (Map.Entry<UUID, ArrayList<Projectile>> entry : GuidingBoltManager.INSTANCE.trackedEntities.entrySet()) {
                    Entity entity = serverLevel.m_8791_(entry.getKey());
                    if (entity == null || Math.abs(entity.m_20185_() - projectile.m_20185_()) > (double)searchRange || Math.abs(entity.m_20186_() - projectile.m_20186_()) > (double)searchRange || Math.abs(entity.m_20189_() - projectile.m_20189_()) > (double)searchRange || Utils.checkEntityIntersecting(entity, start, end, 3.0f).m_6662_() != HitResult.Type.ENTITY) continue;
                    entry.getValue().add(projectile);
                }
                list.remove(i);
            }
        }
    }

    @SubscribeEvent
    public static void livingTick(LivingEvent.LivingTickEvent event) {
        ArrayList<Projectile> projectiles;
        if (GuidingBoltManager.INSTANCE.trackedEntities.isEmpty()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity.f_19797_ % GuidingBoltManager.INSTANCE.tickDelay == 0 && (projectiles = GuidingBoltManager.INSTANCE.trackedEntities.get(event.getEntity().m_20148_())) != null) {
            if (livingEntity.m_213877_() || livingEntity.m_21224_()) {
                INSTANCE.stopTracking(livingEntity);
                return;
            }
            for (Projectile projectile : projectiles) {
                float speed = (float)projectile.m_20184_().m_82553_();
                Vec3 magnetization = livingEntity.m_20191_().m_82399_().m_82546_(projectile.m_20182_()).m_82541_().m_82490_((double)(speed * 0.3f));
                projectile.m_20256_(projectile.m_20184_().m_82549_(magnetization));
            }
        }
    }
}

