/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells.guiding_bolt;

import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import io.redspace.ironsspellbooks.registries.EntityRegistry;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class GuidingBoltProjectile
extends AbstractMagicProjectile {
    public GuidingBoltProjectile(EntityType<? extends GuidingBoltProjectile> entityType, Level level) {
        super(entityType, level);
        this.m_20242_(true);
    }

    public GuidingBoltProjectile(EntityType<? extends GuidingBoltProjectile> entityType, Level levelIn, LivingEntity shooter) {
        super(entityType, levelIn);
        this.m_5602_((Entity)shooter);
    }

    public GuidingBoltProjectile(Level levelIn, LivingEntity shooter) {
        this((EntityType<? extends GuidingBoltProjectile>)((EntityType)EntityRegistry.GUIDING_BOLT.get()), levelIn, shooter);
    }

    @Override
    public void impactParticles(double x, double y, double z) {
        MagicManager.spawnParticles(this.f_19853_, ParticleHelper.WISP, x, y, z, 25, 0.0, 0.0, 0.0, 0.18, true);
    }

    @Override
    public float getSpeed() {
        return 1.0f;
    }

    @Override
    public Optional<SoundEvent> getImpactSound() {
        return Optional.of((SoundEvent)SoundRegistry.GUIDING_BOLT_IMPACT.get());
    }

    @Override
    protected void doImpactSound(SoundEvent sound) {
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), sound, SoundSource.NEUTRAL, 2.0f, 0.9f + Utils.random.m_188501_() * 0.4f);
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        this.m_146870_();
    }

    @Override
    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity entity;
        super.m_5790_(entityHitResult);
        if (DamageSources.applyDamage(entityHitResult.m_82443_(), this.damage, ((AbstractSpell)SpellRegistry.GUIDING_BOLT_SPELL.get()).getDamageSource((Entity)this, this.m_19749_())) && (entity = entityHitResult.m_82443_()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.GUIDING_BOLT.get(), 300));
        }
        this.m_146870_();
    }

    @Override
    public void trailParticles() {
    }
}

