/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.network;

import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.capabilities.spellbook.SpellBookData;
import io.redspace.ironsspellbooks.network.ServerboundCancelCast;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundQuickCast {
    private int slot;
    private InteractionHand hand;

    public ServerboundQuickCast(int slot, InteractionHand hand) {
        this.slot = slot;
        this.hand = hand;
    }

    public ServerboundQuickCast(FriendlyByteBuf buf) {
        this.slot = buf.readInt();
        this.hand = (InteractionHand)buf.m_130066_(InteractionHand.class);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.slot);
        buf.m_130068_((Enum)this.hand);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            SpellData spellData;
            ServerPlayer serverPlayer = ctx.getSender();
            ItemStack itemStack = serverPlayer.m_21120_(this.hand);
            SpellBookData sbd = SpellBookData.getSpellBookData(itemStack);
            if (sbd.getSpellSlots() > 0 && (spellData = sbd.getSpell(this.slot)) != null) {
                MagicData playerMagicData = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
                if (playerMagicData.isCasting() && !playerMagicData.getCastingSpellId().equals(spellData.getSpell().getSpellId())) {
                    ServerboundCancelCast.cancelCast(serverPlayer, playerMagicData.getCastType() != CastType.LONG);
                }
                spellData.getSpell().attemptInitiateCast(itemStack, spellData.getLevel(), serverPlayer.f_19853_, (Player)serverPlayer, CastSource.SPELLBOOK, true);
            }
        });
        return true;
    }
}

