/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.player;

import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.block.BloodCauldronBlock;
import io.redspace.ironsspellbooks.capabilities.magic.CooldownInstance;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import io.redspace.ironsspellbooks.capabilities.magic.UpgradeData;
import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.data.DataFixerStorage;
import io.redspace.ironsspellbooks.data.IronsDataStorage;
import io.redspace.ironsspellbooks.datafix.IronsWorldUpgrader;
import io.redspace.ironsspellbooks.datagen.DamageTypeTagGenerator;
import io.redspace.ironsspellbooks.effect.AbyssalShroudEffect;
import io.redspace.ironsspellbooks.effect.EvasionEffect;
import io.redspace.ironsspellbooks.effect.SummonTimer;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.entity.spells.root.PreventDismount;
import io.redspace.ironsspellbooks.item.SpellBook;
import io.redspace.ironsspellbooks.item.curios.CurioBaseItem;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.registries.BlockRegistry;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.util.ModTags;
import io.redspace.ironsspellbooks.util.UpgradeUtils;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber
public class ServerPlayerEvents {
    @SubscribeEvent
    public static void onServerStartedEvent(ServerStartedEvent event) {
        IronsDataStorage.init(event.getServer().m_129783_().m_8895_());
    }

    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        DataFixerStorage.init(event.getServer().f_129744_);
        if (((Boolean)ServerConfigs.RUN_WORLD_UPGRADER.get()).booleanValue()) {
            MinecraftServer server = event.getServer();
            new IronsWorldUpgrader(server.f_129744_, (LayeredRegistryAccess<RegistryLayer>)server.m_247573_()).runUpgrade();
        }
    }

    @SubscribeEvent
    public static void onLivingEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        ServerPlayer serverPlayer;
        MagicData playerMagicData;
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && (playerMagicData = MagicData.getPlayerMagicData((LivingEntity)(serverPlayer = (ServerPlayer)livingEntity))).isCasting() && (event.getSlot().m_20749_() == 0 || event.getSlot().m_20749_() == 1) && (event.getFrom().m_41720_() instanceof SpellBook || SpellData.hasSpellData(event.getFrom()))) {
            Utils.serverSideCancelCast(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Utils.serverSideCancelCast(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerOpenContainer(PlayerContainerEvent.Open event) {
        ServerPlayer serverPlayer;
        MagicData playerMagicData;
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        Player player = event.getEntity();
        if (player instanceof ServerPlayer && (playerMagicData = MagicData.getPlayerMagicData((LivingEntity)(serverPlayer = (ServerPlayer)player))).isCasting()) {
            Utils.serverSideCancelCast(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void handleUpgradeModifiers(ItemAttributeModifierEvent event) {
        ItemStack itemStack = event.getItemStack();
        if (!UpgradeData.hasUpgradeData(itemStack)) {
            return;
        }
        UpgradeData upgradeData = UpgradeData.getUpgradeData(itemStack);
        EquipmentSlot slot = event.getSlotType();
        if (upgradeData.getUpgradedSlot() != slot) {
            return;
        }
        UpgradeUtils.handleAttributeEvent(event, upgradeData);
    }

    @SubscribeEvent
    public static void onExperienceDroppedEvent(LivingExperienceDropEvent event) {
        Player player = event.getAttackingPlayer();
        if (player != null) {
            int ringCount = CuriosApi.getCuriosHelper().findCurios((LivingEntity)player, (Item)ItemRegistry.EMERALD_STONEPLATE_RING.get()).size();
            for (int i = 0; i < ringCount; ++i) {
                event.setDroppedExperience((int)((double)event.getDroppedExperience() * 1.25));
            }
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            player = event.getTarget();
            if (player instanceof ServerPlayer) {
                ServerPlayer targetPlayer = (ServerPlayer)player;
                MagicData.getPlayerMagicData((LivingEntity)serverPlayer).getSyncedData().syncToPlayer(targetPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MagicData playerMagicData = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
            playerMagicData.getPlayerCooldowns().syncToPlayer(serverPlayer);
            playerMagicData.getSyncedData().syncToPlayer(serverPlayer);
            CameraShakeManager.doSync(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            Utils.serverSideCancelCast(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer newServerPlayer = (ServerPlayer)player;
            boolean keepEverything = !event.isWasDeath();
            event.getOriginal().m_21220_().forEach(effect -> {
                if (effect.m_19544_() instanceof SummonTimer) {
                    newServerPlayer.m_147207_(effect, (Entity)newServerPlayer);
                }
            });
            event.getOriginal().reviveCaps();
            MagicData oldMagicData = MagicData.getPlayerMagicData((LivingEntity)event.getOriginal());
            MagicData newMagicData = MagicData.getPlayerMagicData((LivingEntity)event.getEntity());
            newMagicData.setSyncedData(oldMagicData.getSyncedData().getPersistentData());
            newMagicData.getSyncedData().doSync();
            oldMagicData.getPlayerCooldowns().getSpellCooldowns().forEach((spellId, cooldown) -> newMagicData.getPlayerCooldowns().getSpellCooldowns().put((String)spellId, (CooldownInstance)cooldown));
            event.getOriginal().invalidateCaps();
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Utils.serverSideCancelCast(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_20095_();
            serverPlayer.m_146917_(0);
            List data = serverPlayer.m_20088_().m_135378_();
            if (data != null) {
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityDataPacket(serverPlayer.m_19879_(), data));
            }
            Utils.serverSideCancelCast(serverPlayer);
            serverPlayer.m_21220_().forEach(effect -> {
                if (effect.m_19544_() instanceof SummonTimer) {
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(serverPlayer.m_19879_(), effect));
                }
            });
            MagicData.getPlayerMagicData((LivingEntity)serverPlayer).setMana((int)(serverPlayer.m_21133_((Attribute)AttributeRegistry.MAX_MANA.get()) * (Double)ServerConfigs.MANA_SPAWN_PERCENT.get()));
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer || livingEntity instanceof AbstractSpellCastingMob) {
            if (((CurioBaseItem)((Object)ItemRegistry.FIREWARD_RING.get())).isEquippedBy(livingEntity) && event.getSource().m_269533_(DamageTypeTags.f_268745_)) {
                event.getEntity().m_20095_();
                event.setCanceled(true);
                return;
            }
            MagicData playerMagicData = MagicData.getPlayerMagicData(livingEntity);
            if (playerMagicData.getSyncedData().hasEffect(2L)) {
                if (EvasionEffect.doEffect(livingEntity, event.getSource())) {
                    event.setCanceled(true);
                }
            } else if (playerMagicData.getSyncedData().hasEffect(8L) && AbyssalShroudEffect.doEffect(livingEntity, event.getSource())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingChangeTarget(LivingChangeTargetEvent event) {
        LivingEntity newTarget = event.getNewTarget();
        if (newTarget != null && newTarget.m_6095_().m_204039_(ModTags.VILLAGE_ALLIES) && event.getEntity().m_6095_().m_204039_(ModTags.VILLAGE_ALLIES)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingTakeDamage(LivingDamageEvent event) {
        MagicData playerMagicData;
        Creeper creeper;
        LivingEntity livingEntity;
        if (((Boolean)ServerConfigs.BETTER_CREEPER_THUNDERHIT.get()).booleanValue() && event.getSource().m_269533_(DamageTypeTags.f_268745_) && (livingEntity = event.getEntity()) instanceof Creeper && (creeper = (Creeper)livingEntity).m_7090_()) {
            event.setCanceled(true);
            return;
        }
        Entity attacker = event.getSource().m_7639_();
        if (attacker instanceof LivingEntity) {
            Player player;
            LivingEntity livingAttacker = (LivingEntity)attacker;
            if (livingAttacker.m_21023_((MobEffect)MobEffectRegistry.SPIDER_ASPECT.get()) && event.getEntity().m_21023_(MobEffects.f_19614_)) {
                int lvl = livingAttacker.m_21124_((MobEffect)MobEffectRegistry.SPIDER_ASPECT.get()).m_19564_() + 1;
                float before = event.getAmount();
                float multiplier = 1.0f + 0.05f * (float)lvl;
                event.setAmount(event.getAmount() * multiplier);
            }
            if (livingAttacker.m_20145_() && ((CurioBaseItem)((Object)ItemRegistry.LURKER_RING.get())).isEquippedBy(livingAttacker) && livingAttacker instanceof Player && !(player = (Player)livingAttacker).m_36335_().m_41519_((Item)ItemRegistry.LURKER_RING.get())) {
                event.setAmount(event.getAmount() * 1.5f);
                player.m_36335_().m_41524_((Item)ItemRegistry.LURKER_RING.get(), 300);
            }
        }
        if ((playerMagicData = MagicData.getPlayerMagicData(event.getEntity())).getSyncedData().hasEffect(4L)) {
            playerMagicData.getSyncedData().addHeartstopDamage(event.getAmount() * 0.5f);
            event.setCanceled(true);
            return;
        }
        LivingEntity livingEntity2 = event.getEntity();
        if (livingEntity2 instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity2;
            if (playerMagicData.isCasting() && playerMagicData.getCastingSpell().getSpell().canBeInterrupted((Player)serverPlayer) && playerMagicData.getCastDurationRemaining() > 0 && !event.getSource().m_269533_(DamageTypeTagGenerator.LONG_CAST_IGNORE)) {
                Utils.serverSideCancelCast(serverPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityMountEvent(EntityMountEvent event) {
        ServerPlayer serverPlayer;
        MagicData playerMagicData;
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer && (playerMagicData = MagicData.getPlayerMagicData((LivingEntity)(serverPlayer = (ServerPlayer)entity))).isCasting()) {
            Utils.serverSideCancelCast(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void preventDismount(EntityMountEvent event) {
        if (!event.getEntity().f_19853_.f_46443_ && event.getEntityBeingMounted() instanceof PreventDismount && event.isDismounting() && !event.getEntityBeingMounted().m_213877_()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        EntityHitResult entityHitResult;
        Entity victim;
        HitResult hitResult = event.getRayTraceResult();
        if (hitResult instanceof EntityHitResult && ((victim = (entityHitResult = (EntityHitResult)hitResult).m_82443_()) instanceof AbstractSpellCastingMob || victim instanceof Player)) {
            SyncedSpellData syncedSpellData;
            LivingEntity livingEntity = (LivingEntity)victim;
            SyncedSpellData syncedSpellData2 = syncedSpellData = livingEntity.f_19853_.f_46443_ ? ClientMagicData.getSyncedSpellData(livingEntity) : MagicData.getPlayerMagicData(livingEntity).getSyncedData();
            if (syncedSpellData.hasEffect(2L)) {
                if (EvasionEffect.doEffect(livingEntity, victim.m_269291_().m_269104_((Entity)event.getProjectile(), event.getProjectile().m_19749_()))) {
                    event.setCanceled(true);
                }
            } else if (syncedSpellData.hasEffect(8L) && AbyssalShroudEffect.doEffect(livingEntity, victim.m_269291_().m_269104_((Entity)event.getProjectile(), event.getProjectile().m_19749_()))) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void useOnEntityEvent(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity entity = event.getTarget();
        if (entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            Player player = event.getEntity();
            ItemStack useItem = player.m_21120_(event.getHand());
            if (useItem.m_150930_(Items.f_42590_) && creeper.m_7090_()) {
                creeper.m_6469_(creeper.m_269291_().m_269264_(), 5.0f);
                player.f_19853_.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11771_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                player.m_6674_(event.getHand());
                event.setCancellationResult(InteractionResultHolder.m_19096_((Object)ItemUtils.m_41813_((ItemStack)useItem, (Player)player, (ItemStack)new ItemStack((ItemLike)ItemRegistry.LIGHTNING_BOTTLE.get()))).m_19089_());
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void handleResistanceAttributesOnSpawn(MobSpawnEvent event) {
        Mob mob = event.getEntity();
        if (mob.m_6336_() == MobType.f_21641_) {
            mob.m_21204_().m_22146_((Attribute)AttributeRegistry.HOLY_MAGIC_RESIST.get()).m_22100_(0.5);
            mob.m_21204_().m_22146_((Attribute)AttributeRegistry.BLOOD_MAGIC_RESIST.get()).m_22100_(1.5);
        } else if (mob.m_6336_() == MobType.f_21644_) {
            mob.m_21204_().m_22146_((Attribute)AttributeRegistry.LIGHTNING_MAGIC_RESIST.get()).m_22100_(0.5);
        }
        if (mob.m_5825_()) {
            mob.m_21204_().m_22146_((Attribute)AttributeRegistry.FIRE_MAGIC_RESIST.get()).m_22100_(1.5);
        }
        if (mob.m_6095_() == EntityType.f_20551_) {
            mob.m_21204_().m_22146_((Attribute)AttributeRegistry.ICE_MAGIC_RESIST.get()).m_22100_(0.5);
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        BlockPos pos;
        BlockState blockState;
        LivingEntity entity = event.getEntity();
        Level level = entity.f_19853_;
        if (!level.f_46443_ && entity.f_19797_ % 20 == 0 && (blockState = entity.f_19853_.m_8055_(pos = entity.m_20183_())).m_60713_(Blocks.f_50256_)) {
            BloodCauldronBlock.attemptCookEntity(blockState, entity.f_19853_, pos, (Entity)entity, () -> {
                level.m_46597_(pos, ((Block)BlockRegistry.BLOOD_CAULDRON_BLOCK.get()).m_49966_());
                level.m_142346_(null, GameEvent.f_157792_, pos);
            });
        }
    }

    @SubscribeEvent
    public static void onAnvilRecipe(AnvilUpdateEvent event) {
        if (event.getRight().m_150930_((Item)ItemRegistry.SHRIVING_STONE.get())) {
            ItemStack newResult = event.getLeft().m_41777_();
            if (newResult.m_150930_((Item)ItemRegistry.SCROLL.get())) {
                return;
            }
            boolean flag = false;
            if (SpellData.hasSpellData(newResult)) {
                newResult.m_41749_("ISB_spell");
                flag = true;
            } else if (UpgradeData.hasUpgradeData(newResult)) {
                newResult.m_41749_("ISBUpgrades");
                flag = true;
            }
            if (flag) {
                String itemName = event.getName();
                if (itemName != null && !Util.m_288217_((String)itemName)) {
                    if (!itemName.equals(newResult.m_41786_().getString())) {
                        newResult.m_41714_((Component)Component.m_237113_((String)itemName));
                    }
                } else if (newResult.m_41788_()) {
                    newResult.m_41787_();
                }
                event.setOutput(newResult);
                event.setCost(1);
                event.setMaterialCost(1);
            }
        }
    }

    @SubscribeEvent
    public static void changeDigSpeed(PlayerEvent.BreakSpeed event) {
        int i;
        Player player = event.getEntity();
        if (player.m_21023_((MobEffect)MobEffectRegistry.HASTENED.get())) {
            i = 1 + player.m_21124_((MobEffect)MobEffectRegistry.HASTENED.get()).m_19564_();
            event.setNewSpeed(event.getNewSpeed() * Utils.intPow(1.2f, i));
        }
        if (player.m_21023_((MobEffect)MobEffectRegistry.SLOWED.get())) {
            i = 1 + player.m_21124_((MobEffect)MobEffectRegistry.SLOWED.get()).m_19564_();
            event.setNewSpeed(event.getNewSpeed() * Utils.intPow(0.8f, i));
        }
    }
}

