/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.evocation;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.entity.spells.spectral_hammer.SpectralHammer;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class SpectralHammerSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("irons_spellbooks", "spectral_hammer");
    private static final int distance = 12;
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(SchoolRegistry.EVOCATION_RESOURCE).setMaxLevel(5).setCooldownSeconds(10.0).build();

    @Override
    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.dimensions", (Object[])new Object[]{1 + this.getRadius(spellLevel, caster) * 2, 1 + this.getRadius(spellLevel, caster) * 2, this.getDepth(spellLevel, caster) + 1}), Component.m_237110_((String)"ui.irons_spellbooks.distance", (Object[])new Object[]{12}));
    }

    public SpectralHammerSpell() {
        this.manaCostPerLevel = 5;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 25;
        this.baseManaCost = 15;
    }

    @Override
    public CastType getCastType() {
        return CastType.INSTANT;
    }

    @Override
    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    @Override
    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    @Override
    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        return Utils.getTargetBlock(level, entity, ClipContext.Fluid.NONE, 12.0).m_6662_() == HitResult.Type.BLOCK;
    }

    @Override
    public void onCast(Level world, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        BlockHitResult blockPosition = Utils.getTargetBlock(world, entity, ClipContext.Fluid.NONE, 12.0);
        Direction face = blockPosition.m_82434_();
        int radius = this.getRadius(spellLevel, entity);
        int depth = this.getDepth(spellLevel, entity);
        SpectralHammer spectralHammer = new SpectralHammer(world, entity, blockPosition, depth, radius);
        Vec3 position = Vec3.m_82512_((Vec3i)blockPosition.m_82425_());
        if (!face.m_122434_().m_122478_()) {
            position = position.m_82492_(0.0, 2.0, 0.0).m_82546_(entity.m_20156_().m_82541_().m_82490_(1.5));
        } else if (face == Direction.DOWN) {
            position = position.m_82492_(0.0, 3.0, 0.0);
        }
        spectralHammer.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
        world.m_7967_((Entity)spectralHammer);
        super.onCast(world, spellLevel, entity, playerMagicData);
    }

    private int getDepth(int spellLevel, LivingEntity caster) {
        return (int)this.getSpellPower(spellLevel, (Entity)caster);
    }

    private int getRadius(int spellLevel, LivingEntity caster) {
        return (int)Math.max(this.getSpellPower(spellLevel, (Entity)caster) * 0.5f, 1.0f);
    }
}

