/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.ice;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.entity.mobs.SummonedPolarBear;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class SummonPolarBearSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("irons_spellbooks", "summon_polar_bear");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.ICE_RESOURCE).setMaxLevel(10).setCooldownSeconds(180.0).build();

    @Override
    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.hp", (Object[])new Object[]{Float.valueOf(this.getBearHealth(spellLevel, null))}), Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Float.valueOf(this.getBearDamage(spellLevel, null))}));
    }

    public SummonPolarBearSpell() {
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 4;
        this.spellPowerPerLevel = 1;
        this.castTime = 20;
        this.baseManaCost = 50;
    }

    @Override
    public CastType getCastType() {
        return CastType.LONG;
    }

    @Override
    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    @Override
    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of(SoundEvents.f_11868_);
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    @Override
    public void onCast(Level world, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        int summonTime = 12000;
        SummonedPolarBear polarBear = new SummonedPolarBear(world, entity);
        polarBear.m_146884_(entity.m_20182_());
        polarBear.m_21204_().m_22146_(Attributes.f_22281_).m_22100_((double)this.getBearDamage(spellLevel, entity));
        polarBear.m_21204_().m_22146_(Attributes.f_22276_).m_22100_((double)this.getBearHealth(spellLevel, entity));
        polarBear.m_21153_(polarBear.m_21233_());
        world.m_7967_((Entity)polarBear);
        polarBear.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.POLAR_BEAR_TIMER.get(), summonTime, 0, false, false, false));
        int effectAmplifier = 0;
        if (entity.m_21023_((MobEffect)MobEffectRegistry.POLAR_BEAR_TIMER.get())) {
            effectAmplifier += entity.m_21124_((MobEffect)MobEffectRegistry.POLAR_BEAR_TIMER.get()).m_19564_() + 1;
        }
        entity.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.POLAR_BEAR_TIMER.get(), summonTime, effectAmplifier, false, false, true));
        super.onCast(world, spellLevel, entity, playerMagicData);
    }

    private float getBearHealth(int spellLevel, LivingEntity caster) {
        return 20 + this.getLevel(spellLevel, caster) * 4;
    }

    private float getBearDamage(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster);
    }
}

