/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.screens;

import com.direwolf20.laserio.client.screens.LaserGuiGraphics;
import com.direwolf20.laserio.client.screens.LaserGuiGraphicsFluid;
import com.direwolf20.laserio.client.screens.widgets.ChannelButton;
import com.direwolf20.laserio.client.screens.widgets.NumberButton;
import com.direwolf20.laserio.client.screens.widgets.ToggleButton;
import com.direwolf20.laserio.common.containers.CardItemContainer;
import com.direwolf20.laserio.common.containers.customhandler.FilterBasicHandler;
import com.direwolf20.laserio.common.containers.customslot.CardHolderSlot;
import com.direwolf20.laserio.common.containers.customslot.CardItemSlot;
import com.direwolf20.laserio.common.containers.customslot.CardOverclockSlot;
import com.direwolf20.laserio.common.containers.customslot.FilterBasicSlot;
import com.direwolf20.laserio.common.items.CardHolder;
import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.cards.CardItem;
import com.direwolf20.laserio.common.items.cards.CardRedstone;
import com.direwolf20.laserio.common.items.filters.BaseFilter;
import com.direwolf20.laserio.common.items.filters.FilterBasic;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.common.items.filters.FilterMod;
import com.direwolf20.laserio.common.items.filters.FilterNBT;
import com.direwolf20.laserio.common.items.filters.FilterTag;
import com.direwolf20.laserio.common.network.PacketHandler;
import com.direwolf20.laserio.common.network.packets.PacketGhostSlot;
import com.direwolf20.laserio.common.network.packets.PacketOpenFilter;
import com.direwolf20.laserio.common.network.packets.PacketOpenNode;
import com.direwolf20.laserio.common.network.packets.PacketUpdateCard;
import com.direwolf20.laserio.common.network.packets.PacketUpdateFilter;
import com.direwolf20.laserio.util.MiscTools;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import net.minecraftforge.items.ItemHandlerHelper;

public class CardItemScreen
extends AbstractContainerScreen<CardItemContainer> {
    private final ResourceLocation GUI = new ResourceLocation("laserio", "textures/gui/itemcard.png");
    protected final CardItemContainer container;
    protected byte currentMode;
    protected byte currentChannel;
    protected byte currentRedstoneChannel;
    protected byte currentItemExtractAmt;
    protected short currentPriority;
    protected byte currentSneaky;
    protected int currentTicks;
    protected boolean currentExact;
    protected int currentRoundRobin;
    protected boolean currentRegulate;
    protected boolean currentAndMode;
    protected int isAllowList = -1;
    protected int isCompareNBT = -1;
    protected boolean showFilter;
    protected boolean showAllow;
    protected boolean showNBT;
    protected final ItemStack card;
    public ItemStack filter;
    protected Map<String, Button> buttons = new HashMap<String, Button>();
    protected byte currentRedstoneMode;
    protected boolean renderFluids = false;
    private boolean showCardHolderUI;
    protected final String[] sneakyNames = new String[]{"screen.laserio.default", "screen.laserio.down", "screen.laserio.up", "screen.laserio.north", "screen.laserio.south", "screen.laserio.west", "screen.laserio.east"};

    public CardItemScreen(CardItemContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.container = container;
        this.card = container.cardItem;
        this.filter = ((Slot)container.f_38839_.get(0)).m_7993_();
        this.showCardHolderUI = container.cardHolder.m_41619_();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Button andButton;
        Button nbtButton;
        Button allowList;
        Button speedButton;
        Button exact;
        Button redstoneMode;
        Button roundrobin;
        Button regulate;
        Button amountButton;
        Button sneakyButton;
        Button redstoneChannelButton;
        Button channelButton;
        this.validateHolder();
        this.m_280273_(guiGraphics);
        this.toggleFilterSlots();
        GuiGraphics guiGraphics2 = guiGraphics = this.renderFluids ? new LaserGuiGraphicsFluid(Minecraft.m_91087_(), guiGraphics.m_280091_(), this) : new LaserGuiGraphics(Minecraft.m_91087_(), guiGraphics.m_280091_());
        if (this.showFilter) {
            this.updateItemCounts();
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        Button modeButton = this.buttons.get("mode");
        if (MiscTools.inBounds(modeButton.m_252754_(), modeButton.m_252907_(), modeButton.m_5711_(), modeButton.m_93694_(), mouseX, mouseY)) {
            MutableComponent[] translatableComponents = new MutableComponent[]{Component.m_237115_((String)"screen.laserio.insert"), Component.m_237115_((String)"screen.laserio.extract"), Component.m_237115_((String)"screen.laserio.stock"), Component.m_237115_((String)"screen.laserio.sensor")};
            guiGraphics.m_280557_(this.f_96547_, (Component)translatableComponents[this.currentMode], mouseX, mouseY);
        }
        if (MiscTools.inBounds((channelButton = this.buttons.get("channel")).m_252754_(), channelButton.m_252907_(), channelButton.m_5711_(), channelButton.m_93694_(), mouseX, mouseY)) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.channel").m_130946_(String.valueOf(this.currentChannel)), mouseX, mouseY);
        }
        if (MiscTools.inBounds((redstoneChannelButton = this.buttons.get("redstoneChannel")).m_252754_(), redstoneChannelButton.m_252907_(), redstoneChannelButton.m_5711_(), redstoneChannelButton.m_93694_(), mouseX, mouseY)) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.redstonechannel").m_130946_(String.valueOf(this.currentRedstoneChannel)), mouseX, mouseY);
        }
        if (MiscTools.inBounds((sneakyButton = this.buttons.get("sneaky")).m_252754_(), sneakyButton.m_252907_(), sneakyButton.m_5711_(), sneakyButton.m_93694_(), mouseX, mouseY)) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)String.valueOf(this.sneakyNames[this.currentSneaky + 1])), mouseX, mouseY);
        }
        if (MiscTools.inBounds((amountButton = this.buttons.get("amount")).m_252754_(), amountButton.m_252907_(), amountButton.m_5711_(), amountButton.m_93694_(), mouseX, mouseY)) {
            if (this.showExtractAmt()) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.extractamt"), mouseX, mouseY);
            }
            if (this.showPriority()) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.priority"), mouseX, mouseY);
            }
        }
        if (MiscTools.inBounds((regulate = this.buttons.get("regulate")).m_252754_(), regulate.m_252907_(), regulate.m_5711_(), regulate.m_93694_(), mouseX, mouseY) && this.showRegulate()) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.regulate"), mouseX, mouseY);
        }
        if (MiscTools.inBounds((roundrobin = this.buttons.get("roundrobin")).m_252754_(), roundrobin.m_252907_(), roundrobin.m_5711_(), roundrobin.m_93694_(), mouseX, mouseY) && this.showRoundRobin()) {
            MutableComponent[] translatableComponents = new MutableComponent[]{Component.m_237115_((String)"screen.laserio.false"), Component.m_237115_((String)"screen.laserio.true"), Component.m_237115_((String)"screen.laserio.enforced")};
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.roundrobin").m_7220_((Component)translatableComponents[this.currentRoundRobin]), mouseX, mouseY);
        }
        if (MiscTools.inBounds((redstoneMode = this.buttons.get("redstoneMode")).m_252754_(), redstoneMode.m_252907_(), redstoneMode.m_5711_(), redstoneMode.m_93694_(), mouseX, mouseY)) {
            MutableComponent[] translatableComponents = new MutableComponent[]{Component.m_237115_((String)"screen.laserio.ignored"), Component.m_237115_((String)"screen.laserio.low"), Component.m_237115_((String)"screen.laserio.high")};
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.redstoneMode").m_7220_((Component)translatableComponents[this.currentRedstoneMode]), mouseX, mouseY);
        }
        if (MiscTools.inBounds((exact = this.buttons.get("exact")).m_252754_(), exact.m_252907_(), exact.m_5711_(), exact.m_93694_(), mouseX, mouseY) && this.showExactAmt()) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.exact"), mouseX, mouseY);
        }
        if (MiscTools.inBounds((speedButton = this.buttons.get("speed")).m_252754_(), speedButton.m_252907_(), speedButton.m_5711_(), speedButton.m_93694_(), mouseX, mouseY) && !this.showPriority()) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.tickSpeed"), mouseX, mouseY);
        }
        if (this.showAllow && MiscTools.inBounds((allowList = this.buttons.get("allowList")).m_252754_(), allowList.m_252907_(), allowList.m_5711_(), allowList.m_93694_(), mouseX, mouseY)) {
            if (this.isAllowList == 1) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.allowlist"), mouseX, mouseY);
            } else {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.denylist"), mouseX, mouseY);
            }
        }
        if (this.showNBT && MiscTools.inBounds((nbtButton = this.buttons.get("nbt")).m_252754_(), nbtButton.m_252907_(), nbtButton.m_5711_(), nbtButton.m_93694_(), mouseX, mouseY)) {
            if (this.isCompareNBT == 1) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.nbttrue"), mouseX, mouseY);
            } else {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.nbtfalse"), mouseX, mouseY);
            }
        }
        if (BaseCard.getNamedTransferMode(this.card) == BaseCard.TransferMode.SENSOR && MiscTools.inBounds((andButton = this.buttons.get("and")).m_252754_(), andButton.m_252907_(), andButton.m_5711_(), andButton.m_93694_(), mouseX, mouseY)) {
            if (this.currentAndMode) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.and"), mouseX, mouseY);
            } else {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.or"), mouseX, mouseY);
            }
        }
    }

    public boolean validateHolder() {
        Inventory playerInventory = this.container.playerEntity.m_150109_();
        for (int i = 0; i < playerInventory.f_35974_.size(); ++i) {
            ItemStack itemStack = (ItemStack)playerInventory.f_35974_.get(i);
            if (!(itemStack.m_41720_() instanceof CardHolder) || !CardHolder.getUUID(itemStack).equals(this.container.cardHolderUUID)) continue;
            this.showCardHolderUI = true;
            this.toggleHolderSlots();
            return true;
        }
        this.showCardHolderUI = false;
        this.toggleHolderSlots();
        return false;
    }

    public void toggleHolderSlots() {
        for (int i = 17; i < 32; ++i) {
            Slot slot;
            if (i >= this.container.f_38839_.size() || !((slot = this.container.m_38853_(i)) instanceof CardHolderSlot)) continue;
            ((CardHolderSlot)slot).setEnabled(this.showCardHolderUI);
        }
    }

    protected boolean m_7467_(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        if (this.showCardHolderUI) {
            return mouseX < (double)guiLeftIn - 100.0 || mouseY < (double)guiTopIn || mouseX >= (double)(guiLeftIn + this.f_97726_) || mouseY >= (double)(guiTopIn + this.f_97727_);
        }
        return super.m_7467_(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton);
    }

    public void updateItemCounts() {
        FilterBasicHandler handler = this.container.filterHandler;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            stack.m_41764_(this.container.getStackSize(i + 2));
        }
    }

    public void addAmtButton() {
        this.buttons.put("amount", new NumberButton(this.getGuiLeft() + 147, this.getGuiTop() + 25, 24, 12, this.currentMode == 0 ? this.currentPriority : (short)this.currentItemExtractAmt, button -> this.changeAmount(-1)));
    }

    public void addModeButton() {
        ResourceLocation[] modeTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/modeinserter.png"), new ResourceLocation("laserio", "textures/gui/buttons/modeextractor.png"), new ResourceLocation("laserio", "textures/gui/buttons/modestocker.png"), new ResourceLocation("laserio", "textures/gui/buttons/modesensor.png")};
        this.buttons.put("mode", new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 5, 16, 16, modeTextures, this.currentMode, button -> {
            this.currentMode = BaseCard.nextTransferMode(this.card);
            ((ToggleButton)button).setTexturePosition(this.currentMode);
            ((NumberButton)this.buttons.get("amount")).setValue(this.currentMode == 0 ? this.currentPriority : (short)this.currentItemExtractAmt);
            this.modeChange();
        }));
    }

    public void addRedstoneButton() {
        ResourceLocation[] redstoneTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/redstoneignore.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstonelow.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstonehigh.png")};
        this.buttons.put("redstoneMode", new ToggleButton(this.getGuiLeft() + 105, this.getGuiTop() + 5, 16, 16, redstoneTextures, this.currentRedstoneMode, button -> {
            this.currentRedstoneMode = (byte)(this.currentRedstoneMode == 2 ? 0 : this.currentRedstoneMode + 1);
            ((ToggleButton)button).setTexturePosition(this.currentRedstoneMode);
        }));
    }

    public void addRedstoneChannelButton() {
        this.buttons.put("redstoneChannel", new ChannelButton(this.getGuiLeft() + 125, this.getGuiTop() + 5, 16, 16, this.currentRedstoneChannel, button -> {
            this.currentRedstoneChannel = CardRedstone.nextRedstoneChannel(this.card);
            ((ChannelButton)button).setChannel(this.currentRedstoneChannel);
        }));
    }

    public void m_7856_() {
        super.m_7856_();
        Minecraft minecraft = Minecraft.m_91087_();
        BlockEntityWithoutLevelRenderer blockentitywithoutlevelrenderer = new BlockEntityWithoutLevelRenderer(minecraft.m_167982_(), minecraft.m_167973_());
        this.currentMode = BaseCard.getTransferMode(this.card);
        this.currentChannel = BaseCard.getChannel(this.card);
        this.currentItemExtractAmt = CardItem.getItemExtractAmt(this.card);
        this.currentPriority = BaseCard.getPriority(this.card);
        this.currentSneaky = BaseCard.getSneaky(this.card);
        this.currentTicks = BaseCard.getExtractSpeed(this.card);
        this.currentExact = BaseCard.getExact(this.card);
        this.currentRoundRobin = BaseCard.getRoundRobin(this.card);
        this.currentRegulate = BaseCard.getRegulate(this.card);
        this.currentRedstoneMode = BaseCard.getRedstoneMode(this.card);
        this.currentRedstoneChannel = BaseCard.getRedstoneChannel(this.card);
        this.currentAndMode = BaseCard.getAnd(this.card);
        boolean bl = this.showFilter = this.filter != null && !this.filter.m_41619_() && !(this.filter.m_41720_() instanceof FilterTag);
        if (this.showFilter) {
            this.isAllowList = BaseFilter.getAllowList(this.filter) ? 1 : 0;
            int n = this.isCompareNBT = BaseFilter.getCompareNBT(this.filter) ? 1 : 0;
            if (this.filter.m_41720_() instanceof FilterMod) {
                this.showAllow = true;
                this.showNBT = false;
            } else if (this.filter.m_41720_() instanceof FilterBasic) {
                this.showAllow = true;
                this.showNBT = true;
            } else if (this.filter.m_41720_() instanceof FilterCount) {
                this.showAllow = false;
                this.showNBT = true;
            } else if (this.filter.m_41720_() instanceof FilterNBT) {
                this.showAllow = true;
                this.showNBT = false;
            }
            if (BaseCard.getNamedTransferMode(this.card) == BaseCard.TransferMode.SENSOR) {
                this.showAllow = false;
            }
        } else {
            this.isAllowList = -1;
            this.isCompareNBT = -1;
        }
        ResourceLocation[] allowListTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/allowlistfalse.png"), new ResourceLocation("laserio", "textures/gui/buttons/allowlisttrue.png")};
        this.buttons.put("allowList", new ToggleButton(this.getGuiLeft() + 135, this.getGuiTop() + 61, 16, 16, allowListTextures, this.isAllowList == 1 ? 1 : 0, button -> {
            this.isAllowList = this.isAllowList == 1 ? 0 : 1;
            ((ToggleButton)button).setTexturePosition(this.isAllowList == 1 ? 1 : 0);
        }));
        ResourceLocation[] nbtTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/matchnbtfalse.png"), new ResourceLocation("laserio", "textures/gui/buttons/matchnbttrue.png")};
        this.buttons.put("nbt", new ToggleButton(this.getGuiLeft() + 153, this.getGuiTop() + 61, 16, 16, nbtTextures, this.isCompareNBT == 1 ? 1 : 0, button -> {
            this.isCompareNBT = this.isCompareNBT == 1 ? 0 : 1;
            ((ToggleButton)button).setTexturePosition(this.isCompareNBT == 1 ? 1 : 0);
        }));
        this.addAmtButton();
        this.buttons.put("speed", new NumberButton(this.getGuiLeft() + 147, this.getGuiTop() + 39, 24, 12, this.currentTicks, button -> this.changeTick(-1)));
        ResourceLocation[] exactTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/exactfalse.png"), new ResourceLocation("laserio", "textures/gui/buttons/exacttrue.png")};
        this.buttons.put("exact", new ToggleButton(this.getGuiLeft() + 25, this.getGuiTop() + 25, 16, 16, exactTextures, this.currentExact ? 1 : 0, button -> {
            this.currentExact = !this.currentExact;
            ((ToggleButton)button).setTexturePosition(this.currentExact ? 1 : 0);
        }));
        ResourceLocation[] roundRobinTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/roundrobinfalse.png"), new ResourceLocation("laserio", "textures/gui/buttons/roundrobintrue.png"), new ResourceLocation("laserio", "textures/gui/buttons/roundrobinenforced.png")};
        this.buttons.put("roundrobin", new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 25, 16, 16, roundRobinTextures, this.currentRoundRobin, button -> {
            this.currentRoundRobin = this.currentRoundRobin == 2 ? 0 : this.currentRoundRobin + 1;
            ((ToggleButton)button).setTexturePosition(this.currentRoundRobin);
        }));
        ResourceLocation[] regulateTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/regulatefalse.png"), new ResourceLocation("laserio", "textures/gui/buttons/regulatetrue.png")};
        this.buttons.put("regulate", new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 25, 16, 16, regulateTextures, this.currentRegulate ? 1 : 0, button -> {
            this.currentRegulate = !this.currentRegulate;
            ((ToggleButton)button).setTexturePosition(this.currentRegulate ? 1 : 0);
        }));
        ResourceLocation[] andTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/or.png"), new ResourceLocation("laserio", "textures/gui/buttons/and.png")};
        this.buttons.put("and", new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 25, 16, 16, andTextures, this.currentAndMode ? 1 : 0, button -> {
            this.currentAndMode = !this.currentAndMode;
            ((ToggleButton)button).setTexturePosition(this.currentAndMode ? 1 : 0);
        }));
        this.addModeButton();
        this.addRedstoneButton();
        this.addRedstoneChannelButton();
        this.buttons.put("channel", new ChannelButton(this.getGuiLeft() + 5, this.getGuiTop() + 65, 16, 16, this.currentChannel, button -> {
            this.currentChannel = BaseCard.nextChannel(this.card);
            ((ChannelButton)button).setChannel(this.currentChannel);
        }));
        ResourceLocation[] sneakyTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/sneaky.png"), new ResourceLocation("laserio", "textures/gui/buttons/sneaky-down.png"), new ResourceLocation("laserio", "textures/gui/buttons/sneaky-up.png"), new ResourceLocation("laserio", "textures/gui/buttons/sneaky-north.png"), new ResourceLocation("laserio", "textures/gui/buttons/sneaky-south.png"), new ResourceLocation("laserio", "textures/gui/buttons/sneaky-west.png"), new ResourceLocation("laserio", "textures/gui/buttons/sneaky-east.png")};
        this.buttons.put("sneaky", new ToggleButton(this.getGuiLeft() + 25, this.getGuiTop() + 5, 16, 16, sneakyTextures, this.currentSneaky + 1, button -> {
            this.currentSneaky = BaseCard.nextSneaky(this.card);
            ((ToggleButton)button).setTexturePosition(this.currentSneaky + 1);
        }));
        if (this.container.direction != -1) {
            this.buttons.put("return", (Button)new ExtendedButton(this.getGuiLeft() - 25, this.getGuiTop() + 1, 25, 20, (Component)Component.m_237113_((String)"<--"), button -> this.openNode()));
        }
        for (Map.Entry<String, Button> button2 : this.buttons.entrySet()) {
            this.m_142416_((GuiEventListener)button2.getValue());
        }
        if (!this.showNBT) {
            this.m_169411_((GuiEventListener)this.buttons.get("nbt"));
        }
        if (!this.showAllow) {
            this.m_169411_((GuiEventListener)this.buttons.get("allowList"));
        }
        if (this.card.m_41613_() > 1) {
            int i = 0;
            while (true) {
                if (i >= 2) break;
                if (i < this.container.f_38839_.size()) {
                    Slot slot = this.container.m_38853_(i);
                    if (slot instanceof CardItemSlot) {
                        CardItemSlot cardItemSlot = (CardItemSlot)slot;
                        cardItemSlot.setEnabled(false);
                    }
                    if (slot instanceof CardOverclockSlot) {
                        CardOverclockSlot cardOverclockSlot = (CardOverclockSlot)slot;
                        cardOverclockSlot.setEnabled(false);
                    }
                }
                ++i;
            }
        }
        this.modeChange();
    }

    public void modeChange() {
        Button speedButton = this.buttons.get("speed");
        Button exactButton = this.buttons.get("exact");
        Button rrButton = this.buttons.get("roundrobin");
        Button regulateButton = this.buttons.get("regulate");
        Button channelButton = this.buttons.get("channel");
        Button amountButton = this.buttons.get("amount");
        Button andButton = this.buttons.get("and");
        Button redstoneModeButton = this.buttons.get("redstoneMode");
        if (this.currentMode == 0) {
            if (!this.f_169369_.contains(channelButton)) {
                this.m_142416_((GuiEventListener)channelButton);
            }
            if (!this.f_169369_.contains(amountButton)) {
                this.m_142416_((GuiEventListener)amountButton);
            }
            if (!this.f_169369_.contains(redstoneModeButton)) {
                this.m_142416_((GuiEventListener)redstoneModeButton);
            }
            this.m_169411_((GuiEventListener)speedButton);
            this.m_169411_((GuiEventListener)exactButton);
            this.m_169411_((GuiEventListener)rrButton);
            this.m_169411_((GuiEventListener)regulateButton);
            this.m_169411_((GuiEventListener)andButton);
        } else if (this.currentMode == 1) {
            if (!this.f_169369_.contains(channelButton)) {
                this.m_142416_((GuiEventListener)channelButton);
            }
            if (!this.f_169369_.contains(amountButton)) {
                this.m_142416_((GuiEventListener)amountButton);
            }
            if (!this.f_169369_.contains(speedButton)) {
                this.m_142416_((GuiEventListener)speedButton);
            }
            if (!this.f_169369_.contains(exactButton)) {
                this.m_142416_((GuiEventListener)exactButton);
            }
            if (!this.f_169369_.contains(rrButton)) {
                this.m_142416_((GuiEventListener)rrButton);
            }
            if (!this.f_169369_.contains(redstoneModeButton)) {
                this.m_142416_((GuiEventListener)redstoneModeButton);
            }
            this.m_169411_((GuiEventListener)regulateButton);
            this.m_169411_((GuiEventListener)andButton);
        } else if (this.currentMode == 2) {
            if (!this.f_169369_.contains(channelButton)) {
                this.m_142416_((GuiEventListener)channelButton);
            }
            if (!this.f_169369_.contains(amountButton)) {
                this.m_142416_((GuiEventListener)amountButton);
            }
            if (!this.f_169369_.contains(speedButton)) {
                this.m_142416_((GuiEventListener)speedButton);
            }
            if (!this.f_169369_.contains(exactButton)) {
                this.m_142416_((GuiEventListener)exactButton);
            }
            if (!this.f_169369_.contains(regulateButton)) {
                this.m_142416_((GuiEventListener)regulateButton);
            }
            if (!this.f_169369_.contains(redstoneModeButton)) {
                this.m_142416_((GuiEventListener)redstoneModeButton);
            }
            this.m_169411_((GuiEventListener)rrButton);
            this.m_169411_((GuiEventListener)andButton);
        } else if (this.currentMode == 3) {
            if (!this.f_169369_.contains(speedButton)) {
                this.m_142416_((GuiEventListener)speedButton);
            }
            if (!this.f_169369_.contains(andButton)) {
                this.m_142416_((GuiEventListener)andButton);
            }
            this.m_169411_((GuiEventListener)rrButton);
            this.m_169411_((GuiEventListener)regulateButton);
            this.m_169411_((GuiEventListener)channelButton);
            this.m_169411_((GuiEventListener)amountButton);
            this.m_169411_((GuiEventListener)redstoneModeButton);
            if (this.filter.m_41720_() instanceof FilterCount) {
                if (!this.f_169369_.contains(exactButton)) {
                    this.m_142416_((GuiEventListener)exactButton);
                }
            } else {
                this.m_169411_((GuiEventListener)exactButton);
            }
        }
    }

    public void changeAmount(int change) {
        if (Screen.m_96638_()) {
            change *= 10;
        }
        if (Screen.m_96637_()) {
            change *= 64;
        }
        if (change < 0) {
            if (this.currentMode == 0) {
                this.currentPriority = (short)Math.max(this.currentPriority + change, -4096);
            } else {
                this.currentItemExtractAmt = (byte)Math.max(this.currentItemExtractAmt + change, 1);
            }
        } else if (this.currentMode == 0) {
            this.currentPriority = (short)Math.min(this.currentPriority + change, 4096);
        } else {
            this.currentItemExtractAmt = (byte)Math.min(this.currentItemExtractAmt + change, Math.max(this.container.m_38853_(1).m_7993_().m_41613_() * 16, 8));
        }
    }

    public void changeTick(int change) {
        if (Screen.m_96638_()) {
            change *= 10;
        }
        if (Screen.m_96637_()) {
            change *= 64;
        }
        this.currentTicks = change < 0 ? Math.max(this.currentTicks + change, Math.max(20 - this.container.m_38853_(1).m_7993_().m_41613_() * 5, 1)) : Math.min(this.currentTicks + change, 1200);
    }

    public void toggleFilterSlots() {
        this.filter = ((Slot)this.container.f_38839_.get(0)).m_7993_();
        this.showFilter = !this.filter.m_41619_() && !(this.filter.m_41720_() instanceof FilterTag) && !(this.filter.m_41720_() instanceof FilterNBT);
        Button exactButton = this.buttons.get("exact");
        if (this.showFilter) {
            if (this.filter.m_41720_() instanceof FilterMod) {
                this.showNBT = false;
                if (this.currentMode == 2) {
                    this.showAllow = true;
                } else {
                    this.showAllow = true;
                    if (!this.f_169369_.contains(this.buttons.get("allowList"))) {
                        this.m_142416_((GuiEventListener)this.buttons.get("allowList"));
                    }
                }
            } else if (this.filter.m_41720_() instanceof FilterBasic) {
                this.showNBT = true;
                if (this.currentMode == 2) {
                    this.showAllow = true;
                } else {
                    this.showAllow = true;
                    if (!this.f_169369_.contains(this.buttons.get("allowList"))) {
                        this.m_142416_((GuiEventListener)this.buttons.get("allowList"));
                    }
                }
            } else if (this.filter.m_41720_() instanceof FilterCount) {
                this.showAllow = false;
                this.showNBT = true;
                this.m_169411_((GuiEventListener)this.buttons.get("allowList"));
            }
            if (BaseCard.getNamedTransferMode(this.card) == BaseCard.TransferMode.SENSOR) {
                this.showAllow = false;
                this.m_169411_((GuiEventListener)this.buttons.get("allowList"));
                if (this.filter.m_41720_() instanceof FilterCount) {
                    if (!this.f_169369_.contains(exactButton)) {
                        this.m_142416_((GuiEventListener)exactButton);
                    }
                } else {
                    this.m_169411_((GuiEventListener)exactButton);
                }
            }
            if (this.isAllowList == -1) {
                this.isAllowList = BaseFilter.getAllowList(this.filter) ? 1 : 0;
                ((ToggleButton)this.buttons.get("allowList")).setTexturePosition(this.isAllowList == 1 ? 1 : 0);
                this.isCompareNBT = BaseFilter.getCompareNBT(this.filter) ? 1 : 0;
                ((ToggleButton)this.buttons.get("nbt")).setTexturePosition(this.isCompareNBT == 1 ? 1 : 0);
                if (this.showAllow) {
                    this.m_142416_((GuiEventListener)this.buttons.get("allowList"));
                }
                if (this.showNBT) {
                    this.m_142416_((GuiEventListener)this.buttons.get("nbt"));
                }
            }
        } else {
            this.isAllowList = -1;
            this.isCompareNBT = -1;
            this.m_169411_((GuiEventListener)this.buttons.get("allowList"));
            this.m_169411_((GuiEventListener)this.buttons.get("nbt"));
            this.showAllow = false;
            this.showNBT = false;
            if (BaseCard.getNamedTransferMode(this.card) == BaseCard.TransferMode.SENSOR) {
                this.m_169411_((GuiEventListener)exactButton);
            }
        }
        int i = 2;
        while (true) {
            Slot slot;
            if (i >= 2 + 15) break;
            if (i < this.container.f_38839_.size() && (slot = this.container.m_38853_(i)) instanceof FilterBasicSlot) {
                ((FilterBasicSlot)slot).setEnabled(this.showFilter);
            }
            ++i;
        }
    }

    private boolean showExtractAmt() {
        return this.card.m_41720_() instanceof BaseCard && BaseCard.getNamedTransferMode(this.card) != BaseCard.TransferMode.INSERT && BaseCard.getNamedTransferMode(this.card) != BaseCard.TransferMode.SENSOR;
    }

    private boolean showExactAmt() {
        if (BaseCard.getNamedTransferMode(this.card) == BaseCard.TransferMode.SENSOR) {
            return this.filter.m_41720_() instanceof FilterCount;
        }
        return this.card.m_41720_() instanceof BaseCard && BaseCard.getNamedTransferMode(this.card) != BaseCard.TransferMode.INSERT;
    }

    private boolean showPriority() {
        return this.card.m_41720_() instanceof BaseCard && BaseCard.getNamedTransferMode(this.card) == BaseCard.TransferMode.INSERT;
    }

    private boolean showRegulate() {
        return this.card.m_41720_() instanceof BaseCard && BaseCard.getNamedTransferMode(this.card) == BaseCard.TransferMode.STOCK;
    }

    private boolean showRoundRobin() {
        return this.card.m_41720_() instanceof BaseCard && BaseCard.getNamedTransferMode(this.card) == BaseCard.TransferMode.EXTRACT;
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(this.GUI, relX, relY, 0, 0, this.f_97726_, this.f_97727_);
        this.filter = ((Slot)this.container.f_38839_.get(0)).m_7993_();
        if (this.showFilter) {
            int slotsWidth = 90;
            int slotsHeight = 54;
            guiGraphics.m_280218_(this.GUI, relX += 43, relY += 24, 0, 167, slotsWidth, slotsHeight);
        }
        if (this.showCardHolderUI) {
            ResourceLocation CardHolderGUI = new ResourceLocation("laserio", "textures/gui/cardholder_node.png");
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)CardHolderGUI);
            guiGraphics.m_280218_(CardHolderGUI, this.getGuiLeft() - 100, this.getGuiTop() + 24, 0, 0, this.f_97726_, this.f_97727_);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        this.saveSettings();
        super.m_7379_();
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (p_keyPressed_1_ == 256 || this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean m_6348_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return super.m_6348_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private static MutableComponent getTrans(String key, Object ... args) {
        return Component.m_237110_((String)("laserio." + key), (Object[])args);
    }

    public void setExtract(NumberButton amountButton, int btn) {
        if (btn == 0) {
            this.changeAmount(1);
        } else if (btn == 1) {
            this.changeAmount(-1);
        }
        amountButton.setValue(this.currentMode == 0 ? this.currentPriority : (short)this.currentItemExtractAmt);
        amountButton.m_7435_(Minecraft.m_91087_().m_91106_());
    }

    public void saveSettings() {
        if (this.showFilter) {
            PacketHandler.sendToServer(new PacketUpdateFilter(this.isAllowList == 1, this.isCompareNBT == 1));
        }
        PacketHandler.sendToServer(new PacketUpdateCard(this.currentMode, this.currentChannel, this.currentItemExtractAmt, this.currentPriority, this.currentSneaky, (short)this.currentTicks, this.currentExact, this.currentRegulate, (byte)this.currentRoundRobin, 0, 0, this.currentRedstoneMode, this.currentRedstoneChannel, this.currentAndMode));
    }

    public boolean filterSlot(int btn) {
        int amt;
        ItemStack slotStack = this.f_97734_.m_7993_();
        if (slotStack.m_41619_()) {
            return true;
        }
        if (btn == 2) {
            slotStack.m_41764_(0);
            PacketHandler.sendToServer(new PacketGhostSlot(this.f_97734_.f_40219_, slotStack, slotStack.m_41613_()));
            return true;
        }
        int n = amt = btn == 0 ? 1 : -1;
        if (Screen.m_96638_()) {
            amt *= 10;
        }
        if (Screen.m_96637_()) {
            amt *= 64;
        }
        if (amt + slotStack.m_41613_() > 4096) {
            amt = 4096 - slotStack.m_41613_();
        }
        PacketHandler.sendToServer(new PacketGhostSlot(this.f_97734_.f_40219_, slotStack, slotStack.m_41613_() + amt));
        return true;
    }

    public void openNode() {
        this.saveSettings();
        PacketHandler.sendToServer(new PacketOpenNode(this.container.sourceContainer, this.container.direction));
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    public boolean m_6375_(double x, double y, int btn) {
        ChannelButton channelButton = (ChannelButton)this.buttons.get("channel");
        if (MiscTools.inBounds(channelButton.m_252754_(), channelButton.m_252907_(), channelButton.m_5711_(), channelButton.m_93694_(), x, y)) {
            if (btn == 0) {
                this.currentChannel = BaseCard.nextChannel(this.card);
            } else if (btn == 1) {
                this.currentChannel = BaseCard.previousChannel(this.card);
            }
            channelButton.setChannel(this.currentChannel);
            channelButton.m_7435_(Minecraft.m_91087_().m_91106_());
            return true;
        }
        ChannelButton redstoneChannelButton = (ChannelButton)this.buttons.get("redstoneChannel");
        if (MiscTools.inBounds(redstoneChannelButton.m_252754_(), redstoneChannelButton.m_252907_(), redstoneChannelButton.m_5711_(), redstoneChannelButton.m_93694_(), x, y)) {
            if (btn == 0) {
                this.currentRedstoneChannel = BaseCard.nextRedstoneChannel(this.card);
            } else if (btn == 1) {
                this.currentRedstoneChannel = BaseCard.previousRedstoneChannel(this.card);
            }
            redstoneChannelButton.setChannel(this.currentRedstoneChannel);
            redstoneChannelButton.m_7435_(Minecraft.m_91087_().m_91106_());
            return true;
        }
        ToggleButton sneakyButton = (ToggleButton)this.buttons.get("sneaky");
        if (MiscTools.inBounds(sneakyButton.m_252754_(), sneakyButton.m_252907_(), sneakyButton.m_5711_(), sneakyButton.m_93694_(), x, y)) {
            if (btn == 0) {
                this.currentSneaky = BaseCard.nextSneaky(this.card);
                sneakyButton.setTexturePosition(this.currentSneaky + 1);
            } else if (btn == 1) {
                this.currentSneaky = BaseCard.previousSneaky(this.card);
                sneakyButton.setTexturePosition(this.currentSneaky + 1);
            }
            sneakyButton.m_7435_(Minecraft.m_91087_().m_91106_());
            return true;
        }
        NumberButton amountButton = (NumberButton)this.buttons.get("amount");
        if (MiscTools.inBounds(amountButton.m_252754_(), amountButton.m_252907_(), amountButton.m_5711_(), amountButton.m_93694_(), x, y)) {
            this.setExtract(amountButton, btn);
            return true;
        }
        NumberButton speedButton = (NumberButton)this.buttons.get("speed");
        if (MiscTools.inBounds(speedButton.m_252754_(), speedButton.m_252907_(), speedButton.m_5711_(), speedButton.m_93694_(), x, y)) {
            if (btn == 0) {
                this.changeTick(1);
            } else if (btn == 1) {
                this.changeTick(-1);
            }
            speedButton.setValue(this.currentTicks);
            speedButton.m_7435_(Minecraft.m_91087_().m_91106_());
            return true;
        }
        if (this.f_97734_ == null) {
            return super.m_6375_(x, y, btn);
        }
        if (this.f_97734_ instanceof FilterBasicSlot) {
            if (this.filter.m_41720_() instanceof FilterBasic) {
                ItemStack stack = ((CardItemContainer)this.f_97732_).m_142621_();
                if (ItemHandlerHelper.canItemStacksStack((ItemStack)(stack = stack.m_41777_().m_41620_(this.f_97734_.m_6641_())), (ItemStack)this.container.cardItem)) {
                    return true;
                }
                this.f_97734_.m_5852_(stack);
                PacketHandler.sendToServer(new PacketGhostSlot(this.f_97734_.f_40219_, stack, stack.m_41613_()));
            } else if (this.filter.m_41720_() instanceof FilterCount) {
                ItemStack stack = ((CardItemContainer)this.f_97732_).m_142621_();
                if (!stack.m_41619_()) {
                    if (ItemHandlerHelper.canItemStacksStack((ItemStack)(stack = stack.m_41777_()), (ItemStack)this.container.cardItem)) {
                        return true;
                    }
                    this.f_97734_.m_5852_(stack);
                    PacketHandler.sendToServer(new PacketGhostSlot(this.f_97734_.f_40219_, stack, stack.m_41613_()));
                } else {
                    this.filterSlot(btn);
                }
            }
            return true;
        }
        if (this.f_97734_ instanceof CardItemSlot) {
            if (btn == 0) {
                if (this.filter.m_41720_() instanceof BaseFilter && !(this.filter.m_41720_() instanceof FilterTag) && !(this.filter.m_41720_() instanceof FilterNBT)) {
                    PacketHandler.sendToServer(new PacketUpdateFilter(this.isAllowList == 1, this.isCompareNBT == 1));
                }
            } else if (btn == 1) {
                int slot = this.f_97734_.getSlotIndex();
                this.saveSettings();
                PacketHandler.sendToServer(new PacketOpenFilter(slot));
                return true;
            }
        }
        return super.m_6375_(x, y, btn);
    }
}

