/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.screens;

import com.direwolf20.laserio.client.screens.widgets.ChannelButton;
import com.direwolf20.laserio.client.screens.widgets.ToggleButton;
import com.direwolf20.laserio.common.containers.CardRedstoneContainer;
import com.direwolf20.laserio.common.items.cards.CardRedstone;
import com.direwolf20.laserio.common.network.PacketHandler;
import com.direwolf20.laserio.common.network.packets.PacketOpenNode;
import com.direwolf20.laserio.common.network.packets.PacketUpdateRedstoneCard;
import com.direwolf20.laserio.util.MiscTools;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class CardRedstoneScreen
extends AbstractContainerScreen<CardRedstoneContainer> {
    private final ResourceLocation GUI = new ResourceLocation("laserio", "textures/gui/redstonecard.png");
    protected final CardRedstoneContainer container;
    protected byte currentMode;
    protected byte currentRedstoneChannel;
    protected boolean currentStrong;
    protected final ItemStack card;
    protected Map<String, Button> buttons = new HashMap<String, Button>();

    public CardRedstoneScreen(CardRedstoneContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.container = container;
        this.card = container.cardItem;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Button channelButton;
        Button strongButton;
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        Button modeButton = this.buttons.get("mode");
        if (MiscTools.inBounds(modeButton.m_252754_(), modeButton.m_252907_(), modeButton.m_5711_(), modeButton.m_93694_(), mouseX, mouseY)) {
            MutableComponent[] translatableComponents = new MutableComponent[3];
            translatableComponents[0] = Component.m_237115_((String)"screen.laserio.input");
            translatableComponents[1] = Component.m_237115_((String)"screen.laserio.output");
            guiGraphics.m_280557_(this.f_96547_, (Component)translatableComponents[this.currentMode], mouseX, mouseY);
        }
        if (this.currentMode == 1 && MiscTools.inBounds((strongButton = this.buttons.get("strong")).m_252754_(), strongButton.m_252907_(), strongButton.m_5711_(), strongButton.m_93694_(), mouseX, mouseY)) {
            MutableComponent[] translatableComponents = new MutableComponent[]{Component.m_237115_((String)"screen.laserio.weak"), Component.m_237115_((String)"screen.laserio.strong")};
            guiGraphics.m_280557_(this.f_96547_, (Component)translatableComponents[this.currentStrong ? 1 : 0], mouseX, mouseY);
        }
        if (MiscTools.inBounds((channelButton = this.buttons.get("channel")).m_252754_(), channelButton.m_252907_(), channelButton.m_5711_(), channelButton.m_93694_(), mouseX, mouseY)) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.laserio.redstonechannel").m_130946_(String.valueOf(this.currentRedstoneChannel)), mouseX, mouseY);
        }
    }

    public void addModeButton() {
        ResourceLocation[] modeTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/redstoneinput.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstoneoutput.png")};
        this.buttons.put("mode", new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 5, 16, 16, modeTextures, this.currentMode, button -> {
            this.currentMode = CardRedstone.nextTransferMode(this.card);
            ((ToggleButton)button).setTexturePosition(this.currentMode);
            this.modeChange();
        }));
    }

    public void addStrongButton() {
        ResourceLocation[] strongTextures = new ResourceLocation[]{new ResourceLocation("laserio", "textures/gui/buttons/redstonelow.png"), new ResourceLocation("laserio", "textures/gui/buttons/redstonehigh.png")};
        this.buttons.put("strong", new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 25, 16, 16, strongTextures, this.currentStrong ? 1 : 0, button -> {
            this.currentStrong = !this.currentStrong;
            ((ToggleButton)button).setTexturePosition(this.currentStrong ? 1 : 0);
        }));
    }

    public void addChannelButton() {
        this.buttons.put("channel", new ChannelButton(this.getGuiLeft() + 5, this.getGuiTop() + 65, 16, 16, this.currentRedstoneChannel, button -> {
            this.currentRedstoneChannel = CardRedstone.nextRedstoneChannel(this.card);
            ((ChannelButton)button).setChannel(this.currentRedstoneChannel);
        }));
    }

    public void m_7856_() {
        super.m_7856_();
        this.currentMode = CardRedstone.getTransferMode(this.card);
        this.currentRedstoneChannel = CardRedstone.getRedstoneChannel(this.card);
        this.currentStrong = CardRedstone.getStrong(this.card);
        this.addModeButton();
        this.addChannelButton();
        this.addStrongButton();
        if (this.container.direction != -1) {
            this.buttons.put("return", (Button)new ExtendedButton(this.getGuiLeft() - 25, this.getGuiTop() + 1, 25, 20, (Component)Component.m_237113_((String)"<--"), button -> this.openNode()));
        }
        for (Map.Entry<String, Button> button2 : this.buttons.entrySet()) {
            this.m_142416_((GuiEventListener)button2.getValue());
        }
        this.modeChange();
    }

    public void modeChange() {
        Button strongButton = this.buttons.get("strong");
        if (this.currentMode == 0) {
            this.m_169411_((GuiEventListener)strongButton);
        } else if (this.currentMode == 1 && !this.f_169369_.contains(strongButton)) {
            this.m_142416_((GuiEventListener)strongButton);
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(this.GUI, relX, relY, 0, 0, this.f_97726_, this.f_97727_);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        this.saveSettings();
        super.m_7379_();
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (p_keyPressed_1_ == 256 || this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean m_6348_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return super.m_6348_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private static MutableComponent getTrans(String key, Object ... args) {
        return Component.m_237110_((String)("laserio." + key), (Object[])args);
    }

    public void saveSettings() {
        PacketHandler.sendToServer(new PacketUpdateRedstoneCard(this.currentMode, this.currentRedstoneChannel, this.currentStrong));
    }

    public void openNode() {
        this.saveSettings();
        PacketHandler.sendToServer(new PacketOpenNode(this.container.sourceContainer, this.container.direction));
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    public boolean m_6375_(double x, double y, int btn) {
        ChannelButton channelButton = (ChannelButton)this.buttons.get("channel");
        if (MiscTools.inBounds(channelButton.m_252754_(), channelButton.m_252907_(), channelButton.m_5711_(), channelButton.m_93694_(), x, y)) {
            if (btn == 0) {
                this.currentRedstoneChannel = CardRedstone.nextRedstoneChannel(this.card);
            } else if (btn == 1) {
                this.currentRedstoneChannel = CardRedstone.previousRedstoneChannel(this.card);
            }
            channelButton.setChannel(this.currentRedstoneChannel);
            channelButton.m_7435_(Minecraft.m_91087_().m_91106_());
            return true;
        }
        return super.m_6375_(x, y, btn);
    }
}

