/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.util;

import com.direwolf20.laserio.common.items.cards.BaseCard;
import com.direwolf20.laserio.common.items.filters.BaseFilter;
import com.direwolf20.laserio.common.items.upgrades.OverclockerCard;
import com.direwolf20.laserio.common.items.upgrades.OverclockerNode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class ItemStackHandlerProvider
implements ICapabilitySerializable<CompoundTag> {
    private final LazyOptional<ItemStackHandler> holder = LazyOptional.of(() -> new ItemStackHandler(nSlots){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.m_41720_() instanceof BaseCard || stack.m_41720_() instanceof BaseFilter || stack.m_41720_() instanceof OverclockerCard || stack.m_41720_() instanceof OverclockerNode;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 64;
        }
    });

    public ItemStackHandlerProvider(int nSlots) {
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, this.holder.cast());
    }

    public CompoundTag serializeNBT() {
        return this.holder.map(ItemStackHandler::serializeNBT).orElse(new CompoundTag());
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.holder.ifPresent(c -> c.deserializeNBT(nbt));
    }
}

