/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.registry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.biome.BiomeEffects;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.BiomeSpecialEffectsBuilder;
import net.minecraftforge.common.world.ClimateSettingsBuilder;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public class LithostitchedForgeBiomeModifiers {

    public record ReplaceEffectsBiomeModifier(HolderSet<Biome> biomes, BiomeEffects specialEffects) implements BiomeModifier
    {
        public static final Codec<ReplaceEffectsBiomeModifier> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(ReplaceEffectsBiomeModifier::biomes), (App)BiomeEffects.CODEC.fieldOf("effects").forGetter(ReplaceEffectsBiomeModifier::specialEffects)).apply((Applicative)builder, ReplaceEffectsBiomeModifier::new));

        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.MODIFY && this.biomes().m_203333_(biome)) {
                BiomeSpecialEffectsBuilder effects = builder.getSpecialEffects();
                if (this.specialEffects.getSkyColor().isPresent()) {
                    effects.m_48040_(this.specialEffects.getSkyColor().get().intValue());
                }
                if (this.specialEffects.getFogColor().isPresent()) {
                    effects.m_48040_(this.specialEffects.getFogColor().get().intValue());
                }
                if (this.specialEffects.getWaterColor().isPresent()) {
                    effects.m_48040_(this.specialEffects.getWaterColor().get().intValue());
                }
                if (this.specialEffects.getWaterFogColor().isPresent()) {
                    effects.m_48040_(this.specialEffects.getWaterFogColor().get().intValue());
                }
                if (this.specialEffects.getGrassColorOverride().isPresent()) {
                    effects.m_48045_(this.specialEffects.getGrassColorOverride().get().intValue());
                }
                if (this.specialEffects.getFoliageColorOverride().isPresent()) {
                    effects.m_48045_(this.specialEffects.getFoliageColorOverride().get().intValue());
                }
                effects.m_48031_(this.specialEffects.getGrassColorModifier());
                if (this.specialEffects.getAmbientLoopSoundEvent().isPresent()) {
                    effects.m_48023_(this.specialEffects.getAmbientLoopSoundEvent().get());
                }
                if (this.specialEffects.getAmbientMoodSettings().isPresent()) {
                    effects.m_48027_(this.specialEffects.getAmbientMoodSettings().get());
                }
                if (this.specialEffects.getAmbientAdditionsSettings().isPresent()) {
                    effects.m_48025_(this.specialEffects.getAmbientAdditionsSettings().get());
                }
                if (this.specialEffects.getBackgroundMusic().isPresent()) {
                    effects.m_48021_(this.specialEffects.getBackgroundMusic().get());
                }
                if (this.specialEffects.getAmbientParticleSettings().isPresent()) {
                    effects.m_48029_(this.specialEffects.getAmbientParticleSettings().get());
                }
            }
        }

        public Codec<? extends BiomeModifier> codec() {
            return CODEC;
        }
    }

    public record ReplaceClimateBiomeModifier(HolderSet<Biome> biomes, Biome.ClimateSettings climateSettings) implements BiomeModifier
    {
        public static final Codec<ReplaceClimateBiomeModifier> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(ReplaceClimateBiomeModifier::biomes), (App)Biome.ClimateSettings.f_47679_.fieldOf("climate").forGetter(ReplaceClimateBiomeModifier::climateSettings)).apply((Applicative)builder, ReplaceClimateBiomeModifier::new));

        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.MODIFY && this.biomes().m_203333_(biome)) {
                ClimateSettingsBuilder climateSettings = builder.getClimateSettings();
                climateSettings.setTemperature(this.climateSettings().f_47681_());
                climateSettings.setDownfall(this.climateSettings().f_47683_());
                climateSettings.setHasPrecipitation(this.climateSettings().f_263819_());
                climateSettings.setTemperatureModifier(this.climateSettings().f_47682_());
            }
        }

        public Codec<? extends BiomeModifier> codec() {
            return CODEC;
        }
    }
}

